package fuku.skk4j.dic;

import java.io.*;
import java.util.*;

/**
 * SKK뼭񥯥饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class LocalDic implements SKKDic {

    /** ꤢ꼭 */
    private List _ariDic = null;
    /** ʤ */
    private List _nasiDic = null;

    /** ꤢ꼭񥤥ǥå */
    private Hashtable _ariIndex = null;
    /** ʤ񥤥ǥå */
    private Hashtable _nasiIndex = null;

    /** ե */
    private File _file = null;
    /** եΥ󥳡ǥ */
    private String _encoding = null;

    /** ¸ߤ뤫ɤ */
    private boolean _exist = false;
    /** ɤ߹Ǥ뤫ɤ */
    private boolean _load = false;


    /**
     * 󥹥ȥ饯
     *
     * @param fname ե̾
     * @param enc եΥ󥳡ǥ
     */
    public LocalDic(String fname, String enc) {
        super();
        _encoding = enc;
        if (fname != null && fname.length() > 0) {
            _file = new File(fname);
        }
    }


    /**
     * Ƥɤ߹ߡǥåޤ
     *
     */
    private void _open() {
        if (_file == null) {
            _exist = false;
            return;
        }

        try {
            _exist = _file.canRead();
        } catch (SecurityException e) {
            System.err.println(e.getMessage());
            _exist = false;
        }

        if (!_exist) {
            return;
        }

        _ariDic = new ArrayList();
        _nasiDic = new ArrayList();
        _ariIndex = new Hashtable();
        _nasiIndex = new Hashtable();

        List tmpDic = _ariDic;
        Hashtable tmpIndex = _ariIndex;

        BufferedReader in = null;
        String line = null;

        int start = -1;
        int counter = 0;
        char index = ';';
        boolean eof = false;

        try {
            in =
                new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream(_file), _encoding));
            while (!eof) {
                line = in.readLine();
                if (line == null) {
                    // եκǸ
                    int[] pos = {start, counter};
                    tmpIndex.put(new Character(index), pos);
                    eof = true;
                    continue;
                } else if (line.startsWith(";;") || line.length() == 0) {
                    // ȡԤ̵
                    if (line.equals(OKURI_NASI)) { // 
                        int[] pos = {start, counter};
                        tmpIndex.put(new Character(index), pos);
                        tmpIndex = _nasiIndex;
                        tmpDic = _nasiDic;
                        index = ';';
                        start = -1;
                        counter = 0;
                    }
                    continue;
                } else if (line.charAt(0) != index) {
                    // ƬʸѲС
                    // ޤǤͤ򥤥ǥåȤϿ
                    if (start != -1) {
                        int[] pos = {start, counter};
                        tmpIndex.put(new Character(index), pos);
                    }
                    index = line.charAt(0);
                    start = counter;
                }
                tmpDic.add(line);
                counter++;
            }
            _load = true;
        } catch (IOException e) {
            System.err.println(e.getMessage());
            _ariDic.clear();
            _nasiDic.clear();
            _ariIndex.clear();
            _nasiIndex.clear();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }

        if (_ariDic.isEmpty() && _nasiDic.isEmpty()) {
            _exist = false;
        }
    }

    /**
     * Ĥƥ꥽ޤ
     *
     */
    public void close() {
        if (_ariDic != null) {
            _ariDic.clear();
            _ariDic = null;
        }
        if (_nasiDic != null) {
            _nasiDic.clear();
            _nasiDic = null;
        }
        if (_ariIndex != null) {
            _ariIndex.clear();
            _ariIndex = null;
        }
        if (_nasiIndex != null) {
            _nasiIndex.clear();
            _nasiIndex = null;
        }
        _load = false;
        _exist = false;
    }

    /**
     * Ǽ򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return η (ʤnull)
     */
    public String search(String key) {
        if (!_load) {
            _open();
        }

        if (!_exist) {
            return null;
        }

        List dic = _nasiDic;
        int[] pos = null;
        boolean reverse = false;
        if (DicUtil.isOkuriAri(key)) {
            dic = _ariDic;
            pos = (int[])_ariIndex.get(new Character(key.charAt(0)));
            reverse = true;
        } else {
            pos = (int[])_nasiIndex.get(new Character(key.charAt(0)));
        }
        if (dic.isEmpty()) {
            return null;
        }

        if (pos == null) {
            return null;
        }

        int i = pos[0];
        int j = pos[1];

        while (i < j) {
            int x = (i + j) / 2;
            String entry = (String)dic.get(x);

            int sep = entry.indexOf(' ');
            String yomi;
            if (sep != -1) {
                yomi = entry.substring(0, sep+1);
            } else {
                yomi = entry;
            }

            int comp = yomi.compareTo(key);
            if (comp == 0) {
                if (sep == -1) {
                    return null;
                }
                return entry.substring(sep+1);
            }

            if (reverse) {
                comp = -comp;
            }
            if (comp < 0) {
                i = x + 1;
            } else {
                j = x;
            }
        }
        return null;
    }
}

// end of LocalDic.java
