package fuku.skk4j.dic;

import java.io.*;
import java.util.*;

/**
 * SKK桼񥯥饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class UserDic implements SKKDic {

    /** ꤢ꼭 */
    private List _ariDic = null;
    /** ʤ */
    private List _nasiDic = null;

    /** ե */
    private File _file = null;
    /** ư¸ޤǤι */
    private int _maxCount = -1;
    /**  */
    private int _count = -1;

    /** ɤ߹Ǥ뤫ɤ */
    private boolean _load = false;


    /**
     * 󥹥ȥ饯
     *
     * @param fname ե̾
     * @param maxCount ư¸ޤǤι
     */
    public UserDic(String fname, int maxCount) {
        super();
        if (fname != null && fname.length() != 0) {
            _file = new File(fname);
        }
        _maxCount = maxCount;
    }


    /**
     * Ƥɤ߹ߤޤ
     *
     */
    private synchronized void _open() {
        _load = true;
        if (_ariDic == null) {
            _ariDic = Collections.synchronizedList(new ArrayList());
        }
        if (_nasiDic == null) {
            _nasiDic = Collections.synchronizedList(new ArrayList());
        }

        if (_file == null) {
            return;
        }

        boolean flag;
        try {
            flag = _file.canRead();
        } catch (SecurityException e) {
            System.err.println(e.getMessage());
            flag = false;
        }

        if (!flag) {
            return;
        }

        _ariDic.clear();
        _nasiDic.clear();

        List dic = _ariDic;
        BufferedReader in = null;
        String line = null;
        try {
            in =
                new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream(_file), "EUC_JP"));
            while ((line=in.readLine()) != null) {
                // ȡԤ̵
                if (line.startsWith(";;") || line.length() == 0) {
                    if (line.startsWith(OKURI_NASI)) {
                        dic = _nasiDic;
                    }
                    continue;
                }
                dic.add(line);
            }
        } catch (IOException e) {
            System.err.println(e.getMessage());
            _ariDic.clear();
            _nasiDic.clear();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }

    /**
     * Ƥ񤭽Фޤ
     *
     */
    private synchronized void _store() {
        if (_file == null) {
            return;
        }

        if (_ariDic == null || _nasiDic == null) {
            return;
        }

        if (_ariDic.isEmpty() && _nasiDic.isEmpty()) {
            return;
        }

        boolean okuriAri = true;
        BufferedWriter out = null;
        File tmp = null;
        try {
            try {
                tmp = File.createTempFile("skk-jisyo", null);
            } catch (SecurityException e) {
                System.err.println(e.getMessage());
                return;
            }
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmp),"EUC_JP"));
            out.write(OKURI_ARI+"\n");
            int size = _ariDic.size();
            for (int i=0; i<size; i++) {
                out.write((String)_ariDic.get(i)+"\n");
            }
            out.write(OKURI_NASI+"\n");
            size = _nasiDic.size();
            for (int i=0; i<size; i++) {
                out.write((String)_nasiDic.get(i)+"\n");
            }
        } catch (IOException e) {
            System.err.println(e.getMessage());
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        _file.delete();
        tmp.renameTo(_file);
        tmp.delete();
    }

    /**
     * Ĥƥ꥽ޤ
     *
     */
    public void close() {
        _store();
        if (_ariDic != null) {
            _ariDic.clear();
            _ariDic = null;
        }
        if (_nasiDic != null) {
            _nasiDic.clear();
            _nasiDic = null;
        }
        _load = false;
    }

    /**
     * Ǽ򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return η (ʤnull)
     */
    public synchronized String search(String key) {
        if (!_load) {
            _open();
        }

        List dic = _nasiDic;
        if (DicUtil.isOkuriAri(key)) {
            if (_ariDic.isEmpty()) {
                return null;
            }
            dic = _ariDic;
        } else {
            if (_nasiDic.isEmpty()) {
                return null;
            }
        }

        // ٽˤʤäƤΤǥ˥Ǹ
        String entry;
        String yomi;
        int sep;
        int size = dic.size();
        for (int i=0; i<size; i++) {
            entry = (String)dic.get(i);
            if ((sep=entry.indexOf(' ')) != -1) {
                yomi = entry.substring(0, sep+1);
                if (yomi.compareTo(key) == 0) {
                    return entry.substring(sep+1);
                }
            }
        }
        return null;
    }

    /**
     * 񤫤keyФ䴰򸡺ޤ<BR>
     * keynullʸξ硢٤Ƥθ䤬֤ޤ
     *
     * @param key 
     * @return η (ʤnull)
     */
    public synchronized List complement(String key) {
        if (!_load) {
            _open();
        }

        if (_nasiDic.isEmpty()) {
            return null;
        }

        List list = new ArrayList();

        if (key == null || key.length() == 0) {
            Iterator it = _nasiDic.iterator();
            while (it.hasNext()) {
                list.add((String)it.next());
            }
            return list;
        }

        // ٽˤʤäƤΤǥ˥Ǹ
        String entry, yomi;
        int sep;
        int size = _nasiDic.size();
        for (int i=0; i<size; i++) {
            entry = (String)_nasiDic.get(i);
            if ((sep=entry.indexOf(' ')) != -1) {
                yomi = entry.substring(0, sep);
                if (yomi.startsWith(key) && yomi.length() > key.length()) {
                    list.add(entry);
                }
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    /**
     * ñϿޤ(겾̾ʤ) <BR>
     * <BR>
     * ȥ:  ////
     *
     * @param key Ф + " " ()
     * @param word Ͽ
     */
    public synchronized void regist(String key, String word) {
        String registStr = DicUtil.replaceEscChar(word);
        StringBuffer buf = new StringBuffer(key + "/" + registStr + "/");
        int index = _searchIndex(key, false);
        if (index != -1) { // ˥ȥ꤬¸ߤ
            String entry = (String)_nasiDic.get(index);
            entry = entry.substring(entry.indexOf(' ')+1); // ڤФ
            StringTokenizer st = new StringTokenizer(entry, "/");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str.compareTo(registStr) != 0) {
                    buf.append(str).append('/');
                }
            }
            _nasiDic.remove(index);
        }
        _nasiDic.add(0, buf.toString());

        _count++;
        if (_maxCount > 0 && _count >= _maxCount) {
            _store();
        }
    }

    /**
     * ñϿޤ(겾̾) <BR>
     * <BR>
     * ȥ: k //¿/[/¿/]/[//]/
     *
     * @param key Ф + " " ()
     * @param word Ͽ
     * @param okurigana ꤷ겾̾
     */
    public synchronized void regist(String key, String word, String okurigana) {
        String registStr = DicUtil.replaceEscChar(word);
        String okuriStr = DicUtil.replaceEscChar(okurigana);
        StringBuffer buf = new StringBuffer(key + "/" + registStr + "/");
        int index = _searchIndex(key, true);
        if (index != -1) { // ˥ȥ꤬¸ߤ
            String entry = (String)_ariDic.get(index);
            int i = entry.indexOf(' ');
            int j = entry.indexOf("/[");
            String okuri = "";
            if (j != -1) {
                okuri = entry.substring(j); // /[/¿/]/[//]/
            } else {
                j = entry.length() - 1;
            }
            entry = entry.substring(i+1, j+1); // //¿/
            StringTokenizer st = new StringTokenizer(entry, "/");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (str.compareTo(registStr) != 0) {
                    buf.append(str).append('/');
                }
            }
            buf.append('[').append(okuriStr).append('/');
            buf.append(registStr).append('/'); // 겾̾ɲ
            i = okuri.indexOf("/[" + okuriStr + "/");
            if (i != -1) { // 겾̾䤬¸ߤ
                j = okuri.indexOf("/]/", i);
                entry = okuri.substring(i+2+okuriStr.length(), j+1); // /¿/
                st = new StringTokenizer(entry, "/");
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (str.compareTo(registStr) != 0) {
                        buf.append(str).append('/');
                    }
                }
                buf.append("]/");
                buf.append(okuri.substring(1, i+1)); // Ĥɲ
                buf.append(okuri.substring(j+3));
            } else {
                buf.append(']').append(okuri);
            }
            _ariDic.remove(index);
        } else { // 겾̾ɲ
            buf.append('[').append(okuriStr).append('/');
            buf.append(registStr).append("/]/");
        }
        _ariDic.add(0, buf.toString());

        _count++;
        if (_maxCount > 0 && _count >= _maxCount) {
            _store();
        }
    }

    /**
     * 񤫤ñޤ(겾̾ʤ) <BR>
     * <BR>
     * ȥ:  ////
     *
     * @param key Ф + " " ()
     * @param word 
     */
    public synchronized void delete(String key, String word) {
        int index = _searchIndex(key, false);
        if (index == -1) {
            // ȥ꤬¸ߤʤ
            return;
        }

        StringBuffer buf = new StringBuffer(key + "/");
        String entry = (String)_nasiDic.get(index);
        entry = entry.substring(entry.indexOf(' ')+1); // ڤФ
        int i = entry.indexOf("/" + word + "/");
        if (i != -1) { // κ
            buf.append(entry.substring(1, i+1));
            buf.append(entry.substring(i+2+word.length()));
        } else { // ʤˤ⤷ʤ
            buf.append(entry.substring(1));
        }
        _nasiDic.remove(index);
        // 䤬ΤΤߤξϺϿʤ
        if (buf.toString().compareTo(key+"/") != 0) {
            _nasiDic.add(0, buf.toString());
        }

        _count++;
        if (_maxCount > 0 && _count >= _maxCount) {
            _store();
        }
    }

    /**
     * 񤫤ñޤ(겾̾) <BR>
     * <BR>
     * ȥ: k //¿/[/¿/]/[//]/
     *
     * @param key Ф + " " ()
     * @param word 
     * @param okurigana ꤷ겾̾
     */
    public synchronized void delete(String key, String word, String okurigana) {
        int index = _searchIndex(key, true);
        if (index == -1) {
            // ȥ꤬¸ߤʤ
            return;
        }

        StringBuffer buf = new StringBuffer(key + "/");
        String entry = (String)_ariDic.get(index);
        int i = entry.indexOf(' ');
        int j = entry.indexOf("/[");
        String okuri = entry.substring(j); // /[/¿/]/[//]/
        entry = entry.substring(i+1, j+1); // //¿/

        // κ
        i = entry.indexOf("/" + word + "/");
        if (i != -1) { // κ
            buf.append(entry.substring(1, i+1));
            buf.append(entry.substring(i+2+word.length()));
        } else { // ʤˤ⤷ʤ
            buf.append(entry.substring(1));
        }
        // ʳθ䤬¸ߤʤнλ
        if (buf.toString().compareTo(key+"/") == 0) {
            _ariDic.remove(index);
            return;
        }

        // 겾̾κ
        i = okuri.indexOf("/[", 1);
        entry = okuri.substring(1, i+1); // [/¿/]/
        StringBuffer buf2 = new StringBuffer();
        while (entry != null) {
            i = entry.indexOf('/');
            String kana = entry.substring(0, i); // [
            String kanji = entry.substring(i); // /¿/]/
            buf2.delete(0, buf2.length());
            buf2.append('/');
            i = kanji.indexOf("/" + word + "/");
            if (i != -1) { // κ
                buf2.append(kanji.substring(1, i+1));
                buf2.append(kanji.substring(i+2+word.length()));
            } else {
                buf2.append(kanji.substring(1));
            }
            // ʳθ䤬¸ߤɲ
            if (buf2.toString().compareTo("/]/") != 0) {
                buf.append(kana + buf2.toString());
            }
            i = okuri.indexOf(entry) + entry.length();
            if (i < okuri.length()) {
                j = okuri.indexOf("/[", i);
                if (j != -1) {
                    entry = okuri.substring(i, j+1);
                } else {
                    entry = okuri.substring(i);
                }
            } else {
                entry = null;
            }
        }
        _ariDic.remove(index);
        _ariDic.add(0, buf.toString());

        _count++;
        if (_maxCount > 0 && _count >= _maxCount) {
            _store();
        }
    }

    /**
     * μǤΥǥå֤ޤ
     *
     * @param key  (Ф+" ")
     * @param okuri 뼭 (true:ꤢ/false:ʤ)
     * @return ǤΥǥåʤ-1
     */
    private int _searchIndex(String key, boolean okuri) {
        List dic = _nasiDic;
        if (okuri) {
            if (_ariDic.isEmpty()) {
                return -1;
            }
            dic = _ariDic;
        } else {
            if (_nasiDic.isEmpty()) {
                return -1;
            }
        }

        String entry, yomi;
        int sep;
        int size = dic.size();
        for (int i=0; i<size; i++) {
            entry = (String)dic.get(i);
            if ((sep=entry.indexOf(' ')) != -1) {
                yomi = entry.substring(0, sep+1);
            } else {
                yomi = entry;
            }

            if (yomi.compareTo(key) == 0) {
                return i;
            }
        }
        return -1;
    }
}

// end of UserDic.java
