package fuku.skk4j.im;

import java.io.*;
import java.text.*;
import java.util.*;

/**
 * emacs-lispؿޤȤ᤿饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
class LispEmu {

    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private LispEmu() {
        super();
    }


    /**
     * ɾޤ
     *
     * @param exp ɾ뼰
     * @return ɾη
     */
    static String analyze(String exp) {
        String str = exp;
        if (exp.equals("(skk-version)")) {
            str = "SKK for Java version 0.1";
        } else if (exp.equals("(skk-times)")) {
        } else if (exp.equals("(current-time-string)")) {
            Calendar cal = Calendar.getInstance();
            DateFormat formater =
                DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG);
            str =  formater.format(cal.getTime());
        } else if (exp.equals("(pwd)")) {
            File file = new File(".");
            String path = file.getAbsolutePath();
            str = "Directory " + path.substring(0, path.length()-1);
        } else if (exp.startsWith("(concat ")) {
            List list = new ArrayList();
            int idx1 = exp.indexOf('"');
            int idx2;
            while (idx1 != -1) {
                idx2 = exp.indexOf('"', idx1+1);
                if (idx2 == -1) {
                    break;
                }
                list.add(exp.substring(idx1+1, idx2));
                idx1 = exp.indexOf('"', idx2+1);
            }
            str = _concat(list);
        } else if (exp.startsWith("(make-string ")) {
        }
        return str;
    }

    /**
     * ɾޤ
     *
     * @param exp ɾ뼰
     * @param args 
     * @return ɾη
     */
    static String analyze(String exp, List args) {
        String str = exp;
        if (exp.equals("(skk-times)")) {
            if (args.size() == 2) {
                int i, j;
                try {
                    i = Integer.parseInt((String)args.get(0));
                    j = Integer.parseInt((String)args.get(1));
                } catch (NumberFormatException e) {
                    i = 0;
                    j = 0;
                }
                str = String.valueOf(i*j);
            }
        } else {
            str = analyze(exp);
        }
        return str;
    }


    /**
     * ʸִޤ
     *
     * @param str ִʸ
     * @return ִʸ
     */
    private static String _replaceEscChar(String str) {
        StringBuffer buf = new StringBuffer(str);
        int idx = str.indexOf('\\');
        while (idx != -1) {
            int code = -1;
            int i = 0;
            if (buf.charAt(idx+1) == 'n') { // '\n'
                code = -1;
//                  code = '\n';
//                  i = 2;
            } else { // '\'ʹߤ3ʸͤʤʸ(8ʿ)ȹͤ
                for (i=4; i>1; i--) {
                    // \xxx -> \x ޤǤ8ʿȽǤǤȤޤǽ
                    if (buf.length() >= idx+i) {
                        try {
                            code = Integer.parseInt(buf.substring(idx+1, idx+i), 8);
                            break;
                        } catch (NumberFormatException e) {
                            code = -1;
                        }
                    }
                }
            }
            if (code != -1) { // ʸʬ("\nnn")ִ
                buf.replace(idx, idx+i, String.valueOf((char)code));
            }
            idx = buf.toString().indexOf('\\', idx+1);
        }
        return buf.toString();
    }

    /**
     * ʸϢ뤷ޤ<BR>
     * (concat "str1" "str2" ... "strN")
     *
     * @param list Ϣ뤹ʸΥꥹ
     * @return Ϣ뤷ʸ
     */
    private static String _concat(List list) {
        StringBuffer buf = new StringBuffer();
        int size = list.size();
        for (int i=0; i<size; i++) {
            String str = (String)list.get(i);
            str = _replaceEscChar(str);
            buf.append(str);
        }
        return buf.toString();
    }
}

// end of ListEmu.java
