package fuku.skk4j.dic;

import java.io.*;
import java.util.*;

/**
 * SKK񥯥饹Ǥ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class InnerDic implements SKKDic {

    /** ե̾ */
    private String _JISYO = "InnerDic.ser";
    /** ꤢ꼭 */
    private List _ariDic = null;
    /** ʤ */
    private List _nasiDic = null;

    /** ɤ߹Ǥ뤫ɤ */
    private boolean _load = false;


    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    public InnerDic() {
        super();
    }


    /**
     * Ƥɤ߹ߤޤ
     *
     */
    private void _open() {
        if (_ariDic != null && _nasiDic != null) {
            return;
        }

        boolean success = true;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(getClass().getResourceAsStream(_JISYO));
            _ariDic = (List)ois.readObject();
            _nasiDic = (List)ois.readObject();
            _load = true;
        } catch (OptionalDataException e) {
            System.err.println(e.getMessage());
            success = false;
        } catch (ClassNotFoundException e) {
            System.err.println(e.getMessage());
            success = false;
        } catch (IOException e) {
            System.err.println(e.getMessage());
            success = false;
        } finally {
            if (ois != null) {
                try {
                    ois.close();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        }

        if (!success) {
            _load = false;
            _ariDic = new ArrayList();
            _nasiDic = new ArrayList();
        }
    }

    /**
     * Ĥƥ꥽ޤ
     *
     */
    public void close() {
        if (_ariDic != null) {
            _ariDic.clear();
            _ariDic = null;
        }
        if (_nasiDic != null) {
            _nasiDic.clear();
            _nasiDic = null;
        }
        _load = false;
    }

    /**
     * Ǽ򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return η (ʤnull)
     */
    public String search(String key) {
        if (!_load) {
            _open();
        }

        List dic = _nasiDic;
        if (DicUtil.isOkuriAri(key)) {
            dic = _ariDic;
        }
        if (dic.isEmpty()) {
            return null;
        }

        int i = 0;
        int j = dic.size();

        while (i < j) {
            int x = (i + j) / 2;
            String entry = (String)dic.get(x);

            int sep = entry.indexOf(' ');
            String yomi;
            if (sep != -1) {
                yomi = entry.substring(0, sep+1);
            } else {
                yomi = entry;
            }

            int comp = yomi.compareTo(key);
            if (comp == 0) {
                if (sep == -1) {
                    return null;
                }
                return entry.substring(sep+1);
            }

            if (comp < 0) {
                i = x + 1;
            } else {
                j = x;
            }
        }
        return null;
    }

    /**
     * 񤫤keyФ䴰򸡺ޤ<BR>
     * keynullʸξ硢٤Ƥθ䤬֤ޤ
     *
     * @param key  (Ф)
     * @return η (ʤnull)
     */
    public List complement(String key) {
        if (!_load) {
            _open();
        }

        if (_nasiDic.isEmpty()) {
            return null;
        }

        if (key == null || key.length() == 0) {
            Iterator it = _nasiDic.iterator();
            List list = new ArrayList();
            while (it.hasNext()) {
                list.add((String)it.next());
            }
            return list;
        }

        int i = 0;
        int j = _nasiDic.size();

        // Хʥꥵ
        while (i < j) {
            int x = (i + j) / 2;
            String entry = (String)_nasiDic.get(x);

            int sep = entry.indexOf(' ');
            String yomi;
            if (sep != -1) {
                yomi = entry.substring(0, sep);
            } else {
                yomi = entry;
            }

            // ʸ󤬰פаʹߤ䴰оݤˤʤ
            int comp = yomi.compareTo(key);
            if (comp == 0) {
                return _getComplement(key, x+1);
            }

            // θ䤬keyϤޤʤаʹߤ䴰оݤˤʤ
            if (yomi.startsWith(key)) {
                if (x > 0) {
                    entry = (String)_nasiDic.get(x-1);
                    sep = entry.indexOf(' ');
                    if (sep != -1) {
                        yomi = entry.substring(0, sep);
                    } else {
                        yomi = entry;
                    }
                    if (!yomi.startsWith(key)) {
                        return _getComplement(key, x);
                    }
                }
            }

            if (comp < 0) {
                i = x + 1;
            } else {
                j = x;
            }
        }
        return null;
    }

    /**
     * 񤫤keyФ䴰ޤ
     *
     * @param key  (Ф)
     * @param i μϥǥå
     * @return Υꥹ
     */
    private List _getComplement(String key, int i) {
        List list = new ArrayList();
        int max = _nasiDic.size();
        while (i < max) {
            String entry = (String)_nasiDic.get(i);
            int sep = entry.indexOf(' ');
            String yomi;
            if (sep != -1) {
                yomi = entry.substring(0, sep);
            } else {
                yomi = entry;
            }
            if (yomi.startsWith(key)) {
                list.add(entry);
            } else {
                break;
            }
            i++;
        }
        return list;
    }
}

// end of InnerDic.java
