/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef charset_h
#define charset_h

/*========================================================================*
 *	
 *========================================================================*/

/*
 *	ʸ硣
 */
enum {
	KCHARSET_NOTHING = -1,

	KCHARSET_ASCII	 = 0,	KCHARSET_7BIT_CHARACTER		= KCHARSET_ASCII,
	KCHARSET_ISO8859_1,		KCHARSET_1BYTE_CHARACTER	= KCHARSET_ISO8859_1,
	KCHARSET_ISO8859_2,
	KCHARSET_ISO8859_3,
	KCHARSET_ISO8859_4,
	KCHARSET_ISO8859_5,
	KCHARSET_ISO8859_6,
	KCHARSET_ISO8859_7,
	KCHARSET_ISO8859_8,
	KCHARSET_ISO8859_9,
	KCHARSET_ISO8859_14,
	KCHARSET_ISO8859_15,
	KCHARSET_JISX0201_1976,
	
	/*
	 *	ܸ(2Хʸ)
	 */
	KCHARSET_JISX0208_1978,	KCHARSET_2BYTES_CHARACTER	= KCHARSET_JISX0208_1978,
	KCHARSET_JISX0208_1983,
	KCHARSET_JISX0212_1990,

	/*
	 *	(2Хʸ)
	 */
	KCHARSET_GB2312_1980,
	KCHARSET_GB12345_90,
	/*
	 *	(2Хʸ)ʸ(supplementary character sets)
	 */
	KCHARSET_GB7589_87,
	KCHARSET_GB7590_87,
	KCHARSET_GB13131_91,
	KCHARSET_GB13132_91,

	/*
	 * 	ڹ(2Хʸ)
	 */
	KCHARSET_KSC5601_1987,
	KCHARSET_KSC5601_1992,

	MAX_CHARSET,
} ;

/*
 *	üʸ硣Window Event 롣
 */
#define	KCHARSET_EVENT	(MAX_CHARSET + 1)

#endif

