/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (local_h)
#define	local_h

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

typedef struct tagTSize {
	int			cx, cy ;
}	TSize ;

#define	TSUCCEEDED(ex)		((ex) == True)
#define	TFAILED(ex)			((ex) != True)
#define	NELEMENTS(array)	(sizeof (array) / sizeof (array [0]))

#if defined (DEBUG_MEMORY)
extern void*	debug_malloc (size_t, const char*, int) ;
extern void		debug_free   (void*,  const char*, int) ;
#define	MALLOC(x)			debug_malloc((x),__FILE__,__LINE__)
#define	FREE(x)				debug_free((x),__FILE__,__LINE__)
#else
#define	MALLOC(x)			malloc((x))
#define	FREE(x)				free((x))
#endif
#define	UNREFERENCED_PARAMETER(x)	/*(x)*/

typedef int					SOCKET ;
typedef char				TCHAR ;
#define	INVALID_SOCKET		(-1)

#endif

