/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(skkjisho_h)
#define	skkjisho_h

#include "Char.h"
#include "varbuffer.h"

/*	Structures */
typedef struct tagSKKSERVERJISYO*	PSKKSERVERJISYO ;
typedef struct _tagSKKSORTEDJISYO	*PSKKSORTEDJISYO ;
typedef struct _tagSKKJISYO			*PSKKJISYO ;

/*	Prototypes */
PSKKSERVERJISYO	SkkServerJisyo_Find     (const Char*, int) ;
PSKKSERVERJISYO	SkkServerJisyo_Register (const Char*, int, int) ;
Boolean			SkkServerJisyo_Search   (PSKKSERVERJISYO, const Char*, int, TVarbuffer*) ;

PSKKJISYO		SkkJisyo_Find       (const Char*, int) ;
PSKKJISYO		SkkJisyo_Register   (const Char*, int, int) ;
Boolean			SkkJisyo_Unregister (const Char*, int) ;
Boolean			SkkJisyo_Search     (PSKKJISYO, const Char*, int, Boolean, TVarbuffer*) ;
Boolean			SkkJisyo_OkuriSearch(PSKKJISYO, const Char*, int, TVarbuffer*) ;

PSKKSORTEDJISYO	SkkSortedJisyo_Register   (const Char*, int, int) ;
PSKKSORTEDJISYO	SkkSortedJisyo_Find       (const Char*, int) ;
Boolean			SkkSortedJisyo_Unregister (const Char*, int) ;
Boolean			SkkSortedJisyo_Search     (PSKKSORTEDJISYO, const Char*, int, Boolean, TVarbuffer*) ;

#endif

