/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (lispmgr_inl_h)
#define	lispmgr_inl_h

extern inline	Boolean
lispMgr_GetLocalSymbols (
	register TLispManager*		pLispMgr,
	register TLispEntity***		pppEntSymbol,
	register int*				pnEntSymbol)
{
	assert (pLispMgr     != NULL) ;
	assert (pppEntSymbol != NULL) ;
	assert (pnEntSymbol  != NULL) ;
	*pppEntSymbol	= TVarbuffer_GetBuffer (&pLispMgr->m_vbufLocalSymbol) ;
	*pnEntSymbol	= TVarbuffer_GetUsage  (&pLispMgr->m_vbufLocalSymbol) ;
	return	True ;
}

extern inline	Boolean
lispMgr_AddSymbolToLocalSymbols (
	register TLispManager*	pLispMgr,
	TLispEntity*			pEntSymbol)
{
	assert (pLispMgr   != NULL) ;
	assert (pEntSymbol != NULL) ;
	if (TFAILED (lispEntity_Symbolp (pLispMgr, pEntSymbol)))
		return	False ;
	if (TFAILED (TVarbuffer_Add (&pLispMgr->m_vbufLocalSymbol, &pEntSymbol, 1)))
		return	False ;
	lispEntity_AddRef (pLispMgr, pEntSymbol) ;
	return	True ;
}

extern inline void
lispMgr_DestroyEntity (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	static void		(*srpDestroyFunc [])(TLispManager*, TLispEntity*)	= {
		NULL,						/* LISPENTITY_VECTOR */
		NULL,						/* LISPENTITY_STRING */
		NULL,						/* LISPENTITY_SYMBOL */
		lispMgr_DestroyMarker,		/* LISPENTITY_MARKER */
		lispMgr_DestroyBuffer,		/* LISPENTITY_BUFFER */
		lispMgr_DestroyWindow,		/* LISPENTITY_WINDOW */
		lispMgr_DestroyFrame,		/* LISPENTITY_FRAME */
		NULL,						/* LISPENTITY_SUBR */
		NULL,						/* LISPENTITY_IMCLIENT */
		NULL,						/* LISPENTITY_MUTEX */
		lispMgr_DestroyXEvent,		/* LISPENTITY_XEVENT */
	} ;
	register int	nFunc ;

	assert (pLispMgr != NULL) ;
	assert (pEntity  != NULL) ;

	nFunc	= pEntity->m_iType - LISPENTITY_VECTOR ;
	if ((0 <= nFunc && nFunc < sizeof (srpDestroyFunc)) &&
		srpDestroyFunc [nFunc] != NULL)
		(srpDestroyFunc [nFunc])(pLispMgr, pEntity) ;
	FREE (pEntity) ;
	return ;
}

/*	Ʊ̾/ƱǤäƤ eq Ƚ nil ֤ entity Ĥʤ*/
extern inline	Boolean
lispMgr_RegisterMisc (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntity)
{
	assert (pLispMgr != NULL) ;
	assert (pEntity  != NULL) ;

	pEntity->m_pRight			= pLispMgr->m_pEntMiscListTop ;
	pEntity->m_pLeft			= NULL ;
	if (pLispMgr->m_pEntMiscListTop != NULL)
		pLispMgr->m_pEntMiscListTop->m_pLeft	= pEntity ;
	pLispMgr->m_pEntMiscListTop	= pEntity ;
	return	True ;
}

extern inline	Boolean
lispMgr_Allocate (
	register TLispManager*			pLispMgr,
	register size_t					nSize,
	register void*					pRetval)
{
	void*	pvMemory ;

	pvMemory	= MALLOC (nSize) ;
	if (pvMemory == NULL) {
#if defined (DEBUG)
		fprintf (stderr, "Garbage collecting ...") ;
		fflush (stderr) ;
#endif
		lispMgr_CollectGarbage (pLispMgr) ;
#if defined (DEBUG)
		fprintf (stderr, "done.\n") ;
#endif
		pvMemory	= MALLOC (nSize) ;
		if (pvMemory == NULL) 
			return	False ;
	}
	*((void **)pRetval)	= pvMemory ;
	return	True ;
}

extern inline	void
lispMgr_Deallocate (
	register TLispManager*			pLispMgr,
	register void*					pvMemory)
{
	FREE (pvMemory) ;
	return ;
}

extern inline	Boolean
lispMgr_AllocateEntity (
	register TLispManager*			pLispMgr,
	register size_t					nSize,
	register TLispEntity** const	ppReturn)
{
	TLispEntity*	pEntity ;

	if (TFAILED (lispMgr_Allocate (pLispMgr, sizeof (TLispEntity) + nSize, &pEntity)))
		return	False ;

	pEntity->m_iType		= LISPENTITY_BAD ;
	pEntity->m_lReferCount	= 0 ;	/* ľϻȥ󥿤 0*/
	pEntity->m_iMarker		= pLispMgr->m_iMarker - 1 ;
	pEntity->m_pLeft		= NULL ;
	pEntity->m_pRight		= NULL ;

	*ppReturn	= pEntity ;
	return	True ;
}

#endif

