/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "local.h"
#include <stdio.h>
#include <assert.h>
#include "lmachinep.h"

extern	Boolean	lispMachine_GetSubr      (struct tagLMCMDINFO const*, TLispEntity**) ;
extern	Boolean	lispMachine_RegisterSubr (struct tagLMCMDINFO const*, TLispEntity*) ;

#define	lispEntity_GetSubrPtr(ptr)	((struct tagLMCMDINFO const **)((TLispEntity *)(ptr) + 1))

Boolean
lispMgr_CreateSubr (
	register TLispManager*				pLispMgr,
	register struct tagLMCMDINFO const*	pCmdInfo,
	register TLispEntity** const		ppEntReturn)
{
	TLispEntity*							pEntity ;
	register struct tagLMCMDINFO const**	ppSubr ;

	assert (pLispMgr    != NULL) ;
	assert (pCmdInfo    != NULL) ;
	assert (ppEntReturn != NULL) ;

	if (TSUCCEEDED (lispMachine_GetSubr (pCmdInfo, &pEntity)) &&
		pEntity != NULL) {
		*ppEntReturn	= pEntity ;
		return	True ;
	}

	if (TFAILED (lispMgr_AllocateEntity (pLispMgr, sizeof (struct tagLMCMDINFO*), &pEntity)))
		return	False ;
	
	pEntity->m_iType		= LISPENTITY_SUBR ;
	/*	subroutine οϤΤƤΤǡGC оݤˤʤʤ
	 *	˻ȥ󥿤 1 Ϥ롣*/
	pEntity->m_lReferCount	= 1 ;
	ppSubr					= lispEntity_GetSubrPtr (pEntity) ;
	*ppSubr					= pCmdInfo ;
	lispMachine_RegisterSubr (pCmdInfo, pEntity) ;
	*ppEntReturn			= pEntity ;
	return	True ;
}

Boolean
lispSubr_GetName (
	register TLispManager*	pLispMgr,
	register TLispEntity*	pEntSubr,
	register const Char**	ppStrReturn)
{
	register struct tagLMCMDINFO const**	ppSubr ;
	register struct tagLMCMDINFO const*		pCmdInfo ;

	assert (pLispMgr    != NULL) ;
	assert (pEntSubr    != NULL) ;
	assert (ppStrReturn != NULL) ;
	
	if (pEntSubr->m_iType != LISPENTITY_SUBR)
		return	False ;
	ppSubr		= lispEntity_GetSubrPtr (pEntSubr) ;
	pCmdInfo	= *ppSubr ;
	*ppStrReturn	= pCmdInfo->m_pName ;
	return	True ;
}

