/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef Char_h
#define Char_h

#include "charset.h"

/*========================================================================*
 *	ޥ
 *========================================================================*/

/*========================================================================*
 *	
 *========================================================================*/
/*
 *	ʸӥåȤλѾ֤ϼ̤ꡣ
 *		
 *		3130 .. 2423 .. 1615 ... 0
 *		
 *		ʸ          ʸ    
 *		    稭        ɨ
 *		
 */
typedef unsigned long	Char ;

/*========================================================================*
 *	inline ؿ
 *========================================================================*/
extern inline	int
Char_Charset (register Char cc)
{
	return	((cc) >> 24) & 0x7F ;
}

extern inline	unsigned int
Char_Code (register Char cc)
{
	return	(cc) & 0xFFFF ;
}

extern inline	int
Char_ToAscii (register Char cc)
{
	return	(KCHARSET_ASCII << 24) | Char_Code ((Char)(cc)) ;
}

extern inline	int
Char_IsAscii (register Char cc)
{
	return	(KCHARSET_ASCII <= Char_Charset (cc) &&
			 Char_Charset (cc) < KCHARSET_2BYTES_CHARACTER &&
			 Char_Code (cc) < 0x80) ;
}

extern inline int
Char_Difference (register Char chLeft, register Char chRight)
{
	if (Char_IsAscii (chLeft))
		chLeft	= Char_ToAscii (chLeft) ;

	if (Char_IsAscii (chRight))
		chRight	= Char_ToAscii (chRight) ;

	return	(chLeft - chRight) ;
}

extern inline Char
Char_Make (register int nSet, register unsigned int uCode)
{
	return	((nSet & 0x7F) << 24) | uCode ;
}

extern inline Char
Char_MakeAscii (register int ch)
{
	return	Char_Make (KCHARSET_ASCII, ch & 0x7F) ;
}

extern inline int
Char_DifferenceAscii (register Char cc, register int ch)
{
	return	Char_Difference (cc, Char_MakeAscii (ch)) ;
}

extern inline	int
Char_IsEqual (register Char chl, register Char chr)
{
	return	!Char_Difference (chl, chr) ;
}

extern inline	int
Char_IsEqualAscii (register Char chl, register Char chr)
{
	return	!Char_DifferenceAscii (chl, chr) ;
}

extern inline int
Char_IsNul (register Char cc)
{
	return	(Char_Code (cc) == '\0' && Char_IsAscii (cc)) ;
}

extern inline int
Char_IsAlpha (register Char cc)
{
	return	(Char_IsAscii (cc) && (('a' <= cc && cc <= 'z') || ('A' <= cc && cc <= 'Z'))) ;
}

extern inline int
Char_IsDigitNum (register Char cc)
{
	return	(Char_IsAscii (cc) && (('0' <= cc && cc <= '9') || cc == '-' || cc == '+')) ;
}

extern inline int
Char_IsAlphaNum (register Char cc)
{
	return	Char_IsAlpha (cc) || Char_IsDigitNum (cc) ;
}

extern inline int
Char_IsSpace (register Char cc)
{
	return	Char_IsAscii (cc) && (cc == ' ' || cc == '\t') ;
}

extern inline int
Char_Is2ByteChara (register Char cc)
{
	register int		nSet ;
	nSet	= Char_Charset (cc) ;
	return	(KCHARSET_2BYTES_CHARACTER <= nSet && nSet < MAX_CHARSET) ;
}

extern inline Char
Char_ToLower (register Char cc)
{
	if (Char_IsAscii (cc) && ('A' <= Char_Code (cc) && Char_Code (cc) <= 'Z'))
		return	Char_MakeAscii ((char)(Char_Code (cc) + 'a' - 'A')) ;
	return	cc ;
}

extern inline Char
Char_ToUpper (register Char cc)
{
	if (Char_IsAscii (cc) && ('a' <= Char_Code (cc) && Char_Code (cc) <= 'z'))
		return	Char_MakeAscii ((char)(Char_Code (cc) + 'A' - 'a')) ;
	return	cc ;
}

#endif
