/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (bufstring_h)
#define	bufstring_h

#include "local.h"
#include "Char.h"

struct tagBufStringMarker ;
struct tagBufStringNode ;
struct tagBufStringLeaf ;
struct tagBufString;

struct tagBufString {
	struct tagBufStringNode*	m_pRoot ;
	struct tagBufStringLeaf*	m_pHead ;
} ;

struct tagBufStringMarker {
	struct tagBufString*		m_pBufString ;
	struct tagBufStringLeaf*	m_pLeaf ;
	int							m_nPosition ;
	int							m_nOffset ;
} ;

typedef	struct tagBufStringMarker	TBufStringMarker ;
typedef struct tagBufString			TBufString ;


Boolean	TBufString_Initialize			(TBufString*) ;
Boolean	TBufString_Uninitialize			(TBufString*) ;
Boolean	TBufString_SolveMarker			(TBufString*, int, TBufStringMarker*) ;
int		TBufString_GetLength			(TBufString*) ;
Boolean	TBufStringMarker_InsertString	(TBufStringMarker*, const Char*, int) ;
Boolean	TBufStringMarker_InsertChar		(TBufStringMarker*, Char, int) ;
Boolean	TBufStringMarker_DeleteChar		(TBufStringMarker*, int) ;
Boolean	TBufStringMarker_Forward		(TBufStringMarker*, int) ;
Boolean	TBufStringMarker_Backward		(TBufStringMarker*, int) ;
int		TBufStringMarker_GetOffset		(TBufStringMarker*) ;
Char	TBufStringMarker_GetChar		(TBufStringMarker*) ;
void	TBufStringMarker_SetVoid		(TBufStringMarker*) ;
Boolean	TBufStringMarker_Voidp			(TBufStringMarker*) ;

#endif

