/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include "dispatch.h"
#include <assert.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <time.h>
//#include "skkinput.h"
#include "KinputServer.h"
#include "TRootWindow.h"
#include "TOverTheSpotWindow.h"
#include "TOffTheSpotWindow.h"
#include "TNormalFrame.h"
#include "KinputClientP.h"
#include "kanji.h"
#include "lispyevent.h"

static	int		kinputClient_getAttribute					(KinputClient*, unsigned long*, Atom, struct proprec*, TConversionAttribute*) ;
static	Boolean	kinputClient_getAttributeFromPropertySub	(KinputClient*, Atom, Atom, struct proprec*, TConversionAttribute*) ;
static	int		kinputClient_getAttributeFromPropertySub2	(KinputClient*, Atom, Atom, unsigned long**) ;
static	int		kinputClient_onFocusKeyPress				(void*, XEvent*) ;
static	int		kinputClient_onRequestorDestroy				(void*, XEvent*) ;
static	void	kinputClient_onKeyPress						(Widget, XtPointer, XtPointer) ;
static	void	kinputClient_onFrameConfigure				(Widget, XtPointer, XtPointer) ;
static	void	kinputClient_onFrameDestroy					(Widget, XtPointer, XtPointer) ;

static	Boolean	kinputClient_createFrame					(KinputClient*, TConversionAttribute*, Window) ;
static	Boolean	kinputClient_initializeLispPart				(KinputClient*, Widget, Widget) ;
static	void	kinputClient_onKeyNotify					(void*, TXEvent*) ;
static	void	kinputClient_onTextNotify					(void*, const Char*, int) ;
static	void	kinputClient_onEndNotify					(void*) ;


KinputClient*
KinputClient_New (
	register Widget		gw,
	register Window		wndRequestor)
{
	register KinputClient*	pClient	;

	pClient	= MALLOC (sizeof (KinputClient)) ;
	if (pClient == NULL) 
		return	NULL ;

	TLispClient_PreInitialize (&pClient->m_LispClient) ;
	pClient->m_wgProtocol		= gw ;
	pClient->m_wgTopFrame		= NULL ;
	pClient->m_fReserve			= False ;
	pClient->m_fProbe			= False ;
	pClient->m_uAttributeMask	= 0L ;
	pClient->m_wndRequestor		= wndRequestor ;
	pClient->m_wndProbe			= None ;
	pClient->m_wndFocus			= None ;
	pClient->m_atTarget			= None ;
	pClient->m_atProperty		= None ;
	pClient->m_atSelection		= None ;
	pClient->m_pNext			= NULL ;
	return	pClient ;
}

Window
KinputClient_GetRequestor (
	register KinputClient*		pClient)
{
	assert (pClient != NULL) ;
	return	pClient->m_wndRequestor ;
}

Atom
KinputClient_GetSelection (
	register KinputClient*		pClient)
{
	assert (pClient != NULL) ;
	return	pClient->m_atSelection ;
}

Atom
KinputClient_GetTarget (
	register KinputClient*		pClient)
{
	assert (pClient != NULL) ;
	return	pClient->m_atTarget ;
}

Atom
KinputClient_GetProperty (
	register KinputClient*		pClient)
{
	assert (pClient != NULL) ;
	return	pClient->m_atProperty ;
}

Widget
KinputClient_GetFrame (
	register KinputClient*		pClient)
{
	assert (pClient != NULL) ;
	return	pClient->m_wgTopFrame ;
}

void
KinputClient_SetNext (
	register KinputClient*		pClient,
	register KinputClient*		pNext)
{
	assert (pClient != NULL) ;
	pClient->m_pNext	= pNext ;
	return ;
}

KinputClient*
KinputClient_GetNext (
	register KinputClient*		pClient)
{
	assert (pClient != NULL) ;
	return	pClient->m_pNext ;
}

/*
 * client ׵˽äơѴѤ Window 򵯤ؿ
	if (!kinputClient_Initialize (pClient, wndRequestor, atConversion, atProperty, wgThis->kinputServer.m_atCompoundText, atConversionString)) {
 */
Boolean
KinputClient_Initialize (
	register KinputClient*	pClient,
	register Atom			atSelection,
	register Atom			atProperty,
	register Atom			atConversionAttribute,
	register Atom			atClientProperty,
	register Atom			atClientTarget)
{
	register Display*		pDisplay ;
	register Window			wndProbe, wndFocus ;
	TConversionAttribute	attribute ;

	assert (pClient->m_wgProtocol   != NULL) ;
	assert (pClient->m_wndRequestor != None) ;

	pDisplay	= XtDisplay (pClient->m_wgProtocol) ;
	if (atProperty != None) {
		KinputClient_GetAttributeFromProperty (pClient, atProperty, atConversionAttribute, &attribute) ;
	} else {
		TConvAttr_Initialize (&attribute) ;
	}
	if ((attribute.m_uMask & CAEventSelect) == 0) {
		attribute.m_uMask	|= CAEventSelect ;
		attribute.m_nEventSelect	= CONVERSION_EVENTSELECT_INPUTONLY ;
	}
	if ((attribute.m_uMask & CAInputStyle) == 0) {
		attribute.m_uMask	|= CAInputStyle ;
		attribute.m_nInputStyle		= CONVERSION_INPUTSTYLE_ROOTWINDOW ;
	}
	pClient->m_fProbe		= True ;
	pClient->m_fReserve		= True ;
	pClient->m_atSelection	= atSelection ;
	pClient->m_atProperty	= atClientProperty ;
	pClient->m_atTarget		= atClientTarget ;

	if ((attribute.m_uMask & CAFocusWindow) && attribute.m_wndFocus != None) {
		wndFocus	= attribute.m_wndFocus ;
	} else {
		wndFocus	= pClient->m_wndRequestor ;
	}

	switch (attribute.m_nEventSelect) {
	case	CONVERSION_EVENTSELECT_INPUTONLY:
#if 0
		wndProbe	= XCreateWindow (XtDisplay (pClient->m_wgProtocol), wndFocus, 0, 0, 9999, 9999, 0, 0, InputOnly, (Visual *)CopyFromParent, 0L, NULL) ;
#else
		wndProbe	= XCreateWindow (XtDisplay (pClient->m_wgProtocol), pClient->m_wndRequestor, 0, 0, 9999, 9999, 0, 0, InputOnly, (Visual *)CopyFromParent, 0L, NULL) ;
#endif
		pClient->m_wndProbe	= wndProbe ;
		XMapWindow (XtDisplay (pClient->m_wgProtocol), wndProbe) ;
		break ;
	case	CONVERSION_EVENTSELECT_FOCUS:
		wndProbe	= wndFocus ;
		break ;
	default:
		wndProbe	= None ;
	}
#if defined (DEBUG)
	fprintf (stderr, "KinputClient(%ld): (EventSelect: %d, Window:%lx)\n",
			 time (NULL), attribute.m_nEventSelect, wndProbe) ;
#endif
	if (!kinputClient_createFrame (pClient, &attribute, wndFocus))
		return	False ;
	
	if (attribute.m_nEventSelect == CONVERSION_EVENTSELECT_INPUTONLY ||
		attribute.m_nEventSelect == CONVERSION_EVENTSELECT_FOCUS) {
		AfxRegisterWindow (pDisplay, wndProbe, KeyPress,   KeyPressMask,   pClient, kinputClient_onFocusKeyPress) ;
		AfxRegisterWindow (pDisplay, wndProbe, KeyRelease, KeyReleaseMask, pClient, kinputClient_onFocusKeyPress) ;
		if (wndProbe != pClient->m_wndRequestor)
			AfxRegisterWindow (pDisplay, wndProbe, DestroyNotify, StructureNotifyMask, pClient, kinputClient_onRequestorDestroy) ;
	}
	AfxRegisterWindow (pDisplay, pClient->m_wndRequestor, DestroyNotify, StructureNotifyMask, pClient, kinputClient_onRequestorDestroy) ;
#if defined (DEBUG)
	fprintf (stderr, "KinputClient(%ld): Initialize complete!\n", time (NULL)) ;
#endif
	TConvAttr_Uninitialize (&attribute) ;
	return	True ;
}

Boolean
KinputClient_Activate (
	register KinputClient*			pClient,
	register Boolean				fActive)
{
	assert (pClient != NULL) ;
	assert (pClient->m_wgTopFrame != NULL) ;

	TLispClient_Activate (&pClient->m_LispClient, fActive) ;
	if (fActive) {
		TLispClient_Reinitialize (&pClient->m_LispClient) ;
		TLispClient_SetModificationFlag (&pClient->m_LispClient, True) ;
	}

	/*	active ˤˤϡŽդ Window ⤷ʤ褦 unmap 
	 *	롣*/
	if (pClient->m_wndProbe != None) {
		if (fActive) {
			XMapWindow (XtDisplay (pClient->m_wgProtocol), pClient->m_wndProbe) ;
		} else {
			XUnmapWindow (XtDisplay (pClient->m_wgProtocol), pClient->m_wndProbe) ;
		}
	}
	return	True ;
}

Boolean
KinputClient_SetAttribute (
	register KinputClient*			pClient,
	register TConversionAttribute*	pAttribute)
{
	assert (pClient != NULL) ;
	assert (pAttribute != NULL) ;
	TFrame_SetAttribute (pClient->m_wgTopFrame, pAttribute) ;
	return	True ;
}

Boolean
KinputClient_GetAttributeFromProperty (
	register KinputClient*			pClient,
	register Atom					atProperty,
	register Atom					atConversionAttribute,
	register TConversionAttribute*	pResult)
{
	assert (pClient != NULL) ;
	assert (pResult != NULL) ;

	TConvAttr_Initialize (pResult) ;
	kinputClient_getAttributeFromPropertySub (pClient, atProperty, atConversionAttribute, NULL, pResult) ;
	return	True ;
}

Boolean
KinputClient_GetAttributeFromEvent (
	register KinputClient*			pClient,
	register XClientMessageEvent*	pEvent,
	register Atom					atConversionAttribute,
	register TConversionAttribute*	pResult)
{
	register unsigned long*	pData ;
	register int			nLength ;

	assert (pClient != NULL) ;
	assert (pEvent  != NULL) ;
	assert (pResult != NULL) ;

	TConvAttr_Initialize (pResult) ;
	pData	= (unsigned long *)(&(pEvent->data.l [2])) ;
	nLength	= *pData & 0x0000FFFF ;
	if (nLength >= 3)
		return	False ;
	kinputClient_getAttribute (pClient, pData, atConversionAttribute, NULL, pResult) ;
	return	True ;
}

void
KinputClient_Destroy (
	register KinputClient*		pClient)
{
	register Widget	wgFrame ;
	register Window	wndFocus, wndProbe ;

	wgFrame	= pClient->m_wgTopFrame ;

	/*	Widget -> Client ؤϤƻߤɬפ롣
	 */
	XtRemoveAllCallbacks (wgFrame, XtNkeyPressCallback) ;
	XtRemoveAllCallbacks (wgFrame, XtNconfigureCallback) ;
	XtRemoveAllCallbacks (wgFrame, XtNdestroyCallback) ;

	/*	ꤷƤä Event Handler ˴ɬפ롣*/
	wndFocus	= pClient->m_wndFocus ;
	wndProbe	= pClient->m_wndProbe ;
	if (wndFocus != None) {
		AfxUnregisterWindow (wndFocus, KeyPress,   KeyPressMask,   pClient, kinputClient_onFocusKeyPress) ;
		AfxUnregisterWindow (wndFocus, KeyRelease, KeyReleaseMask, pClient, kinputClient_onFocusKeyPress) ;
		if (wndFocus != pClient->m_wndRequestor) {
			AfxUnregisterWindow (wndFocus, DestroyNotify, StructureNotifyMask, pClient, kinputClient_onRequestorDestroy) ;
		}
	}
	if (wndProbe != None) {
		AfxUnregisterWindow (wndProbe, KeyPress,   KeyPressMask,   pClient, kinputClient_onFocusKeyPress) ;
		AfxUnregisterWindow (wndProbe, KeyRelease, KeyReleaseMask, pClient, kinputClient_onFocusKeyPress) ;
		AfxUnregisterWindow (wndProbe, DestroyNotify, StructureNotifyMask, pClient, kinputClient_onRequestorDestroy) ;
	}
	if (pClient->m_wndRequestor != None) 
		AfxUnregisterWindow (pClient->m_wndRequestor, DestroyNotify, StructureNotifyMask, pClient, kinputClient_onRequestorDestroy) ;

	/*	꥽롣
	 */
	TLispClient_Uninitialize (&pClient->m_LispClient) ;

	/*TFrame_Destroy (pClient->m_wgTopFrame) ;*/
	
	FREE (pClient) ;
	return ;
}

/*
 *  XtSetValues 򤷤Ѵ饤Ȥѹ줿ʬؼ
 * ٤ǤȻϻפ
 */
static	int
kinputClient_getAttribute (
	register KinputClient*			pClient,
	register unsigned long*			pAttributes,
	register Atom					atConversionAttribute,
	register struct proprec*		precp,
	register TConversionAttribute*	pResult)
{
	register unsigned long*	pAttribute	= pAttributes ;
	register int	nCode, nLength ;

	nCode	= (*pAttribute >> 16) & 0x0000FFFF ;
	nLength	= (*pAttribute >>  0) & 0x0000FFFF ;
#if defined (DEBUG) 
	fprintf (stderr, "KinputAttribute: Code(%d), Length(%d)\n",
			 nCode, nLength) ;
#endif

	pAttribute	++ ;
	switch (nCode) {
	case	KINPUT2_ATTRIBUTE_NONE:
		break ;
	case	KINPUT2_ATTRIBUTE_INDIRECT:
		if (nLength != 1)
			break ;
		kinputClient_getAttributeFromPropertySub (pClient, *pAttribute, atConversionAttribute, precp, pResult) ;
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_FOCUS_WINDOW:
		if (nLength != 1)
			break ;
		pResult->m_uMask	|= CAFocusWindow ;
		pResult->m_wndFocus	=  (Window) *pAttribute ;
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_SPOTLOCATION:
		if (nLength != 1)
			break ;
		pResult->m_uMask			|= CAPreeditMask ;
		pResult->m_Preedit.m_uMask	|= CASpotLocation ;
		pResult->m_Preedit.m_spot.x	=  (*pAttribute >> 16) & 0x0000FFFF ;
		pResult->m_Preedit.m_spot.y	=  (*pAttribute >>   0) & 0x0000FFFF ;
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_CLIENTAREA:
		if (nLength != 2)
			break ;
		pResult->m_uMask			|= CAPreeditMask ;
		pResult->m_Preedit.m_uMask	|= CAClientArea ;
		pResult->m_Preedit.m_area.x		= (*pAttribute >> 16) & 0x0000FFFF ;
		pResult->m_Preedit.m_area.y		= (*pAttribute >>  0) & 0x0000FFFF ;
		pAttribute	++ ;
		pResult->m_Preedit.m_area.width		= (*pAttribute >> 16) & 0x0000FFFF ;
		pResult->m_Preedit.m_area.height	= (*pAttribute >>  0) & 0x0000FFFF ;
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_INPUTSTYLE:
		if (nLength != 1)
			break ;
		pResult->m_uMask		|= CAInputStyle ;
#if defined (DEBUG) 
		fprintf (stderr, "InputStyle: (%lx)\n", *pAttribute) ;
#endif
		switch (*pAttribute ++) {
		case	KINPUT2_ATTRIBUTE_INPUTSTYLE_OVERTHESPOT:
			pResult->m_nInputStyle	= CONVERSION_INPUTSTYLE_OVERTHESPOT ;
			break ;
		case	KINPUT2_ATTRIBUTE_INPUTSTYLE_OFFTHESPOT:
			pResult->m_nInputStyle	= CONVERSION_INPUTSTYLE_OFFTHESPOT ;
			break ;
		case	KINPUT2_ATTRIBUTE_INPUTSTYLE_ROOTWINDOW:
		default:
			pResult->m_nInputStyle	= CONVERSION_INPUTSTYLE_ROOTWINDOW ;
			break ;
		}
		break ;
	case	KINPUT2_ATTRIBUTE_EVENTSELECT:
		if (nLength != 1)
			break ;
		pResult->m_uMask		|= CAEventSelect ;
#if defined (DEBUG) 
		fprintf (stderr, "EventSelect: (%lx)\n", *pAttribute) ;
#endif
		switch (*pAttribute) {
		case	KINPUT2_ATTRIBUTE_EVENTSELECT_NONE:
			pResult->m_nEventSelect	= CONVERSION_EVENTSELECT_NONE ;
			break ;
		case	KINPUT2_ATTRIBUTE_EVENTSELECT_FOCUS:
			pResult->m_nEventSelect	= CONVERSION_EVENTSELECT_FOCUS ;
			break ;
		default:
			pResult->m_nEventSelect	= CONVERSION_EVENTSELECT_INPUTONLY ;
			break ;
		}
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_COLORMAP:
		if (nLength != 1)
			break ;
		pResult->m_uMask		|= CAPreeditMask ;
		pResult->m_Preedit.m_uMask 		|= CAColormap ;
		pResult->m_Preedit.m_colormap	= *pAttribute ;
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_COLOR:
		if (nLength != 2)
			break ;
		pResult->m_uMask		|= CAPreeditMask ;
		pResult->m_Preedit.m_uMask 		|= (CAForegroundPixel | CABackgroundPixel)  ;
		pResult->m_Preedit.m_foreground	= *pAttribute ++ ;
		pResult->m_Preedit.m_background	= *pAttribute ++ ;
		break ;
		/* Ѵ饤ȤΥեȤξ*/
	case	KINPUT2_ATTRIBUTE_FONT:
		if (nLength < 1)
			break ;

		pResult->m_uMask			|= CAPreeditMask ;
		pResult->m_Preedit.m_uMask	|= CAFont ;
		/*	Font ϤˡϤɤΤ褦ˤ٤
		 */
		TFontSet_LoadAtom (XtDisplay (pClient->m_wgProtocol), &pResult->m_Preedit.m_FontSet, nLength, pAttribute, False) ;
		pAttribute	+= nLength ;
		break ;
	case	KINPUT2_ATTRIBUTE_STATUSAREA:
		/* ꤹ٤ΤμΤ¸ߤʤˤȴ롣*/
		if (nLength != 2)
			break ;
		pResult->m_uMask			|= CAStatusMask ;
		pResult->m_Status.m_uMask	|= CAClientArea ;
		pResult->m_Status.m_area.x		= (*pAttribute >> 16) & 0x0000FFFF ;
		pResult->m_Status.m_area.y		= (*pAttribute >>  0) & 0x0000FFFF ;
		pAttribute	++ ;
		pResult->m_Status.m_area.width	= (*pAttribute >> 16) & 0x0000FFFF ;
		pResult->m_Status.m_area.height	= (*pAttribute >>  0) & 0x0000FFFF ;
		pAttribute	++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_LINESPACING:
		/* ꤹ٤ΤμΤ¸ߤʤˤȴ롣*/
		if (nLength < 1)
			break ;
		pResult->m_uMask					|= CAPreeditMask ;
		pResult->m_Preedit.m_uMask			|= CALineSpacing ;
		pResult->m_Preedit.m_nLineSpacing	= *pAttribute ++ ;
		break ;
	case	KINPUT2_ATTRIBUTE_BACKGROUND_PIXMAP :
	case	KINPUT2_ATTRIBUTE_CURSOR :
		pAttribute	++ ;
	default :
		break ;
	}
	return	(pAttribute - pAttributes) ;
}

static	Boolean
kinputClient_getAttributeFromPropertySub (
	register KinputClient*			pClient,
	register Atom					atProperty,
	register Atom					atConversionAttribute,
	register struct proprec*		prevprop,
	register TConversionAttribute*	pResult)
{
	unsigned long*	pAttributes ;
	unsigned long*	pAttribute ;
	struct proprec	node ;
	register int	nTotalLength, nLength ;

	node.prop	= atProperty ;
	node.prev	= prevprop ;
	while (prevprop != NULL) {
		if (prevprop->prop == atProperty)
			return	False ;
		prevprop	= prevprop->prev ;
	}

	pAttributes		= NULL ;
	nTotalLength	= kinputClient_getAttributeFromPropertySub2 (pClient, atProperty, atConversionAttribute, &pAttributes) ;
	if (nTotalLength <= 0)
		return	False ;

	pAttribute		= pAttributes ;
	while (nTotalLength > 0) {
		nLength		= kinputClient_getAttribute (pClient, pAttribute, atConversionAttribute, &node, pResult) ;
		if (nLength <= 0)
			break ;
		pAttribute		+= nLength ;
		nTotalLength	-= nLength ;
	}
	XFree (pAttributes) ;
	return	True ;
}

static	int
kinputClient_getAttributeFromPropertySub2 (
	register KinputClient*		pClient,
	register Atom				atProperty,
	register Atom				atConversionAttribute,
	register unsigned long**	ppAttributes)
{
	Atom				atType ;
	int					nFormat ;
	unsigned long		nums, bytesafter ;
	
	XGetWindowProperty (XtDisplay (pClient->m_wgProtocol), pClient->m_wndRequestor, atProperty, 0L, 1000L, False, atConversionAttribute, &atType, &nFormat, &nums, &bytesafter, (unsigned char**)ppAttributes) ;
	if (nFormat != 32 || atType != atConversionAttribute) {
		if (*ppAttributes != NULL)
			XFree ((char *)*ppAttributes) ;
		*ppAttributes	= NULL ;
		return	0 ;
	}
	return	(int) nums ;
}

static	int
kinputClient_onFocusKeyPress (
	register void*		pClosure,
	register XEvent*	pEvent)
{
	register KinputClient*	pClient	= pClosure ;

#if defined (DEBUG) || 0
	fprintf (stderr, "kinputClient_onFocusKeyPress(%d)\n", pEvent->type) ;
#endif
	if (pEvent->type != KeyPress)
		return	0 ;

	TLispMachine_EventProc (pClient->m_LispClient.m_pLM, LMEVENT_KEYPRESS, pEvent, 0) ;
	TLispClient_SetModificationFlag (&pClient->m_LispClient, True) ;
	return	0 ;
}

static	int
kinputClient_onRequestorDestroy (
	register void*		pClosure,
	register XEvent*	pEvent)
{
	register KinputClient*	pClient	= pClosure ;

#if defined (DEBUG) 
	fprintf (stderr, "Requestor destroy\n") ;
#endif
	KinputServer_RemoveClient (pClient->m_wgProtocol, pClient) ;
	return	0 ;
}

void
kinputClient_onKeyPress (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register KinputClient*		pClient	= (KinputClient *) closure ;

#if defined (DEBUG) || 0
	{
		XEvent*	pEvent	= (XEvent*) call_data ;
		fprintf (stderr, "Event: type(%d), window(%lx)",
				 pEvent->type, pEvent->xany.window) ;
		if (pEvent->type == KeyPress)
			fprintf (stderr, "keycode(%u), state(%x)", 
					 pEvent->xkey.keycode, pEvent->xkey.state) ;
		fprintf (stderr, "\n") ;
	}
#endif
	/*	LispMachine, Event, LPARAM, RPARAM ν֤Ϥ롣
	 */
	TLispMachine_EventProc (pClient->m_LispClient.m_pLM, LMEVENT_KEYPRESS, call_data, 0) ;
	TLispClient_SetModificationFlag (&pClient->m_LispClient, True) ;
	return ;
}

void
kinputClient_onFrameConfigure (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register KinputClient*		pClient	= (KinputClient *) closure ;
	TLispEntity*	pEntFrame	= NULL ;
	
	pEntFrame	= TFrame_GetLispFrameObject (wgFrame) ;
	assert (pEntFrame != NULL) ;
	TLispMachine_EventProc (pClient->m_LispClient.m_pLM, LMEVENT_FRAMERESIZE, pEntFrame, call_data) ;
	TLispClient_SetModificationFlag (&pClient->m_LispClient, True) ;
	return ;
}

void
kinputClient_onFrameDestroy (
	register Widget		wgFrame,
	register XtPointer	closure,
	register XtPointer	call_data)
{
	register KinputClient*		pClient	= (KinputClient *) closure ;
	
	KinputServer_RemoveClient (pClient->m_wgProtocol, pClient) ;
	return ;
}

/*
 */
Boolean
kinputClient_createFrame (
	register KinputClient*					pClient,
	register TConversionAttribute*			pAttribute,
	register Window							wndFocus)
{
	register Widget	wgTop, wgFrame ;
	register Window	wndClient ;
	Widget	wgMinibufFrame ;
	Arg		rArg [8] ;
	int		nArg ;

	wndClient	= pClient->m_wndRequestor ;
	nArg		= 0 ;
	XtSetArg (rArg [nArg], XtNmappedWhenManaged,	False) ;		nArg ++ ;
	XtSetArg (rArg [nArg], XtNclientWindow,			wndClient) ;	nArg ++ ;
	XtSetArg (rArg [nArg], XtNfocusWindow,			wndFocus) ;		nArg ++ ;
	XtSetArg (rArg [nArg], XtNinput,				False) ;		nArg ++ ;

	wgTop	= AfxGetToplevelWidget () ;
	switch (pAttribute->m_nInputStyle) {
	case	CONVERSION_INPUTSTYLE_OVERTHESPOT:
		wgFrame			= TOverTheSpotWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	case	CONVERSION_INPUTSTYLE_OFFTHESPOT:
		wgFrame			= TOffTheSpotWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	case	CONVERSION_INPUTSTYLE_ROOTWINDOW:
	default:
		wgFrame			= TRootWindowFrame_Create (wgTop, rArg, nArg) ;
		break ;
	}
	if (wgFrame == NULL) 
		return	False ;

	pClient->m_wgTopFrame	= wgFrame ;
	KinputClient_SetAttribute (pClient, pAttribute) ;
	XtAddCallback (wgFrame, XtNkeyPressCallback,	kinputClient_onKeyPress,		(XtPointer)pClient) ;
	XtAddCallback (wgFrame, XtNconfigureCallback,	kinputClient_onFrameConfigure,	(XtPointer)pClient) ;
	XtAddCallback (wgFrame, XtNdestroyCallback,		kinputClient_onFrameDestroy,	(XtPointer)pClient) ;
	XtRealizeWidget (wgFrame) ;

	wgMinibufFrame	= NULL ;
	XtVaGetValues (wgFrame, XtNminibufFrame, &wgMinibufFrame, NULL) ;

	if (wgMinibufFrame != NULL && wgMinibufFrame != wgFrame) {
		XtAddCallback (wgMinibufFrame, XtNkeyPressCallback,		kinputClient_onKeyPress,		(XtPointer)pClient) ;
		XtAddCallback (wgMinibufFrame, XtNconfigureCallback,	kinputClient_onFrameConfigure,	(XtPointer)pClient) ;
		XtAddCallback (wgMinibufFrame, XtNdestroyCallback,		kinputClient_onFrameDestroy,	(XtPointer)pClient) ;
		XtRealizeWidget (wgMinibufFrame) ;
	}

	kinputClient_initializeLispPart (pClient, wgFrame, wgMinibufFrame) ;
	XFlush (XtDisplay (pClient->m_wgProtocol)) ;
	return	True ;
}

Boolean
kinputClient_initializeLispPart (
	register KinputClient*	pClient,
	register Widget			wgFrame,
	register Widget			wgMinibufFrame)
{
	register TLispManager*	pLispMgr ;
	TLispMachine*			pTopLM ;
	register TLispClient*	pLispClient ;
	TLispClientArg			arg ;
	Arg						rArg [1] ;
	register int			nArg ;

	assert (pClient  != NULL) ;

	nArg	= 0 ;
	XtSetArg (rArg [nArg], XtNlispMachine, &pTopLM) ;	nArg ++ ;
	XtGetValues (pClient->m_wgProtocol, rArg, nArg) ;

	pLispMgr	= TLispMachine_GetLispManager (pTopLM) ;
	pLispClient	= &pClient->m_LispClient ;
	arg.m_pLispMgr			= pLispMgr ;
	arg.m_pLM				= pTopLM ;
	arg.m_wgFrame			= wgFrame ;
	arg.m_wgMinibufFrame	= wgMinibufFrame ;
	arg.m_pKeyNotify		= &kinputClient_onKeyNotify ;
	arg.m_pTextNotify		= &kinputClient_onTextNotify ;
	arg.m_pEndNotify		= &kinputClient_onEndNotify ;
	arg.m_pvClient			= pClient ;
	return	TLispClient_Initialize (pLispClient, &arg) ;
}

void
kinputClient_onKeyNotify (
	register void*			pvClient,
	register TXEvent*		pEv)
{
	register KinputClient*	pClient		= (KinputClient *)pvClient ;
	register Display*		pDisplay	= XtDisplay (pClient->m_wgProtocol) ;
	register Window			wndFocus ;
	register Char			cc ;
	Window					wndRoot, wndChild ;
	int						nRootX, nRootY, nX, nY ;
	unsigned int			uKeyCode, uState, uMask ;
	XEvent					ev ;

	wndFocus	= (pClient->m_wndFocus != None)? pClient->m_wndFocus : pClient->m_wndRequestor ;
	if (!pEv->m_fChar) {
		register XEvent*	pXEv	= pEv->u.m_pEv ;
		register Window		wndWindowBak, wndSubwindowBak ;
		assert (pEv->u.m_pEv != NULL) ;
		wndWindowBak			= pXEv->xkey.window ;
		wndSubwindowBak			= pXEv->xkey.subwindow ;
		pXEv->xkey.window		= pClient->m_wndRequestor ;
		pXEv->xkey.subwindow	= None ;
		XSendEvent (pDisplay, wndFocus, True, KeyPressMask, pXEv) ;
		pXEv->xkey.window		= wndWindowBak ;
		pXEv->xkey.window		= wndSubwindowBak ;
		return ;
	}
	cc	= pEv->u.m_ch ;
	/*	Ʊ Screen ̵ˤϸ㲽ġ
	 */
	if (!XQueryPointer (pDisplay, wndFocus, &wndRoot, &wndChild, &nRootX, &nRootY, &nX, &nY, &uMask))
		return ;
	
	if (TFAILED (cchar2keycode (pDisplay, cc, &uKeyCode, &uState))) {
		Char	ch	= cc ;
		/*	Guess ˼Ԥˤ key-event Ȥ뤳Ȥ
		 *	ǤʤƥȤȤФ롣*/
		kinputClient_onTextNotify (pvClient, &ch, 1) ;
		return ;
	}
	
	ev.xkey.type		= KeyPress ;
	ev.xkey.display		= pDisplay ;
	ev.xkey.window		= wndFocus ;
	ev.xkey.root		= wndRoot ;
	ev.xkey.subwindow	= wndChild ;
	ev.xkey.time		= 0 ;	/* Τ */
	ev.xkey.x			= nX ;
	ev.xkey.y			= nY ;
	ev.xkey.x_root		= nRootX ;
	ev.xkey.y_root		= nRootY ;
	ev.xkey.state		= uState ;
	ev.xkey.keycode		= uKeyCode ;
	XSendEvent (pDisplay, wndFocus, True, KeyPressMask, &ev) ;
	return ;
}

/*
 * Kinput Protocol Ѵ׵ԤؤʸԤδؿ
 *-----
 * ʸ SkkInputWidget ƽФ뤿ᡢcallbackηˤʤ
 * Ƥ롣Ͻ;ϤäѤ뤱ɡĤޤ괺ư
 * ˤʤäƤľޤ
 */
void
kinputClient_onTextNotify (
	register void*			pvClient,
	register const Char*	pText,
	register int			nText)
{
	register KinputClient*	pClient	= (KinputClient *)pvClient ;
	KANJISTATEMACHINE		ksm ;
	char					rchBuf [16] ;
	register int			nptr, nctext, i ;
	register char*			pctext ;
	register char*			ptr ;
	register const Char*	pCH ;

	InitializeKanjiFiniteStateMachine (&ksm, KCODING_SYSTEM_COMPOUND_TEXT) ;
	nctext	= 0 ;
	pCH		= pText ;
	for (i = 0 ; i < nText ; i ++) 
		nctext	+= RtransferKanjiFiniteStateMachine (&ksm, *pCH ++, rchBuf) ;
#if defined (DEBUG)
	fprintf (stderr, "CompoundText = %d\n", nctext) ;
#endif
	if (nctext <= 0) 
		return ;
	pctext		= MALLOC ((nctext + 3) & ~3) ;
	InitializeKanjiFiniteStateMachine (&ksm, KCODING_SYSTEM_COMPOUND_TEXT) ;
	ptr			= pctext ;
	pCH			= pText ;
	for (i = 0 ; i < nText ; i ++) {
		if (*pCH == '\r') {
			*ptr ++	= '\n' ;
		} else {
			nptr	= RtransferKanjiFiniteStateMachine (&ksm, *pCH, ptr) ;
			ptr		+= nptr ;
		}
		pCH	++ ;
	}
	KinputServer_FixText (pClient->m_wgProtocol, pClient, pctext, nctext) ;
	FREE (pctext) ;
	return ;
}					

void
kinputClient_onEndNotify (
	register void*			pvClient)
{
	register KinputClient*	pClient	= (KinputClient *)pvClient ;

	KinputServer_EndConversion (pClient->m_wgProtocol, pClient) ;
	/*	TopWidget ǤʤƤ Frame  deactivate ʤȤʤ
	 *	ޤޤǤƤʤ*/
	KinputClient_Activate (pClient, False) ;
	return ;
}



