/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (KinputServerP_h)
#define KinputServerP_h

#include "KinputServer.h"
#include "KinputClient.h"
#include <X11/CoreP.h>

#define	KINPUT_PROTOCOL_VERSION				"PROTOCOL-2.0"
#define	KINPUT_CONVERSION_ATTRIBUTE_TYPE	"_CONVERSION_ATTRIBUTE_TYPE"
#define	KINPUT_CONVERSION_PROFILE			"_CONVERSION_PROFILE"

#define	KINPUT_CONVERSION_PROFILE_PROTOCOL_VERSION		(1)
#define	KINPUT_CONVERSION_PROFILE_SUPPORTED_STYLES		(2)
#define	KINPUT_CONVERSION_PROFILE_SUPPORTED_EXTENSIONS	(3)
#define	KINPUT_CONVERSION_PROFILE_EXTENSION_DATA		(4)
#define	KINPUT_CONVERSION_STYLE_ROOTWINDOW				(1)
#define	KINPUT_CONVERSION_STYLE_OFFTHESPOT				(2)
#define	KINPUT_CONVERSION_STYLE_OVERTHESPOT				(4)

#define	MAKE_CONVERSION_ATTRIBUTE(code,len)	((((unsigned long)(code) & 0xFFFF) << 16) | (unsigned short)(len))

typedef struct {
	XtPointer		m_pLispMachine ;
	Boolean			m_fEnableKinput1 ;		/* Kinput Protocol ̤ɤ */
	XtCallbackList	m_lstCbkDestroy ;

	Atom			m_atConversion ;
	Atom			m_atOldConversion ;
	Atom			m_atCompoundText ;
	Atom			m_atConversionString ;
	Atom			m_atConversionNotify ;
	Atom			m_atConversionEnd ;
	Atom			m_atConversionAttribute ;

	KinputClient*	m_lstClient ;
} KinputServerPart ;

typedef struct tagKinputServerRec {
	CorePart 			core ;
	KinputServerPart	kinputServer ;
}	KinputServerRec ;

/* New fields for the My widget class record */
typedef struct {
	int 				dummy ;
}	KinputServerClassPart ;

typedef struct  tagKinputServerClassRec {
	CoreClassPart			core_class ;
	KinputServerClassPart	kinputServer_class ;
}	KinputServerClassRec ;

extern	KinputServerClassRec kinputServerClassRec ;

#endif
