/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined (XIMClient_h)
#define	XIMClient_h

#include "XIMInputMethod.h"
#include "XIMInputContext.h"
#include "TOnTheSpotWindow.h"
#include "Char.h"

#if !defined (XtNclientWindow)
#define	XtNclientWindow		"clientWindow"
#endif
#if !defined (XtCClientWindow)
#define	XtCClientWindow		"ClientWindow"
#endif
#if !defined (XtNlispMachine)
#define	XtNlispMachine		"lispMachine"
#endif
#if !defined (XtCLispMachine)
#define	XtCLispMachine		"LispMachine"
#endif
#if !defined (XtNprotocolWidget)
#define	XtNprotocolWidget	"protocolWidget"
#endif
#if !defined (XtCProtocolWidget)
#define	XtCProtocolWidget	"ProtocolWidget"
#endif

typedef struct tagXIMClientRec*			XIMClientWidget ;
typedef struct tagXIMClientClassRec*	XIMClientWidgetClass ;

extern	WidgetClass	ximClientWidgetClass ;

Boolean	XIMClient_ForwardEvent 		(Widget, XIMInputMethod*, XIMInputContext*, XEvent*) ;
Boolean	XIMClient_ControlEventFlow	(Widget, XIMInputMethod*, XIMInputContext*, Boolean) ;
Boolean	XIMClient_CommitString		(Widget, XIMInputMethod*, XIMInputContext*, const Char*, int) ;
Boolean	XIMClient_PreeditStateChange(Widget, XIMInputMethod*, XIMInputContext*) ;


void	XIMClient_WriteXimGeometry	(Widget, int, int) ;
void	XIMClient_WritePreeditStart	(Widget, int, XIMInputContext*) ;
void	XIMClient_WritePreeditDraw	(Widget, int, XIMInputContext*, const TOnTheSpotDrawArg*) ;
void	XIMClient_WritePreeditCaret	(Widget, int, XIMInputContext*, const TOnTheSpotDrawArg*) ;
void	XIMClient_WritePreeditDone	(Widget, int, XIMInputContext*) ;
void	XIMClient_WriteStatusStart	(Widget, int, XIMInputContext*) ;
void	XIMClient_WriteStatusDraw	(Widget, int, XIMInputContext*, const TOnTheSpotDrawArg*) ;
void	XIMClient_WriteStatusDone	(Widget, int, XIMInputContext*) ;

#endif

