/* # skkinput (Simple Kana-Kanji Input)
 *
 * This file is part of skkinput.
 * Copyright (C) 2002
 * Takashi SAKAMOTO (PXG01715@nifty.ne.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "AfxWin.h"
#include "varbuffer.h"
#include "ttext.h"

int
TTextOut (
	register Display*		pDisplay,
	register Drawable		d,
	register GC				gc,
	register TFontSet*		pFontSet,
	register int			x,
	register int			y,
	register const Char*	pText,
	register int			nText,
	register TSize*			pSizeReturn)
{
	TVarbuffer		vbText8 ;
	TVarbuffer		vbText16 ;
	register TFont*			pFont ;
	register const Char*	pHead ;
	register int			nSet ;
	register int			iOrgX ;
	register int			nSize, nUsage8, nUsage16 ;
	register char*			pc8 ;
	register XChar2b*		pc16 ;

	assert (nText > 0) ;
	assert (pText != NULL) ;
	
	TVarbuffer_Initialize (&vbText8,  sizeof (char)) ;
	TVarbuffer_Initialize (&vbText16, sizeof (XChar2b)) ;
	nUsage8		= 0 ;
	nUsage16	= 0 ;
	iOrgX		= x ;

	while (nText > 0) {
		nSet	= Char_Charset (*pText) ;
		pHead	= pText ;
		if (nSet < KCHARSET_2BYTES_CHARACTER) {
			while (nText > 0 && nSet == Char_Charset (*pText)) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage8) {
					TVarbuffer_Require (&vbText8, nSize - nUsage8) ;
					nUsage8	= nSize ;
				}

				pc8	= TVarbuffer_GetBuffer (&vbText8) ;
				while (pHead != pText) {
					*pc8 ++	= Char_Code (*pHead) ;
					pHead	++ ;
				}

				XSetFont (pDisplay, gc, TFont_GetFontStruct (pFont)->fid) ;
				XDrawImageString (pDisplay, d, gc, x, y, TVarbuffer_GetBuffer (&vbText8), nSize) ;
				x	+= XTextWidth (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText8), nSize) ;
			}
		} else {
			while (nText > 0 && nSet == Char_Charset (*pText)) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage16) {
					TVarbuffer_Require (&vbText16, nSize - nUsage16) ;
					nUsage16	= nSize ;
				}

				pc16	= TVarbuffer_GetBuffer (&vbText16) ;
				while (pHead != pText) {
					pc16->byte1	= Char_Code (*pHead) >> 8 ;
					pc16->byte2	= Char_Code (*pHead) ;
					pc16	++ ;
					pHead	++ ;
				}

				XSetFont (pDisplay, gc, TFont_GetFontStruct (pFont)->fid) ;
				XDrawImageString16 (pDisplay, d, gc, x, y, TVarbuffer_GetBuffer (&vbText16), nSize) ;
				x	+= XTextWidth16 (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText16), nSize) ;
			}
		}
	}

	if (pSizeReturn != NULL) {
		pSizeReturn->cx	= x - iOrgX ;
		pSizeReturn->cy	= pFontSet->m_iHeight ;
	}

	TVarbuffer_Uninitialize (&vbText8) ;
	TVarbuffer_Uninitialize (&vbText16) ;
	return	0 ;
}

int
TGetTextExtents (
	register TFontSet*		pFontSet,
	register const Char*	pText,
	register int			nText,
	register TSize*			pSizeReturn)
{
	TVarbuffer	vbText8 ;
	TVarbuffer	vbText16 ;
	register TFont*			pFont ;
	register const Char*	pHead ;
	register int			nSet ;
	register int			nSize, nUsage8, nUsage16 ;
	register int			x ;
	register char*			pc8 ;
	register XChar2b*		pc16 ;

	TVarbuffer_Initialize (&vbText8,  sizeof (char)) ;
	TVarbuffer_Initialize (&vbText16, sizeof (XChar2b)) ;
	nUsage8		= 0 ;
	nUsage16	= 0 ;
	x			= 0 ;

	while (nText > 0) {
		nSet	= Char_Charset (*pText) ;
		pHead	= pText ;
		if (nSet < KCHARSET_2BYTES_CHARACTER) {
			while (nText > 0 && nSet == Char_Charset (*pText)) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage8) {
					TVarbuffer_Require (&vbText8, nSize - nUsage8) ;
					nUsage8	= nSize ;
				}

				pc8	= TVarbuffer_GetBuffer (&vbText8) ;
				while (pHead != pText) {
					*pc8 ++	= Char_Code (*pHead) ;
					pHead	++ ;
				}

				x	+= XTextWidth (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText8), nSize) ;
			}
		} else {
			while (nText > 0 && nSet == Char_Charset (*pText)) {
				pText	++ ;
				nText	-- ;
			}

			pFont	= TFontSet_GetFont (pFontSet, nSet) ;
			if (pFont != NULL) {
				nSize	= pText - pHead ;
				if (nSize > nUsage16) {
					TVarbuffer_Require (&vbText16, nSize - nUsage16) ;
					nUsage16	= nSize ;
				}

				pc16	= TVarbuffer_GetBuffer (&vbText16) ;
				while (pHead != pText) {
					pc16->byte1	= Char_Code (*pHead) >> 8 ;
					pc16->byte2	= Char_Code (*pHead) ;
					pc16	++ ;
					pHead	++ ;
				}

				x	+= XTextWidth16 (TFont_GetFontStruct (pFont), TVarbuffer_GetBuffer (&vbText16), nSize) ;
			}
		}
	}

	TVarbuffer_Uninitialize (&vbText8) ;
	TVarbuffer_Uninitialize (&vbText16) ;

	if (pSizeReturn != NULL) {
		pSizeReturn->cx	= x ;
		pSizeReturn->cy	= pFontSet->m_iHeight ;
	}

	return	0 ;
}


