;; skk-gadget.el -- ¹ѴΤΥץ
;; Copyright (C) 1995, 1996, 1997, 1998, 1999
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Maintainer: Murata Shuuichirou  <mrt@astec.co.jp>
;;             Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-trial.el,v 1.2 2002/12/16 12:36:53 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/12/16 12:36:53 $

;; This file is part of SKK.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

(defun skk-date (&optional and-time)
  (let* ((str (current-time-string))
	 (y (- (string-to-int (substring str 20 24)) 1988))
	 (year (if skk-date-ad
		   (j-num (substring str 20 24))
		 (if (= y 1) "" (j-num (int-to-string y)))))
	 (mon (substring str 4 7))
	 (month
	  (j-num
	   (cdr (assoc mon
		       '(("Jan" . "1") ("Feb" . "2") ("Mar" . "3")
			 ("Apr" . "4") ("May" . "5") ("Jun" . "6")
			 ("Jul" . "7") ("Aug" . "8") ("Sep" . "9")
			 ("Oct" . "10") ("Nov" . "11") ("Dec" . "12"))))))
	 (day (j-num (substring str 8 10)))
	 (dw (substring str 0 3))
	 (day-of-week
	  (cdr (assoc dw
		      '(("Sun" . "") ("Mon" . "") ("Tue" . "")
			("Wed" . "") ("Thu" . "") ("Fri" . "")
			("Sat" . "")))))
	 )
    (concat (if skk-date-ad "" "ʿ") year "ǯ"
	    month "" day "" "\(" day-of-week "\)"
	    (if and-time
		(let ((hour (substring str 11 13))
		      (minute (substring str 14 16))
		      (second (substring str 17 19)))
		  (concat " " hour "" minute "ʬ" second ""))))))

(defun j-clock (&optional kakutei-when-quit time-signal)
  (interactive "*")
  (let ((start (current-time-string))
	(local-map (current-local-map))
	finish mes)
    (unwind-protect
	(progn 
	  (use-local-map nil)
	  (condition-case nil
	      (let (case-fold-search
		    inhibit-quit
		    visible-bell)
		(while (not quit-flag)
		  (setq mes (skk-date t))
		  (message (concat  mes "    Hit any key to quit"))
		  (unless (sit-for 1)
		    (read-event)
		    (signal 'quit nil))))
	    (quit
	     (prog2
		 (setq finish (current-time-string))
		 (skk-date t)
	       ;;(skk-use-local-map skk-map)
	       (if kakutei-when-quit
		   (setq skk-kakutei-flag t) )
	       (message (concat "в :" (j-time-diff start finish)))))))
      (progn
	(use-local-map local-map)))))

(defun j-time-diff (start finish)
  ;; (current-time-string) ֤ START  FINISH λֺᡢ
  ;; ":ʬ:" η֤skk-clock Υ֥롼
  (let ((s-hour (string-to-int (substring start 11 13)))
        (s-minute (string-to-int (substring start 14 16)))
        (s-second (string-to-int (substring start 17 19)))
        (f-hour (string-to-int (substring finish 11 13)))
        (f-minute (string-to-int (substring finish 14 16)))
        (f-second (string-to-int (substring finish 17 19)))
        second-diff minute-diff hour-diff )
    (if (not (string= (substring start 20) (substring finish 20)))
        (error "㤦ǯλֺϷ׻Ǥޤ"))
    (setq second-diff (- f-second s-second))
    (if (> 0 second-diff)
        (setq f-minute (1- f-minute)
              second-diff (- (+ f-second 60) s-second) ))
    (setq minute-diff (- f-minute s-minute))
    (if (> 0 minute-diff)
        (setq f-hour (1- f-hour)
              minute-diff (- (+ f-minute 60) s-minute) ))
    (setq hour-diff (- f-hour s-hour))
    (if (> 0 hour-diff)
        (error "裲裱λ֤ǤʤФʤޤ"))
    (format "%02d:%02d:%02d" hour-diff minute-diff second-diff) ))

