;;; skk-comp.el --- 䴰ΤΥץ
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997
;;               1999
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Maintainer: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-comp.el,v 1.1 2002/11/27 13:17:35 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/11/27 13:17:35 $

;; This file is part of SKK.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;;  (TAB) -> Ȥ (.) -> Ȥ (,) -> Ȥ(.) -> Ȥ

;;; Code:
;(eval-when-compile (require 'skk))
(require 'skk-foreword)

;;;###autoload
(defgroup skk-comp nil "SKK completion related customization."
  :prefix "skk-"
  :group 'skk )

;;; -- user variables
(defcustom skk-dabbrev-like-completion nil
  "*Non-nil ǤСФ䴰ˤơǸ䴰줿ˤĤƹ䴰Ԥ롣
㤨С

  \"\" (,) -> \"Ȥ\" (,) -> \"Ȥ󤻤\"

nil ǤСƬʸ̤ˤʸˤĤ䴰Ԥʤ롣
㤨С

  \"\" (,) -> \"Ȥ\" (,) -> \"Ȥ\" (,) -> \"\""
  :type 'boolean
  :group 'skk-comp )

(defcustom skk-completion-function 'skk-completion-original
  "*skk-completion ǻѤؿ
skk-comp.el ʳ䴰ǽѤǤ褦˴ؿ funcall ˤƤ"
  :type 'function
  :group 'skk-comp )

(defcustom skk-previous-completion-function 'skk-previous-completion-original
  "*skk-previous-completion ǻѤؿ
skk-comp.el ʳ䴰ǽѤǤ褦˴ؿ funcall ˤƤ"
  :type 'function
  :group 'skk-comp )

(defcustom skk-comp-load-hook nil
  "*skk-comp.el ɤ˥뤵եå"
  :type 'hook
  :group 'skk-comp )

;;; -- internal variables
;; ---- buffer local variables
;; ʸФ skk-completion Ƥ֤Ȥ⤢ꤦΤǡ""  nil Ǥ
;; ѤǤʤ
(skk-deflocalvar skk-completion-word ""
  "䴰٤Ф졣
skk-dabbrev-like-completion  non-nil ξϡ˺Ǹ䴰Ф줬
롣" )
;; Ͽߥ˥Хåե䴰硢ΥХåեäȤ
;; skk-completion-word ͤ˲Ƥʤ٥

(skk-deflocalvar skk-completion-stack nil
  "䴰¸Ƥå" )

(skk-deflocalvar skk-completion-depth 0
  "䴰 skk-completion-stack Ф֡" )

;;;###autoload
(defun skk-start-henkan-with-completion (arg)
  "⡼ɤɤߤ䴰Ԥʤä塢Ѵ롣
ʳΥ⡼ɤǤϥꥸʥΥޥåפ˳դ줿ޥɤ򥨥ߥ졼
Ȥ롣"
  (interactive "*P")
  (if (and skk-henkan-on (not skk-henkan-active))
      (progn
        (skk-completion (not (eq last-command 'skk-completion)))
        (skk-start-henkan arg) )
    (skk-emulate-original-map arg) ))

;;;###autoload
(defun skk-completion (first)
  ;; skk-try-completion Υ֥롼
  ;; skk-comp.el ʳ䴰ǽѤǤ褦˴ؿ funcall ˤƤ
  (funcall skk-completion-function first) )

(defun skk-completion-original (first)
  ;; default  skk-completion-function.
  (let ((inhibit-quit t)
	;; skk-num  require Ƥʤ buffer-local ͤ줢ꡣ
        skk-num-list
        completion-word c-word )
    (skk-kana-cleanup 'force)
    (and first (setq skk-completion-stack nil skk-completion-depth 0))
    (and (or first skk-dabbrev-like-completion)
	 (setq skk-completion-word
	       (buffer-substring-no-properties skk-henkan-start-point (point)) ))
    (and (string= skk-completion-word "")
	 (skk-error "ʸ䴰뤳ȤϤǤޤ"
		    "Cannot complete an empty string!" ))
    (if (> skk-completion-depth 0)
	;; (õѤߤɤߤ򥢥)
	(setq skk-completion-depth (1- skk-completion-depth)
	      c-word (nth skk-completion-depth skk-completion-stack))
      ;; (ɤߤ򼭽Хåեõ)
      ;; skk-completion-word ϥХåեͤʤΤǡХåե˰ܤ
      ;; ѿ˰ܤѤƤ
      (setq completion-word skk-completion-word)
      (with-current-buffer (skk-get-jisyo-buffer skkinput-jisyo)
	(if first (goto-char skk-okuri-nasi-min))
	(save-match-data
	  ;; case-fold-search ϡХåեǤϾ nil
	  (while
	      (and (not c-word)
		   (search-forward
		    (concat "\n"
			    (if skk-use-numeric-conversion
				(skk-num-compute-henkan-key completion-word)
			      completion-word ))
		    nil t ))
	    (if (eq (following-char) ?\040) ;SPC
		nil
	      (setq c-word (concat completion-word
				   (buffer-substring-no-properties
				    ;; Ф˶ϴޤޤʤ" /" 򥵡
				    ;; ɬפϤʤ
				    (point) (1- (search-forward " ")) )))))))
      (and (not c-word) skk-abbrev-mode skk-use-look
	   (setq c-word (skk-look-completion)) )
      ;; ˸ĤȤ cons 롣
      (setq skk-completion-stack (cons c-word skk-completion-stack)) )
    ;; Хåեγ
    (if (not c-word)
	(progn
	  (setq skk-completion-depth (1+ skk-completion-depth))
	  (if skk-japanese-message-and-error
	      (error "\"%s\" 䴰٤Ф%sޤ"
		     skk-completion-word (if first "" "¾") )
	    (error "No %scompletions for \"%s\""
		   (if first "" "more ") skk-completion-word )) )
      (delete-region skk-henkan-start-point (point))
      (insert c-word) )))

;;;###autoload
(defun skk-previous-completion ()
  ;; skk-abbrev-comma, skk-insert-comma Υ֥롼ľ䴰Ԥä
  ;; Ф롣
  ;; skk-comp.el ʳ䴰ǽѤǤ褦˴ؿ funcall ˤƤ
  (funcall skk-previous-completion-function) )

(defun skk-previous-completion-original ()
  ;; default  skk-previous-completion-function.
  (let ((inhibit-quit t)
        (c-word 
	 (progn
	   (setq skk-completion-depth (1+ skk-completion-depth))
	   (nth skk-completion-depth skk-completion-stack) )))
    (if c-word
	(progn
	  (delete-region skk-henkan-start-point (point))
	  (insert c-word) )
      (setq skk-completion-depth (1- skk-completion-depth))
      (skk-error "\"%s\"䴰٤Ф¾ˤޤ"
                 "No more previous completions for \"%s\""
                 skk-completion-word ))))

(run-hooks 'skk-comp-load-hook)

(provide 'skk-comp)
;;; Local Variables:
;;; End:
;;; skk-comp.el ends here
