;; -*-byte-compile-dynamic: t;-*-
;;; skk-look.el --- UNIX look command interface for SKK
;; Copyright (C) 1998, 1999 Mikio Nakajima <minakaji@osaka.email.ne.jp>

;; Author: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Maintainer: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-look.el,v 1.1 2002/11/27 13:17:35 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/11/27 13:17:35 $

;; This file is not part of SKK yet.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:
;;
;; <How to work>
;; .skk  .emacs  `skk-use-look'  t ˥åȤƤɾƲ
;;  skk-mode Ω夲뤫M-x skk-restart ȡ Τ褦ʷǽ
;; ʤޤ
;;
;; (1)ñ䴰Ǥޤ
;;
;;    abstr(TAB) ---> abstract 
;;
;;    ̾䴰ǽƱ͡`.' Ǽ䴰䡢`,' ǤҤȤ䴰
;;    ưǤޤ
;;
;;    SKK α¼񤬤С SPC 򲡤ƱѴǤޤ
;;    ͡
;;
;; (2)ñ򤢤ޤѴƼФȤǤޤ
;;
;;    abstr* (SPC) ---> abstract 
;;
;;    Ф˥ꥹ (`*') Τ˺ʤ
;;
;;    ꤹȡ`abstr*' 򸫽Ф졢`abstract' Ȥ륨ȥ꤬Ŀͼ
;;    ɲäޤΤ褦ʥȥɲäʤϡ
;;    桼ѿ`skk-search-excluding-word-pattern-function' Ŭڤ
;;    ꤹ뤳Ȥǡ¸뤳ȤǤޤܤϡ
;;    `skk-search-excluding-word-pattern-function' ΥɥȤ
;;
;; (3)(2)Ѵ塢˺ƵŪʱѴԤʤȤǤޤ
;;
;;    ޤ`skk-look-recursive-search' ͤ non-nil ˥åȤƲ
;;    Emacs/SKK ƵưɬפϤޤ
;;
;;    ȡ㤨С
;;
;;    abstr* (SPC)
;;
;;      ---> abstract (SPC) -> ֥ȥ饯 (SPC) ->  (SPC)
;;        -> abstraction (SPC) -> ֥ȥ饯
;;
;;    Τ褦˱ñ + αñ򸫽ФˤΡ֥åȡפѴ
;;    ̤ȤƽϤ뤳ȤǤޤ
;;
;;    κݡ`skk-look-expanded-word-only' ͤ non-nil ǤСƵ
;;    ñΡ֥åȡפϤ뤳ȤǤޤ (Ƶ
;;    ǸФʤäñ̵뤷ƽϤޤ) 
;;
;;    SKK 
;;
;;       abstract /֥ȥ饯//
;;       abstraction /֥ȥ饯/
;;
;;    Ȥȥ꤬뤳ȤȤƤޤedict  SKK 
;;    ѴɤǤ͡
;; 
;; ưǧԤʤä look ϡSlackware 3.5 äƤman page 
;; `BSD Experimental June 14, 1993' ȵܤΤ (С󤬤ʤ) ˤ
;; ԤʤäƤޤץλʤɤۤʤ look С󲼤
;; ꤤޤ

;; <Dictionary>
;; ftp://ftp.u-aizu.ac.jp:/pub/SciEng/nihongo/ftp.cc.monash.edu.au/
;; ֤Ƥ edict Ѥȼڤ˱¼񤬤Ǥޤ
;;
;;   % jgawk -f skk-10/lisp/look/edict2skk.awk edict > temp
;;   % skkdic-expr temp | skkdic-sort > SKK-JISYO.E2J
;;   % rm temp
;;
;; Ǥ SKK-JISYO.E2J ˡϿޤ
;;
;;   % skkdic-expr SKK-JISYO.E2J + /usr/local/share/skk/SKK-JISYO.L | skkdic-sort > SKK-JISYO.L
;;
;; ʤɤȤơSKK-JISYO.L ȥޡƻȤΤڤǤ

;; <Motivation>
;; ΥץϡeWnn for Linux/FreeBSD ιεǽҲ𤬤äΤ
;; ơ֤ʵǽʤ SKK ˤץȤǤ뤵פȻפȤޤ餯ʤ
;; ƽ񤤤ƤޤޤeWnn 餱ʡSKK!
;;
;; ΡSeiichi Namba <sn@asahi-net.email.ne.jp> Ȱ Emacs Lisp 
;; look interface 񤤤ȤΤǤϤκݤηиȤǤ
;; ޤȤ˴դޤ

;;; Code:
(eval-when-compile (require 'skk) (require 'skk-comp))
(require 'skk-foreword)
;; APEL
(require 'path-util)

;;;###autoload
(defgroup skk-look nil "SKK look conversion related customization."
  :prefix "skk-look-"
  :group 'skk )

;; user variable.
(defcustom skk-look-command (exec-installed-p "look")
  "*UNIX look ޥɤ̾"
  :type 'file
  :group 'skk-look )

(defcustom skk-look-ignore-case t
  "*Non-nil ǤСʸʸ̤ʤǸԤʤ
look ޥɤ˥ץ \"-f\" Ϥ"
  :type 'boolean
  :group 'skk-look )

(defcustom skk-look-dictionary-order t
  "*Non-nil ǤС˥Ȥ줿եѤ롣
look ޥɤ˥ץ \"-d\" Ϥ"
  :type 'boolean
  :group 'skk-look )

(defcustom skk-look-use-alternate-dictionary nil
  "*Non-nil ǤС/usr/dict/web2 ȤԤʤ
ǥեȤμϡ/usr/dict/words
look ޥɤ˥ץ \"-a\" Ϥ"
  :type '(choice file (const nil))
  :group 'skk-look )

(defcustom skk-look-termination-character nil
  "*Non-nil ǤСʸ UNIX look ޥɤȤüʸȤŪ˻ꤹ롣
look ޥɤ˥ץ \"-t\" ȤʸϤ"
  :type '(choice string (const nil))
  :group 'skk-look )

(defcustom skk-look-dictionary nil
  "*look ޥɤ뼭ե롣
nil ǤС/usr/dict/words Ѥ롣"
  :type '(choice file (const nil))
  :group 'skk-look )

(defcustom skk-look-recursive-search nil
  "*Non-nil ǤСlook ޥɤĤñѴˤƸԤʤ
Ƹη̡䤬ĤʤСαñ켫ȤȤƽϤ롣"
  :type 'boolean
  :group 'skk-look )

(defcustom skk-look-expanded-word-only t
  "*Non-nil ǤСlook νϤФƸΤߤǽŪʸȤɽ롣
skk-look-recursive-search  non-nil ǤȤΤͭ"
  :type 'boolean
  :group 'skk-look )

;; internal constant and variable.
(defconst skk-look-working-buffer " *skk look*")
(defvar skk-look-completion-words nil)


(and skk-look-command
     (null (member '(skk-look) skk-search-prog-list))
     (let ((pl skk-search-prog-list)
	   (n 0) dic mark )
       (while pl
	 (setq dic (car pl))
	 (if (memq (nth 1 dic) '(skk-jisyo skk-rdbms-private-jisyo-table))
	     (setq mark n
		   pl nil)
	   (setq pl (cdr pl)
		 n (1+ n) )))
       (skk-splice-in skk-search-prog-list (1+ mark)
		      '((skk-look)) )))

;; program
;;;###autoload
(defun skk-look ()
  ;; UNIX look ޥɤѤѴԤʤ
  ;; SKK abbrev ⡼ɤˤơʸ + ꥹ uncompleted spelling 
  ;; 롣
  (and skk-abbrev-mode
       (eq (skk-str-ref skk-henkan-key (1- (length skk-henkan-key))) ?*)
       (let ((args (substring skk-henkan-key 0 (1- (length skk-henkan-key))))
	     v )
	 (setq v (skk-look-1 args))
	 (if (not skk-look-recursive-search)
	     v
	   (let (skk-henkan-key v2 v3)
	     (while v
	       (let ((skk-current-search-prog-list
		      (delete '(skk-look) (copy-sequence skk-search-prog-list)) ))
		 (setq skk-henkan-key (car v))
		 (while skk-current-search-prog-list
		   (setq v3 (skk-search)
			 v2 (if (not skk-look-expanded-word-only)
				(skk-nunion v2 (cons (car v) v3))
			      (if v3
				  (skk-nunion v2 (cons (car v) v3))
				v2 )))))
	       (setq v (cdr v)) )
	     v2 )))))

(defun skk-look-1 (args)
  ;; core search engine
  (condition-case nil
      (save-excursion
	(let (opt buffer-read-only)
	  (set-buffer (get-buffer-create skk-look-working-buffer))
	  (erase-buffer)
	  (setq args (list args))
	  (and skk-look-dictionary (nconc args (list skk-look-dictionary)))
	  (and skk-look-dictionary-order (setq opt "d"))
	  (and skk-look-ignore-case (setq opt (concat "f" opt)))
	  (and skk-look-use-alternate-dictionary
	       (setq opt (concat "a" opt)) )
	  (and opt (setq args (cons (concat "-" opt) args)))
	  (and skk-look-termination-character
	       (setq args
		     (cons (list "-t" skk-look-termination-character) args) ))
 	  (and
	   (= 0 (apply 'call-process skk-look-command nil t nil args))
	   (> (buffer-size) 0)
	   (split-string (buffer-substring-no-properties (point-min) (1- (point-max)))
			 "\n" ))))
    (file-error
     (setq skk-search-prog-list (delete '(skk-look) skk-search-prog-list))
     (skk-error "ƥ look ޥɤĤޤ"
		"Sorry, can't find look command on your system" ))))

;;;###autoload
(defun skk-look-completion ()
  (or skk-look-completion-words
      (let ((stacked skk-completion-stack))
	;; look ʣθǤΤǡöƤơĤŤ complete 롣
	(setq skk-look-completion-words
	      (delete skk-completion-word (skk-look-1 skk-completion-word)) )
	(while stacked
	  (setq skk-look-completion-words
		(delete (car stacked) skk-look-completion-words)
		stacked (cdr stacked) ))))
  (prog1
      (car skk-look-completion-words)
    (setq skk-look-completion-words (cdr skk-look-completion-words)) ))

(provide 'skk-look)
;;; skk-look.el ends here
