;;; skk-num.el --- ѴΤΥץ
;; Copyright (C) 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997,
;;               1998, 1999, 2000
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>

;; Author: Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Maintainer: Mikio Nakajima <minakaji@osaka.email.ne.jp>
;; Version: $Id: skk-num.el,v 1.2 2002/12/06 14:58:57 tatari Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2002/12/06 14:58:57 $

;; This file is part of SKK.

;; SKK is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either versions 2, or (at your option)
;; any later version.

;; SKK is distributed in the hope that it will be useful
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SKK, see the file COPYING.  If not, write to the Free
;; Software Foundation Inc., 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;; Commentary:

;;; Code:
;(eval-when-compile (require 'skk) (require 'cl))
(require 'skk-foreword)

;;;###autoload
(defgroup skk-num nil "SKK number conversion related customization."
  :prefix "skk-num-"
  :group 'skk)

;; user variables.
(defcustom skk-num-type-alist
  '((0 . identity)
    (1 . skk-num-jisx0208-latin)
    (2 . skk-num-type2-kanji)
    (3 . skk-num-type3-kanji)
    (4 . skk-num-recompute)
    (5 . skk-num-type5-kanji)
    (9 . skk-num-shogi))
  "*ͤѴΤΡǥѴ˻ѤؿȤΥꥹȡ
Ǥϡ`\(ǥ . ؿ̾\)' ȤˤʤäƤ롣
ǥˤϡ㤨иФ줬 \"ʿ#1ǯ\" ΤȤ`#' ľɽ
integer `1' 롣

ǥȴؿδط \(ǥե\) ϲ̤ꡣ
    0 -> ̵Ѵ
    1 -> ѿѴ
    2 -> Ѵ \(̼ʤ\)
    3 -> Ѵ \(̼򤹤\)
    4 -> οΤΤ򥭡ˤƼƸ
    5 ->  (ʤɤǻѤʸ) Ѵ (̼򤹤)
    9 -> ǻѤ \(\"\" ʤ\) Ѵ" 
  :type '(repeat (cons (choice :tag "Index"
			       (integer 0) (integer 1) (integer 2) (integer 3)
			       (integer 4) (integer 5) (integer 9))
		  (function :tag "Function")))
  :group 'skk-num)

(defcustom skk-num-convert-float nil
  "*Non-nil ǤСưȤäФбѴԤʤ
ͤ non-nil ˤ뤳Ȥǡ\"#.# /#1#1/#0#0/\" ʤɤμ񸫽Ф
ǤʤʤΤǡա"
  :type 'boolean
  :group 'skk-num)

(defcustom skk-num-uniq (or (assq 4 skk-num-type-alist)
			    (and (assq 2 skk-num-type-alist)
				 (assq 3 skk-num-type-alist)))
  "*Non-nil ǤСۤʤɽǤѴ̤ƱͤʣƽϤʤ"
  :type 'boolean
  :group 'skk-num)

(defcustom skk-num-load-hook nil
  "*skk-num.el ɤ˥뤵եå"
  :type 'hook
  :group 'skk-num)

;; internal constants and variables
(defconst skk-num-alist-type1
  '((?0 . "") (?1 . "") (?2 . "") (?3 . "")
    (?4 . "") (?5 . "") (?6 . "") (?7 . "")
    (?8 . "") (?9 . "")
    (?. . "")				; (?. . ".") ɤͤ⤤뤫...
    (?  . ""))
  "ascii  char type ѿ string type Ϣۥꥹȡ
\"1995\" -> \"\" Τ褦ʸѴԤݤѤ롣")

(defconst skk-num-alist-type2
  '((?0 . "") (?1 . "") (?2 . "") (?3 . "")
    (?4 . "") (?5 . "") (?6 . "ϻ") (?7 . "")
    (?8 . "Ȭ") (?9 . "") (?  . ""))
  "ascii  char type ȴ string type Ϣۥꥹȡ
\"1995\" -> \"\" Τ褦ʸѴԤݤѤ롣")

(defconst skk-num-alist-type5
  '((?1 . "") (?2 . "") (?3 . "")
    (?4 . "") (?5 . "") (?6 . "ϻ") (?7 . "")
    (?8 . "Ȭ") (?9 . "") (?  . ""))
  "ascii  char type ȴ string type Ϣۥꥹȡ
\"1995\" -> \"ɴ彦\" Τ褦ʸѴԤݤѤ롣")

(skk-deflocalvar skk-num-list nil
  "skk-henkan-key ˴ޤޤɽʸΥꥹȡ
㤨С\"ؤ7ͤ10\" ѴԤȤskk-henkan-key 
\"ؤ7ͤ10\" Ǥꡢskk-num-list  \(\"7\" \"10\"\) Ȥʤ롣")

(defvar skk-num-recompute-key nil
  "#4 פΥˤͤκƷ׻ԤʤäȤθ")

(defun skk-num-compute-henkan-key (key)
  ;; KEY Ϣ³򸽤魯ʸ "#" ֤ʸ֤"12"
  ;;  "" ʤϢ³ 1 Ĥ "#" ֤뤳Ȥա
  ;; ֤ skk-num-list ˥ꥹȤη¸롣
  ;; 㤨СKEY  "ؤ7ǯ12" ǤС"ؤ#ͤ#"
  ;; Ѵskk-num-list  ("7" "12") ȤꥹȤ롣
  ;; θФθ˻Ѥ롣
  (let ((numexp (if skk-num-convert-float
		    "[.0-9]+" "[0-9]+")))
    ;;(setq skk-noconv-henkan-key key)
    (save-match-data
      ;; ̼ "," 롣
      (while (string-match "," key)
	(setq key (concat (substring key 0 (match-beginning 0))
			  (substring key (match-end 0)))))
      ;; ѿ ascii Ѵ롣
      (while (string-match "[-]" key)
        (let ((zen-num (match-string 0 key)))
          (setq key (concat (substring key 0 (match-beginning 0))
                            (skk-jisx0208-to-ascii zen-num)
                            (substring key (match-end 0))))))
      ;; ascii  "#" ֤ο skk-num-list ¸
      (while (string-match numexp key)
        (setq skk-num-list (nconc skk-num-list (list (match-string 0 key)))
              key (concat (substring key 0 (match-beginning 0))
                          "#"
                          (substring key (match-end 0)))))))
  key)

(defun skk-num-convert (key)
  ;; skk-henkan-list  skk-henkan-count ؤƤѴ
  ;; Ѵskk-henkan-list 
  ;;   ("#2" ...) -> (("#2" ."") ...)
  ;; Τ褦ѷ롣
  (if (not key)
      nil
    (let ((numexp (if skk-num-convert-float
                      "#[.0-9]+" "#[0-9]+"))
          (n 0)
          (workkey key)
          num convnum string convlist current)
      (save-match-data
        (while (and (setq num (nth n skk-num-list))
                    (string-match numexp workkey))
          (setq convnum (save-match-data
			  (skk-num-exp num (string-to-number
					    (substring workkey
						       (1+ (match-beginning 0))
						       (match-end 0)))))
                string (substring workkey 0 (match-beginning 0))
                workkey (substring workkey (match-end 0))
                n (1+ n))
          (if (not (and (stringp convnum) (string= convnum "")
                        (string= string "")))
              (setq convlist (nconc convlist (list string convnum)))))
        (setq convlist (nconc convlist (list workkey)))
        (cond ((null convlist) nil)
              ((and (null (cdr convlist)) (stringp (car convlist)))
               (setq current (car convlist)))
              ;; CONV-LIST Ǥʸ
              ((null (memq t (mapcar 'listp convlist)))
               (setq current (mapconcat 'identity convlist ""))
               (if (and (> skk-henkan-count -1)
                        (nth skk-henkan-count skk-henkan-list))
                   ;; ("A" "#2" "C") -> ("A" ("#2" ."") "C")
		   (setcar (nthcdr skk-henkan-count skk-henkan-list) (cons key current))
;                   (setf (nth skk-henkan-count skk-henkan-list)
;                         (cons key current))
                 (setq skk-henkan-list
                       (nconc skk-henkan-list (list (cons key current))))))
              ;; #4
              (t (let ((l (mapcar (function (lambda (e) (cons key e)))
                                  (skk-num-flatten-list (delete "" convlist)))))
                   (setq current (cdr (car l)))
                   (if (and (> skk-henkan-count -1)
                            (nth skk-henkan-count skk-henkan-list))
                       (progn
			 (setcar (nthcdr skk-henkan-count skk-henkan-list) (car l))
;                         (setf (nth skk-henkan-count skk-henkan-list) (car l))
                         (setq skk-henkan-list (skk-splice-in
                                                skk-henkan-list
                                                (1+ skk-henkan-count)
                                                (cdr l))))
                     (setq skk-henkan-list (nconc skk-henkan-list l))))))
        current))))

(defun skk-num-convert*7 ()
  (let ((skk-henkan-count skk-henkan-count)
        (n 7))
    (while (and (> n 0) (nth skk-henkan-count skk-henkan-list))
      (skk-num-convert (skk-get-current-candidate))
      (setq skk-henkan-count (1+ skk-henkan-count)
            n (1- n)))
    (and skk-num-recompute-key (skk-num-uniq))))

(defun skk-num-rawnum-exp (string)
  (setq string (skk-num-rawnum-exp-1
                string "[-][޻ͼȬϻ]" "#9" 0))
  (setq string (skk-num-rawnum-exp-1
                string "\\(^\\|[^#0-9]\\)\\([0-9]+\\)" "#0" 2))
  (setq string (skk-num-rawnum-exp-1
                string "[-]+" "#1" 0))
  (setq string (skk-num-rawnum-exp-1
                string "\\([޻ͼȬϻ][ɴ]\\)+" "#3" 0))
  ;; (mapcar 'char-to-string
  ;;         (sort
  ;;          '(? ? ? ? ? ?ϻ ? ?Ȭ ? ?) '<))
  ;;   --> ("" "" "" "" "" "" "" "" "Ȭ" "ϻ")
  ;;
  ;; [-] ȤɽȤʤΤǡΤޤޤĤäǤ
  (skk-num-rawnum-exp-1 string "[޻ͼȬϻ]+" "#2" 0))

(defun skk-num-rawnum-exp-1 (string key type place)
  (save-match-data
    (while (string-match key string)
      (setq string (concat (substring string 0 (match-beginning place))
			   type
			   (substring string (match-end place)))))
    string))

(defun skk-num-flatten-list (list)
  ;; Ϳ줿ꥹȤγǤȤ߹礻ǽʸϢܤꡢꥹȤ
  ;; 
  ;; (("A" "B") "1" ("X" "Y")) -> ("A1X" "A1Y" "B1X" "B1Y")
  (let ((dst (car list))
 	(src (cdr list))
 	elt)
    (while src
      (setq elt (car src))
      (if (consp elt)
 	  (setq dst (apply (function nconc)
 			   (mapcar
 			    (lambda (str0)
 			      (mapcar
 			       (lambda (str1)
 				 (concat str0 str1))
 			       elt))
 			    dst)))
 	(setq dst (mapcar
 		   (lambda (str0)
 		     (concat str0 elt))
 		   dst)))
      (setq src (cdr src)))
    dst))

(defun skk-num-exp (num type)
  ;; ascii  NUM  TYPE ˽ѴѴʸ֤
  ;; TYPE ϲ̤ꡣ
  ;; 0 -> ̵Ѵ
  ;; 1 -> ѿѴ
  ;; 2 -> Ѵ (̼ʤ)
  ;; 3 -> Ѵ (̼򤹤)
  ;; 4 -> οΤΤ򥭡ˤƼƸ
  ;; 5 ->  (ʤɤǻѤʸ) Ѵ (̼򤹤)
  ;; 9 -> ǻѤ ("" ʤ) Ѵ
  (let ((fun (cdr (assq type skk-num-type-alist))))
    (if fun (funcall fun num))))

(defun skk-num-jisx0208-latin (num)
  ;; ascii  NUM ѿʸѴѴʸ֤
  ;; 㤨 "45"  "" Ѵ롣
  (let ((candidate
         (mapconcat (function (lambda (c) (cdr (assq c skk-num-alist-type1))))
                    num "")))
    (if (not (string= candidate ""))
        candidate)))

(defun skk-num-type2-kanji (num)
  ;; ascii  NUM ʸѴѴʸ֤
  ;; 㤨С"45"  "͸" Ѵ롣
  (save-match-data
    (if (not (string-match "\\.[0-9]" num))
        (let ((candidate
               (mapconcat (function (lambda (c)
                                      (cdr (assq c skk-num-alist-type2))))
                          num "")))
          (if (not (string= candidate ""))
              candidate)))))

(defun skk-num-type3-kanji (num)
  ;; ascii  NUM ʸѴ (̼򤹤)Ѵʸ
  ;; ֤㤨 "1021"  "󽽰" Ѵ롣
  (save-match-data
    (if (not (string-match "\\.[0-9]" num))
	;; ޤޤʤ
        (let ((str (skk-num-type3-kanji-1 num)))
          (if (string= "" str) "" str)))))

(defun skk-num-type3-kanji-1 (num)
  ;; skk-num-type3-kanji Υ֥롼
  (let ((len (length num))
	(i 0)
        char v num1 v1)
    ;; פޤǤϽϤ롣
    (when (> len 20) (skk-error "̤礭ޤ" "Too big number!"))
    (setq num (append num nil))
    (cond
     ((<= len 4)
      (while (setq char (car num))
	;; :       ɴ  
	;; len:   1   2   3   4
	(if (= len 1)
	    ;; ̤ɽ魯ʳδ
	    (unless (eq char ?0)
	    ;; ΰ̤ 0 Ǥʤ
	      (setq v (concat v (cdr (assq char skk-num-alist-type2)))))
	  ;; ̤ɽ魯ʳδ
	  (unless (memq char '(?0 ?1))
	    ;; ΰ̰ʾǡ 0, 1 ʳο
	    (setq v (concat v (cdr (assq char skk-num-alist-type2)))))
	  ;; ̤ɽ魯
	  (when (and (not (eq char ?0)) (memq len '(2 3 4)))
	    (setq v
		  (concat
		   v
		   (cdr (assq len '((2 . "") (3 . "ɴ") (4 . ""))))))))
	(setq len (1- len) num (cdr num))))
     (t
      (setq num (nreverse num))
      (while num
	(setq num1 nil)
	(while (and (< (length num1) 4) num)
	  (setq num1 (cons (car num) num1)
		num (cdr num)))
	(when num1
	  (setq v1 (skk-num-type3-kanji-1 num1))
	  (when (and (eq i 1) (equal v1 ""))
	    ;; ܸǤϡ鲯פȤɽϤȤ˻Ȥ뤬פȤɽ
	    ;; ϤޤȤʤΤǡְפľ
	    (setq v1 (concat "" v1)))
	  (setq
	   v
	   (concat
	    v1
	    (when v1
	      (cdr
	       (assq
		i '((0 . "") (1 . "") (2 . "") (3 . "") (4 . "")))))
	    v)))
	(setq i (1+ i)))))
    v))

(defun skk-num-type5-kanji (num)
  ;; ascii  NUM ʸѴ (̼򤹤)Ѵʸ
  ;; ֤㤨 "1021"  "" Ѵ롣
  (save-match-data
    (if (not (string-match "\\.[0-9]" num))
	;; ޤޤʤ
        (let ((str (skk-num-type5-kanji-1 num)))
          (if (string= "" str) "" str)))))

(defun skk-num-type5-kanji-1 (num)
  ;; skk-num-type5-kanji Υ֥롼
  (let ((len (length num))
	(i 0)
         char v num1 v1)
    ;; פޤǤϽϤ롣
    (when (> len 20) (skk-error "̤礭ޤ" "Too big number!"))
    (setq num (append num nil))
    (cond
     ((<= len 4)
      (while (setq char (car num))
	(if (= len 1)
	    (unless (eq char ?0)
	      (setq v (concat v (cdr (assq char skk-num-alist-type5)))))
	  ;; ̤ɽ魯ʳδ
	  (setq v (concat v (cdr (assq char skk-num-alist-type5))))
	  ;; ̤ɽ魯
	  (when (and (not (eq char ?0)) (memq len '(2 3 4)))
	    (setq v
		  (concat
		   v
		   (cdr (assq len '((2 . "") (3 . "ɴ") (4 . ""))))))))
	(setq len (1- len) num (cdr num))))
     (t
      (setq num (nreverse num))
      (while num
	(setq num1 nil)
	(while (and (< (length num1) 4) num)
	  (setq num1 (cons (car num) num1)
		num (cdr num)))
	(when num1
	  (setq v1 (skk-num-type5-kanji-1 num1))
	  (setq
	   v
	   (concat
	    v1
	    (when v1
	      (cdr
	       (assq
		i '((0 . "") (1 . "") (2 . "") (3 . "") (4 . "")))))
	    v)))
	(setq i (1+ i)))))
    v))

(defun skk-num-shogi (num)
  ;; ascii  NUM 򾭴ǻѤɽѴ롣
  ;; 㤨 "34"  "" Ѵ롣
  (save-match-data
    (if (and (= (length num) 2)
             (not (string-match "\\.[0-9]" num)))
        (let ((candidate
               (concat (cdr (assq (aref num 0) skk-num-alist-type1))
                       (cdr (assq (aref num 1) skk-num-alist-type2)))))
          (if (not (string= candidate ""))
              candidate)))))

(defun skk-num-recompute (num)
  ;; #4 θФФskk-henkan-key 줿ΤΤٸ롣
  (let (result)
    (setq skk-num-recompute-key num)
    (with-temp-buffer
      ;; ȥХåեΥХåեѿ˱ƶڤܤʤ褦
      ;; 󥰥Хåեذöƨ
      (let ((skk-current-search-prog-list skk-search-prog-list)
            (skk-henkan-key num)
	    ;; ȤѴʤ (skk-henkan-okurigana  skk-okuri-char 
	    ;;  nil) ̥Хåե (work Хåե) äƤΤǡǰ
	    ;; Τᡢnil Ƥ
            skk-henkan-okurigana skk-okuri-char skk-use-numeric-conversion)
        (while skk-current-search-prog-list
          (setq result (skk-nunion result (skk-search))))))
    ;;  temp-buffer ФѴԤʤäƤ륫ȥХåե
    ;; (ХåեͤǤ skk-henkan-list )
    (if result
        (if (null (cdr result));;(= (length result) 1)
            (car result)
          result)
      ;; ѴǤʤä鸵ο򤽤Τޤ֤Ƥ
      num)))

;;;###autoload
(defun skk-num-uniq ()
  (if (or (not skk-num-uniq) (null skk-henkan-list))
      nil
    (save-match-data
      (let ((n1 -1) n2 e1 e2 e3
            ;; 1 ĤǤ 2 ʾοС#2  #3 Ǥ uniq ʤ
            (type2and3 (> 2 (apply 'max (mapcar 'length skk-num-list))))
            type2 type3 index2 index3 head2 head3 tail2 tail3
            case-fold-search)
        (while (setq n1 (1+ n1) e1 (nth n1 skk-henkan-list))
          ;; cons cell Ǥʤ skk-nunion ǽѤߤʤΤǡʣϤʤ
          (if (consp e1)
              ;; (car e1)  equal ΤΤäΤ e1 Ȥä뤳
              ;; ȤϤʤ
              (setq skk-henkan-list (delete (car e1) skk-henkan-list)
                    skk-henkan-list (delete (cdr e1) skk-henkan-list)))
          (if (not (and skk-num-recompute-key (consp e1)))
              nil
            ;; ("#4" . "xxx") ޤ䤬 skk-henkan-list ˤ롣
            (setq n2 -1)
            (while (setq n2 (1+ n2) e2 (nth n2 skk-henkan-list))
              (if (and (not (= n1 n2)) (consp e2)
                       ;; 㤨 ("#4" . "")  ("#2" . "") ¸Ƥ
                       ;; 硣
                       (string= (cdr e1) (cdr e2)))
                  (setq skk-henkan-list (delq e2 skk-henkan-list)))))
          (if (not type2and3)
              nil
            ;; 1 οѴݤˡskk-henkan-list  #2 ȥ #3
            ;; ȥ꤬С#2 ⤷ #3 ȥΤˤ
            ;; Τä
            (setq e3 (if (consp e1) (car e1) e1))
            ;; e3  "#2" Τ褦˿Ѵ򼨤ʸΤߤȤϸ¤ʤΤǡ
            ;; member ϻȤʤ
            (cond ((string-match "#2" e3)
                   (setq type2 e1
                         index2 n1
                         head2 (substring e3 0 (match-beginning 0))
                         tail2 (substring e3 (match-end 0))))
                  ((string-match "#3" e3)
                   (setq type3 e1
                         index3 n1
                         head3 (substring e3 0 (match-beginning 0))
                         tail3 (substring e3 (match-end 0)))))))
        (if (and type2and3 type2 type3
                 ;; Ѵ򼨤ʸ "#[23]" ʸƱΤ
                 ;; Τ uniq Ԥʤ
                 (string= head2 head3) (string= tail2 tail3))
            (if (> index2 index3)
                ;; "#3" ˤ롣
                (setq skk-henkan-list (delq type2 skk-henkan-list))
              ;; ѿ type[23] ͤϡskk-henkan-list ľФ
              ;; Τ delete Ǥʤdelq ǽʬ
              (setq skk-henkan-list (delq type3 skk-henkan-list))))))))

;;;###autoload
(defun skk-num-process-user-minibuf-input (key)
  (save-match-data
    (let (numexp orglen val)
      (if (or (and (string-match "#[012349]" key)
		   (setq numexp key))
	      (and (setq numexp (skk-num-rawnum-exp key))
		   (not (string= key numexp))))
	  (progn
	    (setq orglen (length skk-henkan-list)
		  ;; skk-henkan-list Ĵϡskk-num-convert ǹԤʤ
		  ;; Ƥ롣
		  val (skk-num-convert numexp))
	    (if (= (length skk-henkan-list) (1+ orglen))
		;; #4 ʣθѴǤϳꤷʤ
		(setq skk-kakutei-flag t)))
	(setq skk-henkan-list (nconc skk-henkan-list (list key))
	      skk-kakutei-flag t
	      val key))
      val)))

;;;###autoload
(defun skk-num-initialize ()
  ;; skk-use-numeric-convert Ϣѿ롣
  (setq skk-last-henkan-data
	(put-alist 'num-list skk-num-list skk-last-henkan-data)
	skk-num-list nil
        skk-num-recompute-key nil))

;;;###autoload
(defun skk-num-henkan-key ()
  ;; type4 οͺѴԤʤ줿ȤϡͼȤ֤ʳοѴ
  ;; Ǥϡskk-henkan-key ֤
  (or skk-num-recompute-key skk-henkan-key))

;;;###autoload
(defun skk-num-update-jisyo (noconvword word &optional purge)
  ;; Ȥ򸫽ФȤƼΥåץǡȤԤʤ
  (if (and skk-num-recompute-key
           (save-match-data (string-match "#4" noconvword)))
      (with-current-buffer (skk-get-jisyo-buffer skk-jisyo 'nomsg)
	(let ((skk-henkan-key skk-num-recompute-key)
	      skk-use-numeric-conversion)
	  (skk-update-jisyo word purge)))))

;;;###autoload
(defun skk-num (str)
  ;;  skk-number-style ͤ˽Ѵ롣
  ;; skk-current-date Υ֥롼
  (mapconcat (function
	      (lambda (c)
		(cond ((or (not skk-number-style)
			   (and (numberp skk-number-style)
				(= skk-number-style 0)))
		       (char-to-string c))
		      ((or (eq skk-number-style t)
			   (and (numberp skk-number-style)
				(= skk-number-style 1)))
		       (cdr (assq c skk-num-alist-type1)))
		      (t (cdr (assq c skk-num-alist-type2))))))
	     str ""))

(run-hooks 'skk-num-load-hook)

(provide 'skk-num)
;;; Local Variables:
;;; End:
;;; skk-num.el ends here
