/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.linux;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorUtils;
import java.io.File;

public final class LinuxConnector
extends Connector {
    private static final String LIBFILENAME = "libJSA.so";
    private static LinuxConnector _instance = null;

    private LinuxConnector() {
        try {
            System.loadLibrary("JSA");
        }
        catch (Throwable throwable) {
            try {
                if (!ConnectorUtils.checkLibraryInPath(LIBFILENAME)) {
                    ConnectorUtils.extractFromJarToTemp(LIBFILENAME);
                    System.load(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separatorChar + LIBFILENAME);
                }
            }
            catch (Exception exception) {
                this.setStatus(Connector.Status.NOT_AVAILABLE);
                return;
            }
        }
        this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
    }

    public static synchronized LinuxConnector getInstance() {
        if (_instance == null) {
            _instance = new LinuxConnector();
        }
        return _instance;
    }

    public void init() {
        this.init(this.getApplicationName());
    }

    protected void sendCommand(String command) {
        this.sendSkypeMessage(command);
    }

    protected void disposeImpl() {
        LinuxConnector.setConnectedStatus(5);
        this.disposeNative();
        _instance = null;
    }

    protected void sendApplicationName(String newApplicationName) throws ConnectorException {
        this.execute("NAME " + newApplicationName, new String[]{"OK"}, false);
    }

    protected Connector.Status connect(int timeout) {
        if (this.getStatus() == Connector.Status.PENDING_AUTHORIZATION) {
            return Connector.Status.ATTACHED;
        }
        return this.getStatus();
    }

    protected void initialize(int timeout) {
        this.init();
    }

    private native void init(String var1);

    public native void sendSkypeMessage(String var1);

    public native void disposeNative();

    public static void receiveSkypeMessage(String message) {
        if (_instance.getStatus() != Connector.Status.ATTACHED) {
            LinuxConnector.setConnectedStatus(1);
        }
        _instance.fireMessageReceived(message);
    }

    public static void setConnectedStatus(int status) {
        switch (status) {
            case 0: {
                _instance.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                break;
            }
            case 1: {
                _instance.setStatus(Connector.Status.ATTACHED);
                break;
            }
            case 2: {
                _instance.setStatus(Connector.Status.REFUSED);
                break;
            }
            case 3: {
                _instance.setStatus(Connector.Status.NOT_AVAILABLE);
                break;
            }
            case 4: {
                _instance.setStatus(Connector.Status.API_AVAILABLE);
                break;
            }
            case 5: {
                _instance.setStatus(Connector.Status.NOT_RUNNING);
                break;
            }
            default: {
                _instance.setStatus(Connector.Status.NOT_RUNNING);
            }
        }
    }

    public static synchronized /* bridge */ /* synthetic */ Connector getInstance() {
        return LinuxConnector.getInstance();
    }
}

