/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    void clearArea(int x, int y, int width, int height) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        int hDC = OS.GetDCEx(this.handle, 0, 26);
        this.drawBackground(hDC, rect);
        OS.ReleaseDC(this.handle, hDC);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        this.checkWidget();
        this.forceResize();
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        RECT sourceRect = new RECT();
        OS.SetRect(sourceRect, x, y, x + width, y + height);
        RECT clientRect = new RECT();
        OS.GetClientRect(this.handle, clientRect);
        if (OS.IntersectRect(clientRect, sourceRect, clientRect)) {
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.handle);
            } else {
                int flags = 384;
                OS.RedrawWindow(this.handle, null, 0, flags);
            }
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        int flags = 6;
        OS.ScrollWindowEx(this.handle, deltaX, deltaY, sourceRect, null, 0, null, flags);
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.isFocusControl()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    LRESULT WM_INPUTLANGCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_INPUTLANGCHANGE(wParam, lParam);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.setIMEFont();
            this.caret.resizeIME();
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.caret != null && this.caret.isFocusCaret()) {
            this.caret.resizeIME();
        }
        return result;
    }

    LRESULT WM_WINDOWPOSCHANGED(int wParam, int lParam) {
        boolean isFocus;
        LRESULT result = super.WM_WINDOWPOSCHANGED(wParam, lParam);
        if (result != null) {
            return result;
        }
        boolean bl = isFocus = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    LRESULT WM_WINDOWPOSCHANGING(int wParam, int lParam) {
        boolean isFocus;
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        boolean bl = isFocus = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        return result;
    }
}

