/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ApplicationListener;
import com.skype.Friend;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.Stream;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Application
extends SkypeObject {
    private static final Map<String, Application> applications = new HashMap<String, Application>();
    private final String name;
    private final Object connectMutex = new Object();
    private final List<ApplicationListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, Stream> streams = new HashMap<String, Stream>();
    private final ConnectorListener dataListener = new DataListener();
    private boolean isFinished;
    private final Object isFinishedFieldMutex = new Object();
    private Thread shutdownHookForFinish;
    private SkypeExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Application getInstance(String id) throws SkypeException {
        Map<String, Application> map = applications;
        synchronized (map) {
            if (!applications.containsKey(id)) {
                applications.put(id, new Application(id));
            }
            return applications.get(id);
        }
    }

    private Application(String newName) throws SkypeException {
        assert (newName != null);
        this.name = newName;
        this.initialize();
    }

    void initialize() throws SkypeException {
        try {
            String response = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
            Utils.checkError(response);
            Connector.getInstance().addConnectorListener(this.dataListener);
            this.shutdownHookForFinish = new Thread(){

                public void run() {
                    try {
                        Connector.getInstance().execute("DELETE APPLICATION " + Application.this.getName());
                    }
                    catch (ConnectorException connectorException) {
                        // empty catch block
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHookForFinish);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SkypeException {
        Object object = this.isFinishedFieldMutex;
        synchronized (object) {
            if (!this.isFinished) {
                Connector.getInstance().removeConnectorListener(this.dataListener);
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookForFinish);
                this.isFinished = true;
                try {
                    String response = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
                    Utils.checkError(response);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Stream[] connectToAll() throws SkypeException {
        return this.connect(this.getAllConnectableFriends());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream[] connect(Friend ... friends) throws SkypeException {
        Utils.checkNotNull("friends", friends);
        Object object = this.connectMutex;
        synchronized (object) {
            int n;
            int n2;
            Stream[] streamArray;
            try {
                final Object wait = new Object();
                AbstractConnectorListener connectorListener = new AbstractConnectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.equals("APPLICATION " + Application.this.getName() + " CONNECTING ")) {
                            Object object = wait;
                            synchronized (object) {
                                wait.notify();
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(connectorListener);
                    Object object2 = wait;
                    synchronized (object2) {
                        Friend[] friendArray = friends;
                        int n3 = 0;
                        int n4 = friendArray.length;
                        while (true) {
                            if (n3 >= n4) {
                                try {
                                    wait.wait();
                                    break;
                                }
                                catch (InterruptedException e) {
                                    throw new SkypeException("The connecting was interrupted.", e);
                                }
                            }
                            Friend friend = friendArray[n3];
                            if (friend != null) {
                                String result = Connector.getInstance().execute("ALTER APPLICATION " + this.getName() + " CONNECT " + friend.getId());
                                Utils.checkError(result);
                            }
                            ++n3;
                        }
                    }
                    Stream[] streamArray2 = this.getAllStreams(friends);
                    return streamArray2;
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                    return null;
                }
                finally {
                    Connector.getInstance().removeConnectorListener(connectorListener);
                }
            }
            catch (SkypeException e) {
                streamArray = this.getAllStreams(friends);
                n2 = 0;
                n = streamArray.length;
            }
            while (true) {
                if (n2 >= n) {
                    throw e;
                }
                Stream stream = streamArray[n2];
                try {
                    stream.disconnect();
                }
                catch (SkypeException skypeException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public Stream[] getAllStreams(Friend ... friends) throws SkypeException {
        ArrayList<Stream> results = new ArrayList<Stream>();
        Stream[] streamArray = this.getAllStreams();
        int n = 0;
        int n2 = streamArray.length;
        while (n < n2) {
            Stream stream = streamArray[n];
            Friend friend = stream.getFriend();
            Friend[] friendArray = friends;
            int n3 = 0;
            int n4 = friendArray.length;
            while (n3 < n4) {
                Friend comparedFriend = friendArray[n3];
                if (friend.equals(comparedFriend)) {
                    results.add(stream);
                }
                ++n3;
            }
            ++n;
        }
        return results.toArray(new Stream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream[] getAllStreams() throws SkypeException {
        String streamIds = Utils.getPropertyWithCommandId("APPLICATION", this.getName(), "STREAMS");
        Map<String, Stream> map = this.streams;
        synchronized (map) {
            this.fireStreamEvents(streamIds);
            if ("".equals(streamIds)) {
                return new Stream[0];
            }
            String[] ids = streamIds.split(" ");
            Stream[] results = new Stream[ids.length];
            int i = 0;
            while (i < ids.length) {
                results[i] = this.streams.get(ids[i]);
                ++i;
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamEvents(String newStreamIdList) {
        Map<String, Stream> map = this.streams;
        synchronized (map) {
            String[] oldStreamIds;
            String[] newStreamIds;
            String[] stringArray = newStreamIds = "".equals(newStreamIdList) ? new String[]{} : newStreamIdList.split(" ");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String streamId = stringArray[n];
                if (!this.streams.containsKey(streamId)) {
                    Stream stream = new Stream(this, streamId);
                    this.streams.put(streamId, stream);
                    this.fireConnected(stream);
                }
                ++n;
            }
            String[] stringArray2 = oldStreamIds = this.streams.keySet().toArray(new String[0]);
            n2 = 0;
            int n3 = stringArray2.length;
            while (n2 < n3) {
                block8: {
                    String oldStreamId = stringArray2[n2];
                    String[] stringArray3 = newStreamIds;
                    int n4 = 0;
                    int n5 = stringArray3.length;
                    while (n4 < n5) {
                        String newStreamId = stringArray3[n4];
                        if (!oldStreamId.equals(newStreamId)) {
                            ++n4;
                            continue;
                        }
                        break block8;
                    }
                    Stream stream = this.streams.remove(oldStreamId);
                    this.fireDisconnected(stream);
                }
                ++n2;
            }
        }
    }

    private void fireConnected(Stream stream) {
        ApplicationListener[] myListeners;
        assert (stream != null);
        ApplicationListener[] applicationListenerArray = myListeners = this.listeners.toArray(new ApplicationListener[0]);
        int n = 0;
        int n2 = applicationListenerArray.length;
        while (n < n2) {
            ApplicationListener listener = applicationListenerArray[n];
            try {
                listener.connected(stream);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++n;
        }
    }

    private void fireDisconnected(Stream stream) {
        ApplicationListener[] myListeners;
        assert (stream != null);
        ApplicationListener[] applicationListenerArray = myListeners = this.listeners.toArray(new ApplicationListener[0]);
        int n = 0;
        int n2 = applicationListenerArray.length;
        while (n < n2) {
            ApplicationListener listener = applicationListenerArray[n];
            try {
                listener.disconnected(stream);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++n;
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    public Friend[] getAllConnectableFriends() throws SkypeException {
        return this.getAllFriends("CONNECTABLE");
    }

    public Friend[] getAllConnectingFriends() throws SkypeException {
        return this.getAllFriends("CONNECTING");
    }

    public Friend[] getAllConnectedFriends() throws SkypeException {
        return this.getAllFriends("STREAMS");
    }

    public Friend[] getAllSendingFriends() throws SkypeException {
        return this.getAllFriends("SENDING");
    }

    public Friend[] getAllReceivedFriends() throws SkypeException {
        return this.getAllFriends("RECEIVED");
    }

    private Friend[] getAllFriends(String type) throws SkypeException {
        try {
            String command = "GET APPLICATION " + this.getName() + " " + type;
            String responseHeader = "APPLICATION " + this.getName() + " " + type + " ";
            String response = Connector.getInstance().executeWithId(command, responseHeader);
            Utils.checkError(response);
            return this.extractFriends(response.substring(responseHeader.length()));
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    private Friend[] extractFriends(String list) throws SkypeException {
        assert (list != null);
        if ("".equals(list)) {
            return new Friend[0];
        }
        String[] ids = list.split(" ");
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            if (id.contains(":")) {
                ids[i] = id.substring(0, id.indexOf(58));
            }
            ++i;
        }
        Friend[] allFriends = Skype.getContactList().getAllFriends();
        ArrayList<Friend> friends = new ArrayList<Friend>();
        String[] stringArray = ids;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String id = stringArray[n];
            Friend[] friendArray = allFriends;
            int n3 = 0;
            int n4 = friendArray.length;
            while (n3 < n4) {
                Friend friend = friendArray[n3];
                if (friend.getId().equals(id)) {
                    friends.add(friend);
                }
                ++n3;
            }
            ++n;
        }
        return friends.toArray(new Friend[0]);
    }

    private class DataListener
    extends AbstractConnectorListener {
        private DataListener() {
        }

        public void messageReceived(ConnectorMessageEvent event) {
            String dataHeader;
            String streamsHeader;
            String message = event.getMessage();
            if (message.startsWith(streamsHeader = "APPLICATION " + Application.this.getName() + " STREAMS ")) {
                String streamIds = message.substring(streamsHeader.length());
                Application.this.fireStreamEvents(streamIds);
            }
            if (message.startsWith(dataHeader = "APPLICATION " + Application.this.getName() + " ")) {
                this.handleData(message.substring(dataHeader.length()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleData(String dataResponse) {
            block11: {
                try {
                    if (this.isReceivedText(dataResponse)) {
                        String data = dataResponse.substring("RECEIVED ".length());
                        String streamId = data.substring(0, data.indexOf(61));
                        String dataHeader = "ALTER APPLICATION " + Application.this.getName() + " READ " + streamId;
                        String response = Connector.getInstance().executeWithId(dataHeader, dataHeader);
                        Utils.checkError(response);
                        String text = response.substring(dataHeader.length() + 1);
                        Map map = Application.this.streams;
                        synchronized (map) {
                            if (Application.this.streams.containsKey(streamId)) {
                                ((Stream)Application.this.streams.get(streamId)).fireTextReceived(text);
                            }
                            break block11;
                        }
                    }
                    if (!this.isReceivedDatagram(dataResponse)) break block11;
                    String data = dataResponse.substring("DATAGRAM ".length());
                    String streamId = data.substring(0, data.indexOf(32));
                    String datagram = data.substring(data.indexOf(32) + 1);
                    Map map = Application.this.streams;
                    synchronized (map) {
                        if (Application.this.streams.containsKey(streamId)) {
                            ((Stream)Application.this.streams.get(streamId)).fireDatagramReceived(datagram);
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("can't handle data", e);
                }
            }
        }

        private boolean isReceivedText(String dataResponse) {
            return dataResponse.startsWith("RECEIVED ") && "RECEIVED ".length() < dataResponse.length();
        }

        private boolean isReceivedDatagram(String dataResponse) {
            return dataResponse.startsWith("DATAGRAM ");
        }
    }
}

