/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.CallStatusChangedListener;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Call
extends SkypeObject {
    private static final Map<String, Call> calls = new HashMap<String, Call>();
    private final String id;
    private final List<CallStatusChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private Status oldStatus;
    private SkypeExceptionHandler exceptionHandler;
    private boolean isCallListenerEventFired;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Call getInstance(String id) {
        Map<String, Call> map = calls;
        synchronized (map) {
            if (!calls.containsKey(id)) {
                calls.put(id, new Call(id));
            }
            return calls.get(id);
        }
    }

    private Call(String newId) {
        this.id = newId;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof Call) {
            return this.id.equals(((Call)compared).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void addCallStatusChangedListener(CallStatusChangedListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeCallStatusChangedListener(CallStatusChangedListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    void fireStatusChanged(Status status) {
        CallStatusChangedListener[] cscListeners = this.listeners.toArray(new CallStatusChangedListener[0]);
        if (status == this.oldStatus) {
            return;
        }
        this.oldStatus = status;
        CallStatusChangedListener[] callStatusChangedListenerArray = cscListeners;
        int n = 0;
        int n2 = callStatusChangedListenerArray.length;
        while (n < n2) {
            CallStatusChangedListener listener = callStatusChangedListenerArray[n];
            try {
                listener.statusChanged(status);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
            ++n;
        }
    }

    public void hold() throws SkypeException {
        this.setStatus("ONHOLD");
    }

    public void resume() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void finish() throws SkypeException {
        this.setStatus("FINISHED");
    }

    public void answer() throws SkypeException {
        this.setStatus("INPROGRESS");
    }

    public void cancel() throws SkypeException {
        this.setStatus("FINISHED");
    }

    private void setStatus(String status) throws SkypeException {
        try {
            String response = Connector.getInstance().executeWithId("SET CALL " + this.getId() + " STATUS " + status, "CALL " + this.getId() + " STATUS ");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public void forward() throws SkypeException {
        try {
            Connector.getInstance().setDebug(true);
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " END FORWARD_CALL");
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public Date getStartTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public User getPartner() throws SkypeException {
        return User.getInstance(this.getPartnerId());
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(this.getProperty("TYPE"));
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("CALL", this.getId(), "STATUS"));
    }

    public int getDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("DURATION"));
    }

    public int getErrorCode() throws SkypeException {
        return Integer.parseInt(this.getProperty("FAILUREREASON"));
    }

    public void setReceiveVideoEnabled(boolean videoStatus) throws SkypeException {
        String value = videoStatus ? "START_VIDEO_SEND" : "STOP_VIDEO_SEND";
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + value);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean isReceiveVideoEnabled() throws SkypeException {
        VideoEnabledStatus enabled = VideoEnabledStatus.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (enabled) {
            case VIDEO_NONE: 
            case VIDEO_SEND_ENABLED: {
                return false;
            }
            case VIDEO_RECV_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public void setSendVideoEnabled(boolean videoStatus) throws SkypeException {
        String value = videoStatus ? "START_VIDEO_RECEIVE" : "STOP_VIDEO_RECEIVE";
        try {
            String response = Connector.getInstance().execute("ALTER CALL " + this.getId() + " " + value);
            Utils.checkError(response);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public boolean isSendVideoEnabled() throws SkypeException {
        VideoEnabledStatus enabled = VideoEnabledStatus.valueOf(this.getProperty("VIDEO_STATUS"));
        switch (enabled) {
            case VIDEO_NONE: 
            case VIDEO_RECV_ENABLED: {
                return false;
            }
            case VIDEO_SEND_ENABLED: 
            case VIDEO_BOTH_ENABLED: {
                return true;
            }
        }
        return false;
    }

    public VideoStatus getReceiveVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_RECEIVE_STATUS"));
    }

    public VideoStatus getSendVideoStatus() throws SkypeException {
        return VideoStatus.valueOf(this.getProperty("VIDEO_SEND_STATUS"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("CALL", this.getId(), name);
    }

    boolean isCallListenerEventFired() {
        return this.isCallListenerEventFired;
    }

    void setCallListenerEventFired(boolean fired) {
        this.isCallListenerEventFired = fired;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNPLACED,
        ROUTING,
        EARLYMEDIA,
        FAILED,
        RINGING,
        INPROGRESS,
        ONHOLD,
        FINISHED,
        MISSED,
        REFUSED,
        BUSY,
        CANCELLED,
        VM_BUFFERING_GREETING,
        VM_PLAYING_GREETING,
        VM_RECORDING,
        VM_UPLOADING,
        VM_SENT,
        VM_CANCELLED,
        VM_FAILED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCOMING_PSTN,
        OUTGOING_PSTN,
        INCOMING_P2P,
        OUTGOING_P2P;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VideoStatus {
        NOT_AVAILABLE,
        AVAILABLE,
        STARTING,
        REJECTED,
        RUNNING,
        STOPPING,
        PAUSED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VideoEnabledStatus {
        VIDEO_NONE,
        VIDEO_SEND_ENABLED,
        VIDEO_RECV_ENABLED,
        VIDEO_BOTH_ENABLED;

    }
}

