/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Friend;
import com.skype.Group;
import com.skype.SkypeException;
import com.skype.User;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;

public final class ContactList {
    ContactList() {
    }

    public Friend[] getAllFriends() throws SkypeException {
        try {
            String responseHeader = "USERS ";
            String response = Connector.getInstance().execute("SEARCH FRIENDS", responseHeader);
            Utils.checkError(response);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            Friend[] friends = new Friend[ids.length];
            int i = 0;
            while (i < ids.length) {
                friends[i] = User.getFriendInstance(ids[i]);
                ++i;
            }
            return friends;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public Friend getFriend(String skypeId) throws SkypeException {
        Utils.checkNotNull(skypeId, "skypeId");
        Friend[] friendArray = this.getAllFriends();
        int n = 0;
        int n2 = friendArray.length;
        while (n < n2) {
            Friend friend = friendArray[n];
            if (skypeId.equals(friend.getId())) {
                return friend;
            }
            ++n;
        }
        return null;
    }

    public Group[] getAllSystemGroups() throws SkypeException {
        return this.getAllGroups("HARDWIRED");
    }

    public Group getSystemGroup(Group.Type type) throws SkypeException {
        if (type == Group.Type.CUSTOM_GROUP) {
            throw new IllegalArgumentException("custom type is not supported (use getAllGroups method to resolve)");
        }
        Group[] groupArray = this.getAllSystemGroups();
        int n = 0;
        int n2 = groupArray.length;
        while (n < n2) {
            Group group = groupArray[n];
            if (group.getType() == type) {
                return group;
            }
            ++n;
        }
        return null;
    }

    public Group[] getAllGroups() throws SkypeException {
        return this.getAllGroups("CUSTOM");
    }

    private Group[] getAllGroups(String type) throws SkypeException {
        try {
            String responseHeader = "GROUPS ";
            String response = Connector.getInstance().execute("SEARCH GROUPS " + type, responseHeader);
            Utils.checkError(response);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            Group[] groups = new Group[ids.length];
            int i = 0;
            while (i < ids.length) {
                groups[i] = Group.getInstance(ids[i]);
                ++i;
            }
            return groups;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public Group getGroup(String displayName) throws SkypeException {
        Utils.checkNotNull(displayName, "displayName");
        Group[] groupArray = this.getAllGroups();
        int n = 0;
        int n2 = groupArray.length;
        while (n < n2) {
            Group group = groupArray[n];
            if (displayName.equals(group.getDisplayName())) {
                return group;
            }
            ++n;
        }
        return null;
    }

    public Group addGroup(String name) throws SkypeException {
        try {
            String responseHeader = "GROUP ";
            String response = Connector.getInstance().execute("CREATE GROUP " + name, responseHeader).substring(responseHeader.length());
            Utils.checkError(response);
            String id = response.substring(0, response.indexOf(32));
            return Group.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public void removeGroup(Group group) throws SkypeException {
        group.dispose();
    }
}

