/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ConnectorUtils {
    public static void checkNotNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException("The" + name + " must not be null.");
        }
    }

    public static boolean extractFromJarToTemp(String filename) {
        return ConnectorUtils.extractFromJar(filename, filename, System.getProperty("java.io.tmpdir"));
    }

    public static boolean extractFromJar(String filename, String destinationDirectory) {
        return ConnectorUtils.extractFromJar(filename, filename, destinationDirectory);
    }

    public static boolean extractFromJar(String searchString, String filename, String destinationDirectory) {
        boolean extracted = false;
        String classpath = System.getProperty("java.class.path");
        File jarfile = null;
        byte[] buf = new byte[1024];
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens() && !extracted) {
            String jarFileName = st.nextToken();
            jarfile = new File(jarFileName);
            if (!jarfile.exists() || !jarfile.isFile()) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(jarFileName);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ZipInputStream zis = new ZipInputStream(bis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    int n;
                    if (!ze.getName().endsWith(searchString)) continue;
                    if (!destinationDirectory.endsWith(File.separator)) {
                        destinationDirectory = String.valueOf(destinationDirectory) + File.separator;
                    }
                    FileOutputStream fileoutputstream = new FileOutputStream(String.valueOf(destinationDirectory) + filename);
                    while ((n = zis.read(buf, 0, 1024)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                    fileoutputstream.close();
                    extracted = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                extracted = false;
            }
        }
        return extracted;
    }

    public static boolean isInJar(String searchString) {
        boolean found = false;
        String classpath = System.getProperty("java.class.path");
        File jarfile = null;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens() && !found) {
            String jarFileName = st.nextToken();
            jarfile = new File(jarFileName);
            if (!jarfile.exists() || !jarfile.isFile()) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(jarFileName);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ZipInputStream zis = new ZipInputStream(bis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    if (!ze.getName().endsWith(searchString)) continue;
                    found = true;
                }
            }
            catch (Exception e) {
                found = false;
            }
        }
        return found;
    }

    protected static String getLibrarySearchPath() {
        return String.valueOf(System.getProperty("java.library.path")) + File.pathSeparatorChar + System.getProperty("user.dir") + File.pathSeparatorChar;
    }

    public static boolean checkLibraryInPath(String libFilename) {
        boolean libfilefound = false;
        String libpath = ConnectorUtils.getLibrarySearchPath();
        File libfile = new File("");
        StringTokenizer st = new StringTokenizer(libpath, File.pathSeparator);
        while (st.hasMoreTokens() && !libfilefound) {
            libfile = new File(String.valueOf(st.nextToken()) + File.separatorChar + libFilename);
            libfilefound = libfile.exists();
        }
        return libfilefound;
    }

    private ConnectorUtils() {
    }
}

