/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.osx;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorUtils;
import java.io.File;

public final class OSXConnector
extends Connector
implements Runnable {
    private static OSXConnector _instance = null;
    private static final Object lock = new Object();
    private static boolean lockWait = false;
    private boolean inited;
    private static final String LIBNAME = "JSA";
    private static final String LIBFILENAME = "libJSA.jnilib";

    private OSXConnector() {
        if (!ConnectorUtils.checkLibraryInPath(LIBFILENAME) || !this.checkInstalledFramework()) {
            ConnectorUtils.extractFromJarToTemp(LIBFILENAME);
            this.installFramework();
        }
        try {
            System.loadLibrary(LIBNAME);
        }
        catch (Throwable throwable) {
            try {
                System.load(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separatorChar + LIBFILENAME);
            }
            catch (Throwable throwable2) {
                System.err.println("Could not load the library");
                if (!ConnectorUtils.checkLibraryInPath(LIBFILENAME)) {
                    System.err.println("libJSA.jnilib is not in java.library.path");
                }
                if (!this.checkInstalledFramework()) {
                    System.err.println("Please install Skype.framework at /Library/Frameworks/Skype.framework");
                }
                this.setStatus(Connector.Status.NOT_AVAILABLE);
                this.fireMessageReceived("ConnectorStatusChanged");
            }
        }
    }

    private boolean checkInstalledFramework() {
        File frameworkLocationHome = new File("~/Library/Frameworks/Skype.framework");
        File frameworkLocationSystem = new File("/Library/Frameworks/Skype.framework");
        return frameworkLocationHome.exists() || frameworkLocationSystem.exists();
    }

    private void installFramework() {
        if (ConnectorUtils.isInJar("A/Skype")) {
            String destinationname;
            File frameworkLocation = new File("~/Library/Frameworks/Skype.framework");
            if (frameworkLocation.exists()) {
                ConnectorUtils.deleteDir(frameworkLocation);
            }
            if ((frameworkLocation = new File("/Library/Frameworks/Skype.framework")).exists()) {
                ConnectorUtils.deleteDir(frameworkLocation);
            }
            if (!(destinationname = System.getProperty("user.home")).endsWith(File.separator)) {
                destinationname = String.valueOf(destinationname) + File.separator;
            }
            if (destinationname.endsWith("root/")) {
                destinationname = "/";
            }
            destinationname = String.valueOf(destinationname) + "Library/Frameworks/";
            File frameworkDirectory = new File(String.valueOf(destinationname) + "Skype.framework/Versions/A/.tmp");
            frameworkDirectory.mkdirs();
            frameworkDirectory = new File(String.valueOf(destinationname) + "Skype.framework/Versions/Current/.tmp");
            frameworkDirectory.mkdirs();
            ConnectorUtils.extractFromJar("A/Skype", "Skype", String.valueOf(destinationname) + "Skype.framework/Versions/A");
            ConnectorUtils.extractFromJar("A/Skype", "Skype", String.valueOf(destinationname) + "Skype.framework/Versions/Current");
            ConnectorUtils.extractFromJar("A/Skype", "Skype", String.valueOf(destinationname) + "Skype.framework");
        }
    }

    public static OSXConnector getInstance() {
        if (_instance == null) {
            _instance = new OSXConnector();
        }
        return _instance;
    }

    protected void sendCommand(String command) {
        this.sendSkypeMessage(command);
    }

    protected void disposeImpl() {
        OSXConnector.setConnectedStatus(5);
        this.disposeNative();
        _instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connector.Status connect(int timeout) {
        if (_instance.getStatus() != Connector.Status.ATTACHED) {
            Object object = lock;
            synchronized (object) {
                try {
                    lockWait = true;
                    lock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.getStatus();
    }

    protected void initialize(int timeout) {
        if (!this.inited) {
            this.inited = true;
            new Thread(this).start();
            this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
            this.fireMessageReceived("ConnectorStatusChanged");
            this.setDebugPrinting(false);
            this.init(this.getApplicationName());
        }
    }

    public static synchronized void receiveSkypeMessage(final String message) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (_instance.getStatus() != Connector.Status.ATTACHED) {
                    OSXConnector.setConnectedStatus(1);
                }
                if (lockWait) {
                    OSXConnector.setConnectedStatus(1);
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                    lockWait = false;
                }
                if (message != null) {
                    _instance.fireMessageReceived(message);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectedStatus(int status) {
        if (lockWait) {
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
                lockWait = false;
            }
        }
        switch (status) {
            case 0: {
                _instance.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                break;
            }
            case 1: {
                _instance.setStatus(Connector.Status.ATTACHED);
                break;
            }
            case 2: {
                _instance.setStatus(Connector.Status.REFUSED);
                break;
            }
            case 3: {
                _instance.setStatus(Connector.Status.NOT_AVAILABLE);
                break;
            }
            case 4: {
                _instance.setStatus(Connector.Status.API_AVAILABLE);
                break;
            }
            case 5: {
                _instance.setStatus(Connector.Status.NOT_RUNNING);
                break;
            }
            default: {
                _instance.setStatus(Connector.Status.NOT_RUNNING);
            }
        }
        _instance.fireMessageReceived("ConnectorStatusChanged");
    }

    public void run() {
        this.startEventLoop();
    }

    private synchronized native void init(String var1);

    private native void startEventLoop();

    private native void sendSkypeMessage(String var1);

    private native void disposeNative();

    private native void setDebugPrinting(boolean var1);

    public static synchronized /* bridge */ /* synthetic */ Connector getInstance() {
        return OSXConnector.getInstance();
    }
}

