/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.test;

import com.skype.connector.test.CSVPlayer;
import com.skype.connector.test.CSVRecorder;
import com.skype.connector.test.TestConnector;
import java.io.File;
import junit.framework.TestCase;

public abstract class TestCaseByCSVFile
extends TestCase {
    private boolean isRecordingMode;
    private CSVRecorder recorder;

    public final void setRecordingMode(boolean on) {
        this.isRecordingMode = on;
    }

    public final boolean isRecordingMode() {
        return this.isRecordingMode;
    }

    protected final void runTest() throws Throwable {
        if (this.isRecordingMode) {
            this.recorder = this.startCSVRecording();
        } else {
            this.startCSVPlaying();
        }
        try {
            super.runTest();
        }
        finally {
            if (this.isRecordingMode) {
                this.endCSVRecording(this.recorder);
            } else {
                this.endCSVPlaying();
            }
        }
    }

    private CSVRecorder startCSVRecording() throws Exception {
        CSVRecorder recorder = new CSVRecorder(this.getTestDataFileName());
        TestConnector.getInstance().addRecorder(recorder);
        return recorder;
    }

    private void endCSVRecording(CSVRecorder recorder) {
        assert (recorder != null);
        recorder.close();
    }

    private void startCSVPlaying() throws Exception {
        TestConnector.getInstance().setPlayer(new CSVPlayer(this.getTestDataFileName()));
    }

    private void endCSVPlaying() throws Exception {
        TestConnector.getInstance().clearPlayer();
    }

    private String getTestDataFileName() {
        return "test" + File.separator + ((Object)((Object)this)).getClass().getName().replace(".", File.separator) + "_" + this.getName() + ".csv";
    }
}

