/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Chat;
import com.skype.Friend;
import com.skype.TestData;
import com.skype.TestUtils;
import junit.framework.TestCase;

public class ChatAPITest
extends TestCase {
    public void testChat() throws Exception {
        Friend friend = TestData.getFriend();
        Chat chat = friend.chat();
        long time = chat.getTime().getTime();
        ChatAPITest.assertTrue((0L <= time && time <= System.currentTimeMillis() ? 1 : 0) != 0);
        ChatAPITest.assertNull((Object)chat.getAdder());
        ChatAPITest.assertTrue((boolean)chat.getStatus().equals((Object)Chat.Status.DIALOG));
        ChatAPITest.assertTrue((chat.getWindowTitle().length() > 0 ? 1 : 0) != 0);
        ChatAPITest.assertEquals((int)0, (int)chat.getAllPosters().length);
        ChatAPITest.assertEquals((int)2, (int)chat.getAllMembers().length);
        chat.send("Test Message");
        TestUtils.showCheckDialog(String.valueOf(TestData.getFriendId()) + " has received \"Test Message\"\u00c5H");
        chat.setTopic("New Topic");
        TestUtils.showCheckDialog("Topic was changed to \"New Topic\"\u00c5H");
        Friend friend2 = TestData.getFriend2();
        chat.addUser(friend2);
        ChatAPITest.assertEquals((int)1, (int)chat.getAllPosters().length);
        ChatAPITest.assertEquals((int)3, (int)chat.getAllMembers().length);
        TestUtils.showCheckDialog(String.valueOf(friend2.getId()) + " was added to this chat\u00c5H");
        chat.leave();
        ChatAPITest.assertEquals((int)2, (int)chat.getAllMembers().length);
        TestUtils.showCheckDialog("You have left from this chat\u00c5H");
        ChatAPITest.assertTrue((chat.getAllChatMessages().length > 0 ? 1 : 0) != 0);
        ChatAPITest.assertTrue((chat.getRecentChatMessages().length > 0 ? 1 : 0) != 0);
    }
}

