#!/usr/local/bin/ruby
$pwd = Dir::pwd( );
Dir::chdir( File::dirname( __FILE__ ) );
require 'webrick';
require 'getoptlong';
require 'skypeer/config';
require 'skypeer/servent';
include WEBrick;
CONFIG_FILE = 'skypeer.conf';
PID_FILE = 'skypeer.pid';

def get_fullpath( path )
  path =~ /^\// ? path : "#{$pwd}/#{path}";
end

def shutdown( )
  $servent.shutdown( );
  File::delete( PID_FILE );
end


parser = GetoptLong.new( );
parser.set_options( ['--port', '-p', GetoptLong::REQUIRED_ARGUMENT ], 
		    ['--speed', '-s', GetoptLong::REQUIRED_ARGUMENT ],
		    ['--config', '-c',  GetoptLong::REQUIRED_ARGUMENT ],
		    ['--documentroot', '-r',  GetoptLong::REQUIRED_ARGUMENT ],
		    ['--datadir', '-d',  GetoptLong::REQUIRED_ARGUMENT ],
		    ['--debug', '-D',  GetoptLong::NO_ARGUMENT ] );
opt = Hash.new( );
parser.each { |name,value| opt[name] = value; }
config_file = opt['--config'] ? get_fullpath( opt['--config'] ) : CONFIG_FILE;
config = SkyPeer::Config::load_config( config_file );
config[:Port] = opt['--port'].to_i if( opt['--port'] );
config[:Speed] = opt['--speed'].to_i if( opt['--speed'] );
config[:DocumentRoot] = get_fullpath( opt['--documentroot'] ) if( opt['--documentroot'] );
config[:DataDir] = get_fullpath( opt['--datadir'] ) if( opt['--datadir'] );
config[:AccessLog] = [ [ File::open( 'log/access.log', 'a' ), AccessLog::COMBINED_LOG_FORMAT ] ]
if( opt['--debug'] ) then
  config[:Logger] = Log::new( STDERR );
  config[:Logger].level = WEBrick::BasicLog::DEBUG;
else
  config[:Logger] = Log::new( 'log/debug.log' );
  config[:Logger].level = WEBrick::BasicLog::INFO;
  if( fork( ) ) then exit; end
  Process.setsid( );
end
if( File::exist?( PID_FILE ) ) then
  raise RuntimeError, 'Failed to start!! Another process may be running.';
end
File::open( PID_FILE, 'w' ) { |io| io.puts( Process::pid ); }

trap( "INT" ) { shutdown( ); }
trap( "TERM" ) { shutdown( ); }
$servent = SkyPeer::Servent.new( config );
$servent.start( );
