require 'ipaddr';

module SkyPeer
  module Config
    DEFAULT = { 
      :Port => 14714,
      :Speed => 8000,  # 8Mbps
      :DocumentRoot => 'htdocs',
      :DataDir => 'htdocs/data',
      :EndPoint => 'http://suid.s39.xrea.com/skypeer/db.xcg',
      :MaxCandidate => 10,
      :AllowExt => '(jpg|png|gif|swf|mp3|mpg|mpeg|dat|txt)',
      :PrivilegeHost => '127.0.0.1' 
    };

    def Config::load_config( conffile )
      config = DEFAULT;
      File::open( conffile, 'r' ) { |io|
	io.each_line { |line|
	  if( line =~ /^\s*(?:\#|$)/ ) then next; end
	  line.strip!( );
	  name, value = line.split( /\s+/ );
	  case name
	  when 'Port'
	    config[name.intern] = value.to_i;
	  when 'Speed'
	    config[name.intern] = value.to_i ;
	  when 'DocumentRoot'
	    config[name.intern] = value;
	  when 'DataDir'
	    config[name.intern] = value;
	  when 'EndPoint'
	    config[name.intern] = value.split( /\s*,\s*/ );
	  when 'MaxCandidate'
	    config[name.intern] = value.to_i;
	  when 'MaxDownloadSize'
	    config[name.intern] = 1024*value.to_i;
	  when 'MaxUploadSize'
	    config[name.intern] = 1024*value.to_i;
	  when 'AllowExt'
	    config[name.intern] = Regexp.new( value );
	  when 'PrivilegeHost'
	    config[name.intern] = Array.new( );
	    value.split( /\s*,\s*/ ).each { |ip|
	      config[name.intern] << IPAddr.new( ip );
	    }
	  end
	}
      }
      return( config );
    end
  end
end
