/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef WebKitDOMDocument_h
#define WebKitDOMDocument_h

#include "webkit/webkitdomdefines.h"
#include <glib-object.h>
#include <webkit/webkitdefines.h>
#include "webkit/WebKitDOMNode.h"


G_BEGIN_DECLS
#define WEBKIT_TYPE_DOM_DOCUMENT            (webkit_dom_document_get_type())
#define WEBKIT_DOM_DOCUMENT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_TYPE_DOM_DOCUMENT, WebKitDOMDocument))
#define WEBKIT_DOM_DOCUMENT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_TYPE_DOM_DOCUMENT, WebKitDOMDocumentClass)
#define WEBKIT_DOM_IS_DOCUMENT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_TYPE_DOM_DOCUMENT))
#define WEBKIT_DOM_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_TYPE_DOM_DOCUMENT))
#define WEBKIT_DOM_DOCUMENT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_TYPE_DOM_DOCUMENT, WebKitDOMDocumentClass))

struct _WebKitDOMDocument {
    WebKitDOMNode parent_instance;
};

struct _WebKitDOMDocumentClass {
    WebKitDOMNodeClass parent_class;
};

WEBKIT_API GType
webkit_dom_document_get_type (void);

WEBKIT_API WebKitDOMElement*
webkit_dom_document_create_element(WebKitDOMDocument* self, const gchar* tag_name, GError **error);

WEBKIT_API WebKitDOMDocumentFragment*
webkit_dom_document_create_document_fragment(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMText*
webkit_dom_document_create_text_node(WebKitDOMDocument* self, const gchar* data);

WEBKIT_API WebKitDOMComment*
webkit_dom_document_create_comment(WebKitDOMDocument* self, const gchar* data);

WEBKIT_API WebKitDOMCDATASection*
webkit_dom_document_create_cdata_section(WebKitDOMDocument* self, const gchar* data, GError **error);

WEBKIT_API WebKitDOMProcessingInstruction*
webkit_dom_document_create_processing_instruction(WebKitDOMDocument* self, const gchar* target, const gchar* data, GError **error);

WEBKIT_API WebKitDOMAttr*
webkit_dom_document_create_attribute(WebKitDOMDocument* self, const gchar* name, GError **error);

WEBKIT_API WebKitDOMEntityReference*
webkit_dom_document_create_entity_reference(WebKitDOMDocument* self, const gchar* name, GError **error);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_document_get_elements_by_tag_name(WebKitDOMDocument* self, const gchar* tagname);

WEBKIT_API WebKitDOMNode*
webkit_dom_document_import_node(WebKitDOMDocument* self, WebKitDOMNode* imported_node, gboolean deep, GError **error);

WEBKIT_API WebKitDOMElement*
webkit_dom_document_create_element_ns(WebKitDOMDocument* self, const gchar* namespace_uri, const gchar* qualified_name, GError **error);

WEBKIT_API WebKitDOMAttr*
webkit_dom_document_create_attribute_ns(WebKitDOMDocument* self, const gchar* namespace_uri, const gchar* qualified_name, GError **error);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_document_get_elements_by_tag_name_ns(WebKitDOMDocument* self, const gchar* namespace_uri, const gchar* local_name);

WEBKIT_API WebKitDOMElement*
webkit_dom_document_get_element_by_id(WebKitDOMDocument* self, const gchar* element_id);

WEBKIT_API WebKitDOMNode*
webkit_dom_document_adopt_node(WebKitDOMDocument* self, WebKitDOMNode* source, GError **error);

WEBKIT_API WebKitDOMEvent*
webkit_dom_document_create_event(WebKitDOMDocument* self, const gchar* event_type, GError **error);

WEBKIT_API WebKitDOMRange*
webkit_dom_document_create_range(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMNodeIterator*
webkit_dom_document_create_node_iterator(WebKitDOMDocument* self, WebKitDOMNode* root, gulong what_to_show, WebKitDOMNodeFilter* filter, gboolean expand_entity_references, GError **error);

WEBKIT_API WebKitDOMTreeWalker*
webkit_dom_document_create_tree_walker(WebKitDOMDocument* self, WebKitDOMNode* root, gulong what_to_show, WebKitDOMNodeFilter* filter, gboolean expand_entity_references, GError **error);

WEBKIT_API WebKitDOMCSSStyleDeclaration*
webkit_dom_document_get_override_style(WebKitDOMDocument* self, WebKitDOMElement* element, const gchar* pseudo_element);

WEBKIT_API WebKitDOMXPathExpression*
webkit_dom_document_create_expression(WebKitDOMDocument* self, const gchar* expression, WebKitDOMXPathNSResolver* resolver, GError **error);

WEBKIT_API WebKitDOMXPathNSResolver*
webkit_dom_document_create_ns_resolver(WebKitDOMDocument* self, WebKitDOMNode* node_resolver);

WEBKIT_API WebKitDOMXPathResult*
webkit_dom_document_evaluate(WebKitDOMDocument* self, const gchar* expression, WebKitDOMNode* context_node, WebKitDOMXPathNSResolver* resolver, gushort type, WebKitDOMXPathResult* in_result, GError **error);

WEBKIT_API gboolean
webkit_dom_document_exec_command(WebKitDOMDocument* self, const gchar* command, gboolean user_interface, const gchar* value);

WEBKIT_API gboolean
webkit_dom_document_query_command_enabled(WebKitDOMDocument* self, const gchar* command);

WEBKIT_API gboolean
webkit_dom_document_query_command_indeterm(WebKitDOMDocument* self, const gchar* command);

WEBKIT_API gboolean
webkit_dom_document_query_command_state(WebKitDOMDocument* self, const gchar* command);

WEBKIT_API gboolean
webkit_dom_document_query_command_supported(WebKitDOMDocument* self, const gchar* command);

WEBKIT_API gchar*
webkit_dom_document_query_command_value(WebKitDOMDocument* self, const gchar* command);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_document_get_elements_by_name(WebKitDOMDocument* self, const gchar* element_name);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_document_nodes_from_rect(WebKitDOMDocument* self, glong x, glong y, gulong h_padding, gulong v_padding, gboolean ignore_clipping);

WEBKIT_API WebKitDOMElement*
webkit_dom_document_element_from_point(WebKitDOMDocument* self, glong x, glong y);

WEBKIT_API WebKitDOMRange*
webkit_dom_document_caret_range_from_point(WebKitDOMDocument* self, glong x, glong y);

WEBKIT_API WebKitDOMCSSStyleDeclaration*
webkit_dom_document_create_css_style_declaration(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_document_get_elements_by_class_name(WebKitDOMDocument* self, const gchar* tagname);

WEBKIT_API WebKitDOMElement*
webkit_dom_document_query_selector(WebKitDOMDocument* self, const gchar* selectors, GError **error);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_document_query_selector_all(WebKitDOMDocument* self, const gchar* selectors, GError **error);

WEBKIT_API WebKitDOMDocumentType*
webkit_dom_document_get_doctype(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMDOMImplementation*
webkit_dom_document_get_implementation(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMElement*
webkit_dom_document_get_document_element(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_input_encoding(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_xml_encoding(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_xml_version(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_xml_version(WebKitDOMDocument* self, const gchar* value, GError **error);

WEBKIT_API gboolean
webkit_dom_document_get_xml_standalone(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_xml_standalone(WebKitDOMDocument* self, gboolean value, GError **error);

WEBKIT_API gchar*
webkit_dom_document_get_document_uri(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_document_uri(WebKitDOMDocument* self, const gchar* value);

WEBKIT_API WebKitDOMDOMWindow*
webkit_dom_document_get_default_view(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMStyleSheetList*
webkit_dom_document_get_style_sheets(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_title(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_title(WebKitDOMDocument* self, const gchar* value);

WEBKIT_API gchar*
webkit_dom_document_get_referrer(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_domain(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_cookie(WebKitDOMDocument* self, GError **error);

WEBKIT_API void
webkit_dom_document_set_cookie(WebKitDOMDocument* self, const gchar* value, GError **error);

WEBKIT_API WebKitDOMHTMLElement*
webkit_dom_document_get_body(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_body(WebKitDOMDocument* self, WebKitDOMHTMLElement* value, GError **error);

WEBKIT_API WebKitDOMHTMLHeadElement*
webkit_dom_document_get_head(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMHTMLCollection*
webkit_dom_document_get_images(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMHTMLCollection*
webkit_dom_document_get_applets(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMHTMLCollection*
webkit_dom_document_get_links(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMHTMLCollection*
webkit_dom_document_get_forms(WebKitDOMDocument* self);

WEBKIT_API WebKitDOMHTMLCollection*
webkit_dom_document_get_anchors(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_last_modified(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_charset(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_charset(WebKitDOMDocument* self, const gchar* value);

WEBKIT_API gchar*
webkit_dom_document_get_default_charset(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_ready_state(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_character_set(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_preferred_stylesheet_set(WebKitDOMDocument* self);

WEBKIT_API gchar*
webkit_dom_document_get_selected_stylesheet_set(WebKitDOMDocument* self);

WEBKIT_API void
webkit_dom_document_set_selected_stylesheet_set(WebKitDOMDocument* self, const gchar* value);

WEBKIT_API gchar*
webkit_dom_document_get_compat_mode(WebKitDOMDocument* self);

G_END_DECLS

#endif /* WebKitDOMDocument_h */
