/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef WebKitDOMElement_h
#define WebKitDOMElement_h

#include "webkit/webkitdomdefines.h"
#include <glib-object.h>
#include <webkit/webkitdefines.h>
#include "webkit/WebKitDOMNode.h"


G_BEGIN_DECLS
#define WEBKIT_TYPE_DOM_ELEMENT            (webkit_dom_element_get_type())
#define WEBKIT_DOM_ELEMENT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), WEBKIT_TYPE_DOM_ELEMENT, WebKitDOMElement))
#define WEBKIT_DOM_ELEMENT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),  WEBKIT_TYPE_DOM_ELEMENT, WebKitDOMElementClass)
#define WEBKIT_DOM_IS_ELEMENT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), WEBKIT_TYPE_DOM_ELEMENT))
#define WEBKIT_DOM_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),  WEBKIT_TYPE_DOM_ELEMENT))
#define WEBKIT_DOM_ELEMENT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),  WEBKIT_TYPE_DOM_ELEMENT, WebKitDOMElementClass))

struct _WebKitDOMElement {
    WebKitDOMNode parent_instance;
};

struct _WebKitDOMElementClass {
    WebKitDOMNodeClass parent_class;
};

WEBKIT_API GType
webkit_dom_element_get_type (void);

WEBKIT_API gchar*
webkit_dom_element_get_attribute(WebKitDOMElement* self, const gchar* name);

WEBKIT_API void
webkit_dom_element_set_attribute(WebKitDOMElement* self, const gchar* name, const gchar* value, GError **error);

WEBKIT_API void
webkit_dom_element_remove_attribute(WebKitDOMElement* self, const gchar* name, GError **error);

WEBKIT_API WebKitDOMAttr*
webkit_dom_element_get_attribute_node(WebKitDOMElement* self, const gchar* name);

WEBKIT_API WebKitDOMAttr*
webkit_dom_element_set_attribute_node(WebKitDOMElement* self, WebKitDOMAttr* new_attr, GError **error);

WEBKIT_API WebKitDOMAttr*
webkit_dom_element_remove_attribute_node(WebKitDOMElement* self, WebKitDOMAttr* old_attr, GError **error);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_element_get_elements_by_tag_name(WebKitDOMElement* self, const gchar* name);

WEBKIT_API gchar*
webkit_dom_element_get_attribute_ns(WebKitDOMElement* self, const gchar* namespace_uri, const gchar* local_name);

WEBKIT_API void
webkit_dom_element_set_attribute_ns(WebKitDOMElement* self, const gchar* namespace_uri, const gchar* qualified_name, const gchar* value, GError **error);

WEBKIT_API void
webkit_dom_element_remove_attribute_ns(WebKitDOMElement* self, const gchar* namespace_uri, const gchar* local_name, GError **error);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_element_get_elements_by_tag_name_ns(WebKitDOMElement* self, const gchar* namespace_uri, const gchar* local_name);

WEBKIT_API WebKitDOMAttr*
webkit_dom_element_get_attribute_node_ns(WebKitDOMElement* self, const gchar* namespace_uri, const gchar* local_name);

WEBKIT_API WebKitDOMAttr*
webkit_dom_element_set_attribute_node_ns(WebKitDOMElement* self, WebKitDOMAttr* new_attr, GError **error);

WEBKIT_API gboolean
webkit_dom_element_has_attribute(WebKitDOMElement* self, const gchar* name);

WEBKIT_API gboolean
webkit_dom_element_has_attribute_ns(WebKitDOMElement* self, const gchar* namespace_uri, const gchar* local_name);

WEBKIT_API void
webkit_dom_element_focus(WebKitDOMElement* self);

WEBKIT_API void
webkit_dom_element_blur(WebKitDOMElement* self);

WEBKIT_API void
webkit_dom_element_scroll_into_view(WebKitDOMElement* self, gboolean align_with_top);

WEBKIT_API gboolean
webkit_dom_element_contains(WebKitDOMElement* self, WebKitDOMElement* element);

WEBKIT_API void
webkit_dom_element_scroll_into_view_if_needed(WebKitDOMElement* self, gboolean center_if_needed);

WEBKIT_API void
webkit_dom_element_scroll_by_lines(WebKitDOMElement* self, glong lines);

WEBKIT_API void
webkit_dom_element_scroll_by_pages(WebKitDOMElement* self, glong pages);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_element_get_elements_by_class_name(WebKitDOMElement* self, const gchar* name);

WEBKIT_API WebKitDOMElement*
webkit_dom_element_query_selector(WebKitDOMElement* self, const gchar* selectors, GError **error);

WEBKIT_API WebKitDOMNodeList*
webkit_dom_element_query_selector_all(WebKitDOMElement* self, const gchar* selectors, GError **error);

WEBKIT_API gboolean
webkit_dom_element_webkit_matches_selector(WebKitDOMElement* self, const gchar* selectors, GError **error);

WEBKIT_API gchar*
webkit_dom_element_get_tag_name(WebKitDOMElement* self);

WEBKIT_API WebKitDOMCSSStyleDeclaration*
webkit_dom_element_get_style(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_offset_left(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_offset_top(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_offset_width(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_offset_height(WebKitDOMElement* self);

WEBKIT_API WebKitDOMElement*
webkit_dom_element_get_offset_parent(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_client_left(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_client_top(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_client_width(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_client_height(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_scroll_left(WebKitDOMElement* self);

WEBKIT_API void
webkit_dom_element_set_scroll_left(WebKitDOMElement* self, glong value);

WEBKIT_API glong
webkit_dom_element_get_scroll_top(WebKitDOMElement* self);

WEBKIT_API void
webkit_dom_element_set_scroll_top(WebKitDOMElement* self, glong value);

WEBKIT_API glong
webkit_dom_element_get_scroll_width(WebKitDOMElement* self);

WEBKIT_API glong
webkit_dom_element_get_scroll_height(WebKitDOMElement* self);

WEBKIT_API WebKitDOMElement*
webkit_dom_element_get_first_element_child(WebKitDOMElement* self);

WEBKIT_API WebKitDOMElement*
webkit_dom_element_get_last_element_child(WebKitDOMElement* self);

WEBKIT_API WebKitDOMElement*
webkit_dom_element_get_previous_element_sibling(WebKitDOMElement* self);

WEBKIT_API WebKitDOMElement*
webkit_dom_element_get_next_element_sibling(WebKitDOMElement* self);

WEBKIT_API gulong
webkit_dom_element_get_child_element_count(WebKitDOMElement* self);

G_END_DECLS

#endif /* WebKitDOMElement_h */
