{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: QueryOption

 Dialog window

*********************************************************}
unit QueryOption;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Classes, StringResources;

const
  QO_CLOSE = 0;

type
  TSlavaNapQueryOption = class(TForm)
    Label1: TLabel;
    Cb_Ask: TCheckBox;
    Btn_Yes: TButton;
    Btn_No: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Btn_NoClick(Sender: TObject);
    procedure Btn_YesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Query: Integer;
    procedure Ask(Q: Integer);
  end;

var
  SlavaNapQueryOption: TSlavaNapQueryOption;

implementation

uses constants, MainForm, STypes, Vars;

{$R *.DFM}

procedure TSlavaNapQueryOption.Ask(Q: Integer);
begin
  Query := Q;
  case Query of
    QO_CLOSE:
      begin
        Cb_Ask.Checked := True;
        Label1.Caption := RS_QueryOption_CloseQuery;
        Btn_Yes.Caption := RS_QueryOption_ShutDown;
        Btn_No.Caption := RS_QueryOption_Minimize;
      end;
  end;
  try
    Show;
    Cb_Ask.SetFocus;
  except
  end;
end;

procedure TSlavaNapQueryOption.FormCreate(Sender: TObject);
begin
  Caption := SLAVANAP_TITLE;
end;

procedure TSlavaNapQueryOption.Btn_NoClick(Sender: TObject);
begin
  Close;
  case Query of
    QO_CLOSE:
      try
        if Cb_Ask.Checked then
          B3_Canclose := False3;
        SlavaNapWindow.Hide;
      except
      end;
  end;
end;

procedure TSlavaNapQueryOption.Btn_YesClick(Sender: TObject);
begin
  Close;
  case Query of
    QO_CLOSE:
      try
        if Cb_Ask.Checked then
          B3_Canclose := True3;
        Closing := True;
        SlavaNapWindow.Close;
      except
      end;
  end;
end;

end.
