{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: SetupForm

 Setup window

*********************************************************}
unit SetupForm;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, IniFiles, Constants, Vars, STypes, Classes,
  StringResources;

type
  TSlavaNapSetup = class(TForm)
    Pages: TPageControl;
    Sh1: TTabSheet;
    Sh2: TTabSheet;
    Label1: TLabel;
    Btn_Next: TButton;
    Btn_Cancel1: TButton;
    Btn_Complete: TButton;
    Btn_Cancel2: TButton;
    Btn_Back: TButton;
    Label3: TLabel;
    Edit_Ports: TEdit;
    Edit_Host: TEdit;
    Label4: TLabel;
    Edit_Admin: TEdit;
    Label5: TLabel;
    Label2: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Btn_Cancel1Click(Sender: TObject);
    procedure Btn_CompleteClick(Sender: TObject);
    procedure Btn_BackClick(Sender: TObject);
    procedure Btn_NextClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure ShowSetup;

implementation

uses MainForm;

{$R *.DFM}

procedure ShowSetup;
var
  F: TSlavaNapSetup;
begin
  F := TSlavaNapSetup.Create(SlavaNapWindow);
  F.ShowModal;
end;

procedure TSlavaNapSetup.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TSlavaNapSetup.FormCreate(Sender: TObject);
var
  Ini: TIniFile;
begin
  Pages.ActivePage := Sh1;
  Ini := TIniFile.Create(ApplicationDir + 'config');
  Ini.WriteString('Server', 'Version', SLAVANAP_VERSION);
  Edit_Ports.Text := Ini.ReadString('Server', 'Ports', DEF_LISTEN_PORTS);
  Edit_Host.Text := Ini.ReadString('Server', 'ReportHost', 'localhost');
  Edit_Admin.Text := Ini.ReadString('Console', 'User', 'Admin');
  Ini.Free;
end;

procedure TSlavaNapSetup.Btn_NextClick(Sender: TObject);
begin
  Pages.ActivePage := Sh2;
end;

procedure TSlavaNapSetup.Btn_BackClick(Sender: TObject);
begin
  Pages.ActivePage := Sh1;
end;

procedure TSlavaNapSetup.Btn_Cancel1Click(Sender: TObject);
begin
  IsSetupFailed := True;
  DeleteFile(ApplicationDir + 'config');
  Close;
end;

procedure TSlavaNapSetup.Btn_CompleteClick(Sender: TObject);
var
  Ini: TIniFile;
begin
  if not Check_Name(Edit_Admin.Text, True) then
  begin
    ShowMessage(RS_SetupForm_InvalidAdminName);
    Exit;
  end;
  Ini := TIniFile.Create(ApplicationDir + 'config');
  Ini.WriteString('Server', 'Version', SLAVANAP_VERSION);
  Ini.WriteString('Server', 'Ports', Edit_Ports.Text);
  Ini.WriteString('Server', 'ReportHost', Edit_Host.Text);
  Ini.WriteString('Console', 'User', Edit_Admin.Text);
  Ini.Free;
  IsSetupFailed := False;
  Close;
end;

end.
