{*********************************************************

 Unit: announceform

 Announce messages window (inherited from Private messages window)
 ̃t@CɊւ鎿͂ցusj12262@hotmail.com

*********************************************************}
unit announceform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Menus, localusers;

type
  TSlavaNapAnnounceWindow = class(TForm)
    panel_bottom: TPanel;
    edit: TEdit;
    panel_left: TPanel;
    log: TRichEdit;
    MainMenu1: TMainMenu;
    mnu_close: TMenuItem;
    mnu_whois: TMenuItem;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure panel_bottomResize(Sender: TObject);
    procedure logChange(Sender: TObject);
    procedure CreateParams(Var params: TCreateParams); override;
    procedure editKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure editKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure mnu_draw(Sender: TObject; ACanvas: TCanvas; ARect: TRect;
      Selected: Boolean);
    procedure mnu_closeClick(Sender: TObject);
    procedure mnu_whoisClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure MyWndProc(var Message: TMessage);
  private
    { Private declarations }
  public
    { Public declarations }
    users: TStringList;
    history   : TStringList;
    last      : Integer;
    flash_count: Integer;
    procedure AddMessage(color: Integer; text: String);
    procedure ChangeColors;
  end;

var
  SlavaNapAnnounceWindow: TSlavaNapAnnounceWindow;

implementation

uses stypes, vars, constants, lang, slavamenu;

{$R *.DFM}

procedure TSlavaNapAnnounceWindow.panel_bottomResize(Sender: TObject);
var
 i,j: Integer;
begin
 edit.Width:=panel_bottom.width-4;
end;

procedure TSlavaNapAnnounceWindow.CreateParams(Var params: TCreateParams);
begin
  inherited CreateParams( params );
  params.ExStyle := params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSlavaNapAnnounceWindow.FormCreate(Sender: TObject);
var
 r: TRect;
begin
 SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
 Top:=(r.Top+r.Bottom-Height) div 2;
 Left:=(r.Right+r.Left-Width-4) div 2;
 history:=TStringList.Create;
 WindowProc:=MyWndProc;
 flash_count:=100;
 SetActiveWindow(Handle);
 log.lines.clear;
 edit.text:='';
 ChangeColors;
 if chat_mini then WindowState:=wsMinimized;
end;

procedure TSlavaNapAnnounceWindow.logChange(Sender: TObject);
var
 c1: TRichEdit;
begin
 if Sender is TRichEdit then
 begin
  c1:=Sender as TRichEdit;
  c1.SelStart := c1.Perform(EM_LINEINDEX, c1.Lines.Count, 0);
  c1.Perform(EM_SCROLLCARET, 0, 0);
  exit;
 end;
end;

procedure TSlavaNapAnnounceWindow.editKeyPress(Sender: TObject;
  var Key: Char);
begin
 if Key=#13 then Key:=#0;
end;

procedure TSlavaNapAnnounceWindow.AddMessage(color: Integer; text: String);
begin
 try
   if log.Lines.Count>300 then
   begin
     log.Lines.BeginUpdate;
     while log.Lines.Count>300 do
      log.Lines.Delete(0);
     log.Lines.EndUpdate;
   end;
   log.SelLength:=0;
   log.SelStart:=Length(log.Text);
   log.SelAttributes.Color:=color;
   //log.Lines.Add(GetLogTime+text);
   log.Lines.Add(text);
   logChange(log);
   if chat_flash then
    flash_count:=0;
  except
 end;
 try
  if switch_chat then
   edit.SetFocus;
  except
 end;
end;

procedure TSlavaNapAnnounceWindow.FormDestroy(Sender: TObject);
var
 i: Integer;
begin
 users.Free;
 users:=nil;
 history.Free;
 history:=nil;
 if cons_chat<>nil then
  for i:=cons_chat.Count-1 downto 0 do
   if cons_chat.Items[i]=self then
    cons_chat.Delete(i);
end;

procedure TSlavaNapAnnounceWindow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 Action:=caFree;
end;

procedure TSlavaNapAnnounceWindow.editKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
 str: String;
 b: Boolean;
 i: Integer;
 loc: TLocalUser;
begin
 case Key of
   13: try
           if not running then exit;
           str:=edit.text;
           for i:=0 to users.Count-1 do
             cmd_list.AddDoubleCmd(MSG_CLIENT_PRIVMSG,0,users[i]+' [m] '+str,'');
           Self.AddMessage(slChatMyMessage,'<'+cons.nick+'> [m] '+str);
           Last:=History.Add(str)+1;
           if History.Count>100 then
           begin
            History.Delete(0);
            dec(Last);
           end;
           edit.Text:='';
          except
        end;
   38:  begin // up
           if Last>0 then
           begin
             dec(Last);
             str:=History.Strings[Last];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
           end
           else
            if History.Count>0 then
            begin
             str:=History.Strings[0];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
            end;
        end;
   40:  begin // down
           if Last<(History.Count-1) then
           begin
             inc(Last);
             str:=History.Strings[Last];
             edit.SelectAll;
             edit.SetSelTextBuf(PChar(str));
           end
           else
           begin
            Last:=History.Count;
            edit.Text:='';
           end;
        end;
 end;
end;

procedure TSlavaNapAnnounceWindow.mnu_draw(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
 SlavaDrawMainMenu(self, Sender, ACanvas, ARect, Selected);
end;

procedure TSlavaNapAnnounceWindow.mnu_closeClick(Sender: TObject);
begin
 Close;
end;

procedure TSlavaNapAnnounceWindow.mnu_whoisClick(Sender: TObject);
var
  i:Integer;
begin
 if not running then exit;
 i:=0;
 while (i<5) and (i<users.Count) do
 begin
  cmd_list.AddDoubleCmd(MSG_CLIENT_WHOIS,0,users[i],'');
  inc(i);
 end;
end;

procedure TSlavaNapAnnounceWindow.FormShow(Sender: TObject);
begin
 mnu_close.Caption:=GetLangI(LNG_CMNU_CLOSE);
end;

procedure TSlavaNapAnnounceWindow.FormResize(Sender: TObject);
begin
 try
  log.Invalidate;
  except
 end;
end;

procedure TSlavaNapAnnounceWindow.Timer1Timer(Sender: TObject);
begin
 if flash_count<11 then
  FlashWindow(handle,not Active);
 if flash_count=11 then
  FlashWindow(handle,false);
 inc(flash_count);
end;

procedure TSlavaNapAnnounceWindow.FormActivate(Sender: TObject);
begin
 flash_count:=100;
end;

procedure TSlavaNapAnnounceWindow.MyWndProc(var Message: TMessage);
begin
 WndProc(Message);
 if Message.Msg = WM_ACTIVATE then
   flash_count:=100;
end;

procedure TSlavaNapAnnounceWindow.ChangeColors;
begin
 log.Color:=slBackground;
 log.Font.Color:=slText;
 edit.Color:=slBackground;
 edit.Font.Color:=slText;
end;


end.
 