{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: Config

 Handler for remote configuration command

*********************************************************}
unit Config;

interface

uses
  SysUtils, Classes2, Slavamasks, Windows, Constants, Users, Servers, STypes,
    LocalUsers,
  Registered, Handler, Lang, Vars, Forms, Registry;

procedure SetConfig(User: POnlineUser; Command: string);
procedure SetConfigRemote(User: POnlineUser; Command: string);

implementation

var
  DB_Vars: TMyStringList;
  HList: TMyStringList;

procedure ShowVarRemote(Command: string; Value: string; ReplyTo: POnlineUser;
  Reply: string); overload;
begin
  ReplyTo.Server.Exec(MSG_SRV_REMOTE_VAR_REPLY, User.UserName + ' ' + Reply + ' '
    + ServerName_T + ' ' + Command + ' = ' + Value);
end;

procedure ShowVarRemote(Command: string; Value: Integer; ReplyTo: POnlineUser;
  Reply: string); overload;
begin
  ShowVarRemote(Command, IntToStr(Value), ReplyTo, Reply);
end;

procedure ShowVarRemote(Command: string; Value: Int64; ReplyTo: POnlineUser;
  Reply: string); overload;
begin
  ShowVarRemote(Command, IntToStr(Value), ReplyTo, Reply);
end;

procedure ShowVarRemote(Command: string; Value: Boolean; ReplyTo: POnlineUser;
  Reply: string); overload;
begin
  if Value then
    ShowVarRemote(Command, 'yes', ReplyTo, Reply)
  else
    ShowVarRemote(Command, 'no', ReplyTo, Reply);
end;

procedure ShowVarRemote(Command: string; Value: TAllowLinkType;
  ReplyTo: POnlineUser; Reply: string); overload;
begin
  if Value = linkAll then
    ShowVarRemote(Command, 'all', ReplyTo, Reply)
  else if Value = linkNone then
    ShowVarRemote(Command, 'none', ReplyTo, Reply)
  else if Value = linkCustom then
    ShowVarRemote(Command, 'custom', ReplyTo, Reply)
  else
    ShowVarRemote(Command, 'list', ReplyTo, Reply);
end;

procedure ShowStartupRemote(Command: string; ReplyTo: POnlineUser;
  Reply: string);
var
  Reg: TRegistry;
  B: Boolean;
  Str: string;
begin
  Reg := TRegistry.Create;
  B := False;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run', True);
    Str := Reg.ReadString('SlavaNap');
    if Str <> '' then
      B := True;
  except
  end;
  Reg.Free;
  if B then
    ShowVarRemote(Command, 'yes', ReplyTo, Reply)
  else
    ShowVarRemote(Command, 'no', ReplyTo, Reply);
end;

procedure ListConfigRemote(Command: string; ReplyTo: POnlineUser;
  Reply: string);
begin
  if Command = 'registered_only' then
    ShowVarRemote(Command, Registered_Only, ReplyTo, Reply)
  else if Command = 'allow_register' then
    ShowVarRemote(Command, Allow_Register, ReplyTo, Reply)
  else if Command = 'max_users' then
    ShowVarRemote(Command, Max_Users, ReplyTo, Reply)
  else if Command = 'stats_delay' then
    ShowVarRemote(Command, Stats_Delay div 1000, Replyto, Reply)
  else if Command = 'max_hotlist' then
    ShowVarRemote(Command, Max_Hotlist, ReplyTo, Reply)
  else if Command = 'max_ignorelist' then
    ShowVarRemote(Command, Max_Ignorelist, ReplyTo, Reply)
  else if Command = 'max_clones' then
    ShowVarRemote(Command, Max_Clones, ReplyTo, Reply)
  else if Command = 'memory_limit' then
    ShowVarRemote(Command, Memory_Limit div 1048576, ReplyTo, Reply)
  else if Command = 'def_search_results' then
    ShowVarRemote(Command, DefSearchResults, ReplyTo, Reply)
  else if Command = 'max_remote_search_results' then
    ShowVarRemote(Command, MaxRemoteSearchResults, ReplyTo, Reply)
  else if Command = 'max_search_results' then
    ShowVarRemote(Command, MaxSearchResults, ReplyTo, Reply)
  else if Command = 'max_browse_results' then
    ShowVarRemote(Command, MaxBrowseResults, ReplyTo, Reply)
  else if Command = 'max_remote_browse_results' then
    ShowVarRemote(Command, MaxRemoteBrowse, ReplyTo, Reply)
  else if Command = 'disable_remote_search' then
    ShowVarRemote(Command, DisableRemoteSearch, ReplyTo, Reply)
  else if Command = 'allow_create_channels' then
    ShowVarRemote(Command, Allow_Create_Channels, ReplyTo, Reply)
  else if Command = 'max_channels' then
    ShowVarRemote(Command, Max_Channels, ReplyTo, Reply)
  else if Command = 'max_channels_total' then
    ShowVarRemote(Command, Max_Channels_Total, ReplyTo, Reply)
  else if Command = 'block_cqex_chat' then
    ShowVarRemote(Command, Block_Cqex_Chat, ReplyTo, Reply)
  else if Command = 'winmx_block' then
    ShowVarRemote(Command, Blocked_Clients[softWinMXNormal], ReplyTo, Reply)
  else if Command = 'winmxj_block' then
    ShowVarRemote(Command, Blocked_Clients[softWinMXJap], ReplyTo, Reply)
  else if Command = 'winmx_detect' then
    ShowVarRemote(Command, Blocked_Clients[softWinMXHidden], ReplyTo, Reply)
  else if Command = 'timeout_login' then
    ShowVarRemote(Command, TimeOut_Login div 1000, ReplyTo, Reply)
  else if Command = 'max_searches_pm' then
    ShowVarRemote(Command, Flood_Max_Searches, ReplyTo, Reply)
  else if Command = 'max_cpu_usage' then
    ShowVarRemote(Command, Cpu_Usage, ReplyTo, Reply)
  else if Command = 'max_cpu_disable' then
    ShowVarRemote(Command, Cpu_Disable, ReplyTo, Reply)
  else if Command = 'allow_share' then
    ShowVarRemote(Command, Allow_Share, ReplyTo, Reply)
  else if Command = 'share_nomodem' then
    ShowVarRemote(Command, Share_Nomodem, ReplyTo, Reply)
  else if Command = 'max_share' then
    ShowVarRemote(Command, MaxShare, ReplyTo, Reply)
  else if Command = 'min_share' then
    ShowVarRemote(Command, MinShare, ReplyTo, Reply)
  else if Command = 'min_share_size' then
    ShowVarRemote(Command, MinShare_Size div MegaByte, ReplyTo, Reply)
  else if Command = 'min_share_only10' then
    ShowVarRemote(Command, MinShare_Only10, ReplyTo, Reply)
  else if Command = 'min_share_kickchat' then
    ShowVarRemote(Command, MinShare_Kickchat, ReplyTo, Reply)
  else if Command = 'min_share_fullonly' then
    ShowVarRemote(Command, MinShare_Fullonly, ReplyTo, Reply)
  else if Command = 'min_share_bantime' then
    ShowVarRemote(Command, MinShare_Bantime div 60, ReplyTo, Reply)
  else if Command = 'min_share_banip' then
    ShowVarRemote(Command, MinShare_Banip, ReplyTo, Reply)
  else if Command = 'min_share_delay' then
    ShowVarRemote(Command, MinShare_Delay div 60000, ReplyTo, Reply)
  else if Command = 'min_share_ban' then
    ShowVarRemote(Command, MinShare_Ban, ReplyTo, Reply)
  else if Command = 'min_filename' then
    ShowVarRemote(Command, MinFileName, ReplyTo, Reply)
  else if Command = 'min_duration' then
    ShowVarRemote(Command, MinDuration, ReplyTo, Reply)
  else if Command = 'max_share_total' then
    ShowVarRemote(Command, MaxShare_Total, ReplyTo, Reply)
  else if Command = 'max_share_audio' then
    ShowVarRemote(Command, MaxShare_Audio, ReplyTo, Reply)
  else if Command = 'max_share_video' then
    ShowVarRemote(Command, MaxShare_Video, ReplyTo, Reply)
  else if Command = 'max_share_image' then
    ShowVarRemote(Command, MaxShare_Image, ReplyTo, Reply)
  else if Command = 'max_share_app' then
    ShowVarRemote(Command, MaxShare_App, ReplyTo, Reply)
  else if Command = 'max_share_cd' then
    ShowVarRemote(Command, MaxShare_Cd, ReplyTo, Reply)
  else if Command = 'max_share_text' then
    ShowVarRemote(Command, MaxShare_Text, ReplyTo, Reply)
  else if Command = 'max_share_mp3' then
    ShowVarRemote(Command, MaxShare_Mp3, ReplyTo, Reply)
  else if Command = 'min_filesize_audio' then
    ShowVarRemote(Command, MinFileSize_Audio, ReplyTo, Reply)
  else if Command = 'max_filesize_audio' then
    ShowVarRemote(Command, MaxFileSize_Audio, ReplyTo, Reply)
  else if Command = 'min_filesize_video' then
    ShowVarRemote(Command, MinFileSize_Video, ReplyTo, Reply)
  else if Command = 'max_filesize_video' then
    ShowVarRemote(Command, MaxFileSize_Video, ReplyTo, Reply)
  else if Command = 'min_filesize_image' then
    ShowVarRemote(Command, MinFileSize_Image, ReplyTo, Reply)
  else if Command = 'max_filesize_image' then
    ShowVarRemote(Command, MaxFileSize_Image, ReplyTo, Reply)
  else if Command = 'min_filesize_app' then
    ShowVarRemote(Command, MinFileSize_App, ReplyTo, Reply)
  else if Command = 'max_filesize_app' then
    ShowVarRemote(Command, MaxFileSize_App, ReplyTo, Reply)
  else if Command = 'min_filesize_cd' then
    ShowVarRemote(Command, MinFileSize_Cd, ReplyTo, Reply)
  else if Command = 'max_filesize_cd' then
    ShowVarRemote(Command, MaxFileSize_Cd, ReplyTo, Reply)
  else if Command = 'min_filesize_text' then
    ShowVarRemote(Command, MinFileSize_Text, ReplyTo, Reply)
  else if Command = 'max_filesize_text' then
    ShowVarRemote(Command, MaxFileSize_Text, ReplyTo, Reply)
  else if Command = 'min_filesize_mp3' then
    ShowVarRemote(Command, MinFileSize_Mp3, ReplyTo, Reply)
  else if Command = 'max_filesize_mp3' then
    ShowVarRemote(Command, MaxFileSize_Mp3, ReplyTo, Reply)
  else if Command = 'allow_link' then
    ShowVarRemote(Command, Allow_Link, ReplyTo, Reply)
  else if Command = 'drop_search_results' then
    ShowVarRemote(Command, Search_Noforward_Results, ReplyTo, Reply)
  else if Command = 'drop_search_requests' then
    ShowVarRemote(Command, Search_Noforward_Requests, ReplyTo, Reply)
  else if Command = 'drop_browse_results' then
    ShowVarRemote(Command, Browse_Noforward_Results, ReplyTo, Reply)
  else if Command = 'drop_browse_requests' then
    ShowVarRemote(Command, Browse_Noforward_Requests, ReplyTo, Reply)
  else if Command = 'timeout_remote_search' then
    ShowVarRemote(Command, TimeOut_Remote_Search div 1000, ReplyTo, Reply)
  else if Command = 'share_error_inform' then
    ShowVarRemote(Command, ShareInform, ReplyTo, Reply)
  else if Command = 'max_users_per_minute' then
    ShowVarRemote(Command, Max_Users_Per_Minute, ReplyTo, Reply)
  else if Command = 'redirect_cqex' then
    ShowVarRemote(Command, Redirect_Cqex, ReplyTo, Reply)
  else if Command = 'network_hub' then
    ShowVarRemote(Command, Network_Hub, ReplyTo, Reply)
  else if Command = 'hub_syncreg' then
    ShowVarRemote(Command, Hub_Syncreg, ReplyTo, Reply)
  else if Command = 'hub_syncban' then
    ShowVarRemote(Command, Hub_Syncban, ReplyTo, Reply)
  else if Command = 'hub_syncblock' then
    ShowVarRemote(Command, Hub_SyncBlock, ReplyTo, Reply)
  else if Command = 'flood_enable' then
    ShowVarRemote(Command, Flood_Enable, ReplyTo, Reply)
  else if Command = 'prevent_shouting' then
    ShowVarRemote(Command, Prevent_Shouting, ReplyTo, Reply)
  else if Command = 'autolink_only1' then
    ShowVarRemote(Command, AutoLink_Only1, ReplyTo, Reply)
  else if Command = 'max_servers_enabled' then
    ShowVarRemote(Command, Max_Servers_Enabled, ReplyTo, Reply)
  else if Command = 'max_servers' then
    ShowVarRemote(Command, Max_Servers, ReplyTo, Reply)
  else if Command = 'auto_startup' then
    ShowStartupRemote(Command, ReplyTo, Reply)
  else if Command = 'searchblock_chkfiles' then
    ShowVarRemote(Command, SearchBlock_ChkFiles, ReplyTo, Reply)
  else if Command = 'searchblock_chksize' then
    ShowVarRemote(Command, SearchBlock_ChkSize, ReplyTo, Reply)
  else if Command = 'searchblock_files' then
    ShowVarRemote(Command, SearchBlock_Files, ReplyTo, Reply)
  else if Command = 'searchblock_size' then
    ShowVarRemote(Command, SearchBlock_Size div MegaByte, ReplyTo, Reply)
  else if Command = 'searchblock_hard' then
    ShowVarRemote(Command, SearchBlock_Hard, ReplyTo, Reply)
  else if Command = 'domblock_chkfiles' then
    ShowVarRemote(Command, DomBlock_ChkFiles, ReplyTo, Reply)
  else if Command = 'domblock_chksize' then
    ShowVarRemote(Command, DomBlock_ChkSize, ReplyTo, Reply)
  else if Command = 'domblock_files' then
    ShowVarRemote(Command, DomBlock_Files, ReplyTo, Reply)
  else if Command = 'domblock_size' then
    ShowVarRemote(Command, DomBlock_Size div MegaByte, ReplyTo, Reply)
  else if Command = 'domblock_hard' then
    ShowVarRemote(Command, DomBlock_Hard, ReplyTo, Reply)
  else
    ReplyTo.Server.Exec(MSG_SRV_REMOTE_VAR_REPLY, User.UserName + ' ' + Reply +
      ' ' + ServerName_T + ' ' + GetLangT(LNG_NOVAR));
end;

procedure ListAllConfigRemote(ReplyTo: POnlineUser; Reply: string);
var
  I: Integer;
begin
  for I := 0 to DB_Vars.Count - 1 do
    ListConfigRemote(DB_Vars.Strings[I], ReplyTo, Reply);
end;

procedure ShowVar(Command: string; Value: string); overload;
begin
  Error(Command + ' = ' + Value, True);
end;

procedure ShowVar(Command: string; Value: Integer); overload;
begin
  ShowVar(Command, IntToStr(Value));
end;

procedure ShowVar(Command: string; Value: Int64); overload;
begin
  ShowVar(Command, IntToStr(Value));
end;

procedure ShowVar(Command: string; Value: Boolean); overload;
begin
  if Value then
    ShowVar(Command, 'yes')
  else
    ShowVar(Command, 'no');
end;

procedure ShowVar(Command: string; Value: TAllowLinkType); overload;
begin
  if Value = linkAll then
    ShowVar(Command, 'all')
  else if Value = linkNone then
    ShowVar(Command, 'none')
  else if Value = linkCustom then
    ShowVar(Command, 'custom')
  else
    ShowVar(Command, 'list');
end;

procedure ShowStartup(Command: string);
var
  Reg: TRegistry;
  B: Boolean;
  Str: string;
begin
  Reg := TRegistry.Create;
  B := False;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run', True);
    Str := Reg.ReadString('SlavaNap');
    if Str <> '' then
      B := True;
  except
  end;
  Reg.Free;

  if B then
    ShowVar(Command, 'yes')
  else
    ShowVar(Command, 'no');
end;

procedure ListConfig(Command: string);
begin
  if Command = 'registered_only' then
    ShowVar(Command, Registered_Only)
  else if Command = 'allow_register' then
    ShowVar(Command, Allow_Register)
  else if Command = 'max_users' then
    ShowVar(Command, Max_Users)
  else if Command = 'stats_delay' then
    ShowVar(Command, Stats_Delay div 1000)
  else if Command = 'max_hotlist' then
    ShowVar(Command, Max_Hotlist)
  else if Command = 'max_ignorelist' then
    ShowVar(Command, Max_Ignorelist)
  else if Command = 'max_clones' then
    ShowVar(Command, Max_Clones)
  else if Command = 'memory_limit' then
    ShowVar(Command, Memory_Limit div 1048576)
  else if Command = 'def_search_results' then
    ShowVar(Command, DefSearchResults)
  else if Command = 'max_remote_search_results' then
    ShowVar(Command, MaxRemoteSearchResults)
  else if Command = 'max_search_results' then
    ShowVar(Command, MaxSearchResults)
  else if Command = 'max_browse_results' then
    ShowVar(Command, MaxBrowseResults)
  else if Command = 'max_remote_browse_results' then
    ShowVar(Command, MaxRemoteBrowse)
  else if Command = 'disable_remote_search' then
    ShowVar(Command, DisableRemoteSearch)
  else if Command = 'allow_create_channels' then
    ShowVar(Command, Allow_Create_Channels)
  else if Command = 'max_channels' then
    ShowVar(Command, Max_Channels)
  else if Command = 'max_channels_total' then
    ShowVar(Command, Max_Channels_Total)
  else if Command = 'block_cqex_chat' then
    ShowVar(Command, Block_Cqex_Chat)
  else if Command = 'winmx_block' then
    ShowVar(Command, Blocked_Clients[softWinMXNormal])
  else if Command = 'winmxj_block' then
    ShowVar(Command, Blocked_Clients[softWinMXJap])
  else if Command = 'winmx_detect' then
    ShowVar(Command, Blocked_Clients[softWinMXHidden])
  else if Command = 'timeout_login' then
    ShowVar(Command, TimeOut_Login div 1000)
  else if Command = 'max_searches_pm' then
    ShowVar(Command, Flood_Max_Searches)
  else if Command = 'max_cpu_usage' then
    ShowVar(Command, Cpu_Usage)
  else if Command = 'max_cpu_disable' then
    ShowVar(Command, Cpu_Disable)
  else if Command = 'allow_share' then
    ShowVar(Command, Allow_Share)
  else if Command = 'share_nomodem' then
    ShowVar(Command, Share_Nomodem)
  else if Command = 'max_share' then
    ShowVar(Command, MaxShare)
  else if Command = 'min_share' then
    ShowVar(Command, MinShare)
  else if Command = 'min_share_size' then
    ShowVar(Command, MinShare_Size div MegaByte)
  else if Command = 'min_share_only10' then
    ShowVar(Command, MinShare_Only10)
  else if Command = 'min_share_kickchat' then
    ShowVar(Command, MinShare_Kickchat)
  else if Command = 'min_share_fullonly' then
    ShowVar(Command, MinShare_Fullonly)
  else if Command = 'min_share_bantime' then
    ShowVar(Command, MinShare_Bantime div 60)
  else if Command = 'min_share_banip' then
    ShowVar(Command, MinShare_Banip)
  else if Command = 'min_share_delay' then
    ShowVar(Command, MinShare_Delay div 60000)
  else if Command = 'min_share_ban' then
    ShowVar(Command, MinShare_Ban)
  else if Command = 'min_filename' then
    ShowVar(Command, MinFileName)
  else if Command = 'min_duration' then
    ShowVar(Command, MinDuration)
  else if Command = 'max_share_total' then
    ShowVar(Command, MaxShare_Total)
  else if Command = 'max_share_audio' then
    ShowVar(Command, MaxShare_Audio)
  else if Command = 'max_share_video' then
    ShowVar(Command, MaxShare_Video)
  else if Command = 'max_share_image' then
    ShowVar(Command, MaxShare_Image)
  else if Command = 'max_share_app' then
    ShowVar(Command, MaxShare_App)
  else if Command = 'max_share_cd' then
    ShowVar(Command, MaxShare_Cd)
  else if Command = 'max_share_text' then
    ShowVar(Command, MaxShare_Text)
  else if Command = 'max_share_mp3' then
    ShowVar(Command, MaxShare_Mp3)
  else if Command = 'min_filesize_audio' then
    ShowVar(Command, MinFileSize_Audio)
  else if Command = 'max_filesize_audio' then
    ShowVar(Command, MaxFileSize_Audio)
  else if Command = 'min_filesize_video' then
    ShowVar(Command, MinFileSize_Video)
  else if Command = 'max_filesize_video' then
    ShowVar(Command, MaxFileSize_Video)
  else if Command = 'min_filesize_image' then
    ShowVar(Command, MinFileSize_Image)
  else if Command = 'max_filesize_image' then
    ShowVar(Command, MaxFileSize_Image)
  else if Command = 'min_filesize_app' then
    ShowVar(Command, MinFileSize_App)
  else if Command = 'max_filesize_app' then
    ShowVar(Command, MaxFileSize_App)
  else if Command = 'min_filesize_cd' then
    ShowVar(Command, MinFileSize_Cd)
  else if Command = 'max_filesize_cd' then
    ShowVar(Command, MaxFileSize_Cd)
  else if Command = 'min_filesize_text' then
    ShowVar(Command, MinFileSize_Text)
  else if Command = 'max_filesize_text' then
    ShowVar(Command, MaxFileSize_Text)
  else if Command = 'min_filesize_mp3' then
    ShowVar(Command, MinFileSize_Mp3)
  else if Command = 'max_filesize_mp3' then
    ShowVar(Command, MaxFileSize_Mp3)
  else if Command = 'allow_link' then
    ShowVar(Command, Allow_Link)
  else if Command = 'drop_search_results' then
    ShowVar(Command, Search_Noforward_Results)
  else if Command = 'drop_search_requests' then
    ShowVar(Command, Search_Noforward_Requests)
  else if Command = 'drop_browse_results' then
    ShowVar(Command, Browse_Noforward_Results)
  else if Command = 'drop_browse_requests' then
    ShowVar(Command, Browse_Noforward_Requests)
  else if Command = 'timeout_remote_search' then
    ShowVar(Command, TimeOut_Remote_Search div 1000)
  else if Command = 'share_error_inform' then
    ShowVar(Command, ShareInform)
  else if Command = 'max_users_per_minute' then
    ShowVar(Command, Max_Users_Per_Minute)
  else if Command = 'redirect_cqex' then
    ShowVar(Command, Redirect_Cqex)
  else if Command = 'network_hub' then
    ShowVar(Command, Network_Hub)
  else if Command = 'hub_syncreg' then
    ShowVar(Command, Hub_Syncreg)
  else if Command = 'hub_syncban' then
    ShowVar(Command, Hub_Syncban)
  else if Command = 'hub_syncblock' then
    ShowVar(Command, Hub_SyncBlock)
  else if Command = 'flood_enable' then
    ShowVar(Command, Flood_Enable)
  else if Command = 'prevent_shouting' then
    ShowVar(Command, Prevent_Shouting)
  else if Command = 'autolink_only1' then
    ShowVar(Command, AutoLink_Only1)
  else if Command = 'max_servers_enabled' then
    ShowVar(Command, Max_Servers_Enabled)
  else if Command = 'max_servers' then
    ShowVar(Command, Max_Servers)
  else if Command = 'auto_startup' then
    ShowStartup(Command)
  else if Command = 'searchblock_chkfiles' then
    ShowVar(Command, SearchBlock_ChkFiles)
  else if Command = 'searchblock_chksize' then
    ShowVar(Command, SearchBlock_ChkSize)
  else if Command = 'searchblock_files' theN
    ShowVar(Command, SearchBlock_Files)
  else if Command = 'searchblock_size' then
    ShowVar(Command, SearchBlock_Size div MegaByte)
  else if Command = 'searchblock_hard' then
    ShowVar(Command, SearchBlock_Hard)
  else if Command = 'domblock_chkfiles' then
    ShowVar(Command, DomBlock_ChkFiles)
  else if Command = 'domblock_chksize' then
    ShowVar(Command, DomBlock_ChkSize)
  else if Command = 'domblock_files' then
    ShowVar(Command, DomBlock_Files)
  else if Command = 'domblock_size' then
    ShowVar(Command, DomBlock_Size div MegaByte)
  else if Command = 'domblock_hard' then
    ShowVar(Command, DomBlock_Hard)
  else
    Error(GetLangT(LNG_NOVAR), True);
end;

procedure ListAllConfig;
var
  I: Integer;
begin
  for I := 0 to DB_Vars.Count - 1 do
    ListConfig(DB_Vars.Strings[I]);
end;

function SetStartup(var Variable: Boolean): Boolean;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Run', True);
    if Variable then
      Reg.WriteString('SlavaNap', Application.ExeName + ' -hide')
    else
      Reg.DeleteValue('SlavaNap');
  except
  end;
  Reg.Free;
  Result := True;
end;

function SetBool(var Variable: Boolean; Value: Boolean): Boolean;
begin
  if Variable = Value then
    Result := False
  else
  begin
    Variable := Value;
    Result := True;
  end;
end;

function SetInt(var Variable: Integer; Min, Max, Value: Integer): Boolean;
begin
  if (Variable = Value) or (Value < Min) or (Value > Max) then
    Result := False
  else
  begin
    Variable := Value;
    Result := True;
  end;
end;

function SetCardinal(var Variable: Cardinal;
  Min, Max, Value: Cardinal): Boolean;
begin
  if (Variable = Value) or (Value < Min) or (Value > Max) then
    Result := False
  else
  begin
    Variable := Value;
    Result := True;
  end;
end;

function SetInt64(var Variable: Int64; Min, Max, Value: Int64): Boolean;
begin
  if (Variable = Value) or (Value < Min) or (Value > Max) then
    Result := False
  else
  begin
    Variable := Value;
    Result := True;
  end;
end;

function SetLink(Value: string): Boolean;
begin
  Value := LowerCase(Value);
  Result := True;
  if Value = 'all' then
    Allow_Link := linkAll
  else if Value = 'none' then
    Allow_Link := linkNone
  else if Value = 'list' then
    Allow_Link := linkList
  else if Value = 'custom' then
    Allow_Link := linkCustom
  else
    Result := False;
end;

function SetVar(User: POnlineUser; Variable, Value: string): Boolean;
var
  B, B1: Boolean;
  I: Integer;
  I64: Int64;
begin
  Result := False;
  B := Str2Bool(Value, False);
  B1 := Str2Bool(Value, True);
  I := StrToIntDef(Value, -1);
  I64 := StrToInt64Def(Value, -1);
  if Variable = 'allow_link' then
  begin
    if Allow_Link = linkCustom then
      if AnsiLowerCase(User^.UserName) <> AnsiLowerCase(Cons_Reg_User) then
      begin
        if not (userHideErrors in User^.State) then
          Exec(User, MSG_SERVER_NOSUCH, GetLangT(LNG_ACCESS));
        Result := True;
        Exit;
      end;
    Result := SetLink(Value);
  end;
  if B = B1 then // Boolean Is ok
  begin
    if Variable = 'max_cpu_disable' then
    begin
      if not Cpu_Disable then
        if AnsiLowerCase(User^.UserName) <> AnsiLowerCase(Cons_Reg_User) then
        begin
          if not (userHideErrors in User^.State) then
            Exec(User, MSG_SERVER_NOSUCH, GetLangT(LNG_ACCESS));
          Result := True;
          Exit;
        end;
      Result := SetBool(Cpu_Disable, B);
    end;
    if Variable = 'registered_only' then
      if not (Network_Hub and B) then
        Result := SetBool(Registered_Only, B)
      else if Variable = 'allow_register' then
        Result := SetBool(Allow_Register, B)
      else if Variable = 'allow_create_channels' then
        Result := SetBool(Allow_Create_Channels, B)
      else if Variable = 'block_cqex_chat' then
        Result := SetBool(Block_Cqex_Chat, B)
      else if Variable = 'winmx_block' then
        Result := SetBool(Blocked_Clients[softWinMXNormal], B)
      else if Variable = 'winmxj_block' then
        Result := SetBool(Blocked_Clients[softWinMXJap], B)
      else if Variable = 'winmx_detect' then
        Result := SetBool(Blocked_Clients[softWinMXHidden], B)
      else if Variable = 'allow_share' then
        Result := SetBool(Allow_Share, B)
      else if Variable = 'share_nomodem' then
        Result := SetBool(Share_Nomodem, B)
      else if Variable = 'min_share_ban' then
        Result := SetBool(MinShare_Ban, B)
      else if Variable = 'min_share_banip' then
        Result := SetBool(MinShare_Banip, B)
      else if Variable = 'min_share_fullonly' then
        Result := SetBool(MinShare_Fullonly, B)
      else if Variable = 'min_share_only10' then
        Result := SetBool(MinShare_Only10, B)
      else if Variable = 'min_share_kickchat' then
        Result := SetBool(MinShare_Kickchat, B)
      else if Variable = 'drop_search_results' then
        Result := SetBool(Search_Noforward_Results, B)
      else if Variable = 'drop_search_requests' then
        Result := SetBool(Search_Noforward_Requests, B)
      else if Variable = 'drop_browse_results' then
        Result := SetBool(Browse_Noforward_Results, B)
      else if Variable = 'drop_browse_requests' then
        Result := SetBool(Browse_Noforward_Requests, B)
      else if Variable = 'disable_remote_search' then
        Result := SetBool(DisableRemoteSearch, B)
      else if Variable = 'share_error_inform' then
        Result := SetBool(ShareInform, B)
      else if Variable = 'redirect_cqex' then
        Result := SetBool(Redirect_Cqex, B)
      else if Variable = 'flood_enable' then
        Result := SetBool(Flood_Enable, B)
      else if Variable = 'prevent_shouting' then
        Result := SetBool(Prevent_Shouting, B)
      else if Variable = 'autolink_only1' then
        Result := SetBool(AutoLink_Only1, B)
      else if Variable = 'hub_syncreg' then
        Result := SetBool(Hub_Syncreg, B)
      else if Variable = 'hub_syncban' then
        Result := SetBool(Hub_Syncban, B)
      else if Variable = 'hub_syncblock' then
        Result := SetBool(Hub_SyncBlock, B)
      else if Variable = 'auto_startup' then
        Result := SetStartup(B)
      else if Variable = 'max_servers_enabled' then
        Result := SetBool(Max_Servers_Enabled, B)
      else if Variable = 'searchblock_chkfiles' then
        Result := SetBool(SearchBlock_ChkFiles, B)
      else if Variable = 'searchblock_chksize' then
        Result := SetBool(SearchBlock_ChkSize, B)
      else if Variable = 'searchblock_hard' then
        Result := SetBool(SearchBlock_Hard, B)
      else if Variable = 'domblock_chkfiles' then
        Result := SetBool(DomBlock_ChkFiles, B)
      else if Variable = 'domblock_chksize' then
        Result := SetBool(DomBlock_ChkSize, B)
      else if Variable = 'domblock_hard' then
        Result := SetBool(DomBlock_Hard, B);
  end;
  if I <> -1 then // Integer Is ok
  begin
    if Variable = 'max_users' then
      Result := SetInt(Max_Users, 0, 65535, I)
    else if Variable = 'stats_delay' then
      Result := SetCardinal(Stats_Delay, 15000, 300000, I * 1000)
    else if Variable = 'max_hotlist' then
      Result := SetInt(Max_Hotlist, 0, 256, I)
    else if Variable = 'max_ignorelist' then
      Result := SetInt(Max_Ignorelist, 0, 256, I)
    else if Variable = 'max_clones' then
      Result := SetInt(Max_Clones, 0, 256, I)
    else if Variable = 'memory_limit' then
      Result := SetInt(Memory_Limit, 0, MaxInt, I * 1048576)
    else if Variable = 'max_cpu_usage' then
      Result := SetInt(Cpu_Usage, 0, MaxWord, I)
    else if Variable = 'def_search_results' then
      Result := SetInt(DefSearchResults, 1, MaxWord, I)
    else if Variable = 'max_search_results' then
      Result := SetInt(MaxSearchResults, 1, MaxWord, I)
    else if Variable = 'max_browse_results' then
      Result := SetInt(MaxBrowseResults, 0, MaxWord, I)
    else if Variable = 'max_remote_browse_results' then
      Result := SetInt(MaxRemoteBrowse, 0, MaxWord, I)
    else if Variable = 'max_remote_search_results' then
      Result := SetInt(MaxRemoteSearchResults, 1, MaxWord, I)
    else if Variable = 'max_searches_pm' then
      Result := SetInt(Flood_Max_Searches, 1, 20, I)
    else if Variable = 'max_channels' then
      Result := SetInt(Max_Channels, 0, 15, I)
    else if Variable = 'max_channels_total' then
      Result := SetInt(Max_Channels_Total, 0, 1023, I)
    else if Variable = 'timeout_login' then
      Result := SetCardinal(TimeOut_Login, 10000, 300000, I * 1000)
    else if Variable = 'max_share' then
      Result := SetInt(MaxShare, 0, MaxWord, I)
    else if Variable = 'min_share' then
      Result := SetInt(MinShare, 0, MaxShare, I)
    else if Variable = 'min_filename' then
      Result := SetInt(MinFileName, 0, 256, I)
    else if Variable = 'min_duration' then
      Result := SetInt(MinDuration, 0, MaxWord, I)
    else if Variable = 'max_share_audio' then
      Result := SetInt(MaxShare_Audio, 0, MaxWord, I)
    else if Variable = 'max_share_video' then
      Result := SetInt(MaxShare_Video, 0, MaxWord, I)
    else if Variable = 'max_share_image' then
      Result := SetInt(MaxShare_Image, 0, MaxWord, I)
    else if Variable = 'max_share_app' then
      Result := SetInt(MaxShare_App, 0, MaxWord, I)
    else if Variable = 'max_share_cd' then
      Result := SetInt(MaxShare_Cd, 0, MaxWord, I)
    else if Variable = 'max_share_text' then
      Result := SetInt(MaxShare_Text, 0, MaxWord, I)
    else if Variable = 'max_share_mp3' then
      Result := SetInt(MaxShare_Mp3, 0, MaxWord, I)
    else if Variable = 'min_share_delay' then
      Result := SetCardinal(MinShare_Delay, 0, 60 * 60000, I * 60000)
    else if Variable = 'min_share_bantime' then
      Result := SetInt(MinShare_Bantime, 60, 60 * 1440, I * 60)
    else if Variable = 'timeout_remote_search' then
      Result := SetCardinal(TimeOut_Remote_Search, 30000, 300000, I * 1000)
    else if Variable = 'max_users_per_minute' then
      Result := SetInt(Max_Users_Per_Minute, 0, 65535, I)
    else if Variable = 'max_servers' then
      Result := SetInt(Max_Servers, 1, 50, I)
    else if Variable = 'searchblock_files' then
      Result := SetInt(SearchBlock_Files, 0, 10000, I)
    else if Variable = 'domblock_files' then
      Result := SetInt(DomBlock_Files, 0, 10000, I);
  end;
  if I64 <> -1 then
  begin
    if Variable = 'max_share_total' then
      Result := SetInt64(MaxShare_Total, 0, MaxInt, I64)
    else if Variable = 'min_filesize_audio' then
      Result := SetInt64(MinFileSize_Audio, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_audio' then
      Result := SetInt64(MaxFileSize_Audio, 0, FileSizeLimit, I64)
    else if Variable = 'min_filesize_video' then
      Result := SetInt64(MinFileSize_Video, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_video' then
      Result := SetInt64(MaxFileSize_Video, 0, FileSizeLimit, I64)
    else if Variable = 'min_filesize_image' then
      Result := SetInt64(MinFileSize_Image, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_image' then
      Result := SetInt64(MaxFileSize_Image, 0, FileSizeLimit, I64)
    else if Variable = 'min_filesize_app' then
      Result := SetInt64(MinFileSize_App, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_app' then
      Result := SetInt64(MaxFileSize_App, 0, FileSizeLimit, I64)
    else if Variable = 'min_filesize_cd' then
      Result := SetInt64(MinFileSize_Cd, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_cd' then
      Result := SetInt64(MaxFileSize_Cd, 0, FileSizeLimit, I64)
    else if Variable = 'min_filesize_text' then
      Result := SetInt64(MinFileSize_Text, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_text' then
      Result := SetInt64(MaxFileSize_Text, 0, FileSizeLimit, I64)
    else if Variable = 'min_filesize_mp3' then
      Result := SetInt64(MinFileSize_Mp3, 0, FileSizeLimit, I64)
    else if Variable = 'max_filesize_mp3' then
      Result := SetInt64(MaxFileSize_Mp3, 0, FileSizeLimit, I64)
    else if Variable = 'min_share_size' then
      Result := SetInt64(MinShare_Size, 0, 4096 * MegaByte, I64 * MegaByte)
    else if Variable = 'searchblock_size' then
      Result := SetInt64(SearchBlock_Size, 0, 1048576 * MegaByte, I64 * MegaByte)
    else if Variable = 'domblock_size' then
      Result := SetInt64(DomBlock_Size, 0, 1048576 * MegaByte, I64 * MegaByte);
  end;
end;

procedure SetConfigRemote(User: POnlineUser; Command: string);
var
  I: Integer;
begin
  I := Pos('=', Command);
  if I > 0 then
    Command[I] := ' ';
  SplitString(Command, HList);
  if HList.Count = 1 then // List vars
  begin
    ListAllConfigRemote(User, HList.Strings[0]);
    Exit;
  end;
  HList.Strings[1] := LowerCase(HList.Strings[1]);
  if HList.Count = 2 then // List var
  begin
    ListConfigRemote(HList.Strings[1], User, HList.Strings[0]);
    Exit;
  end;
  if User^.Level < napUserElite then
  begin
    User.Server.Exec(MSG_SRV_REMOTE_VAR_REPLY, User.UserName + ' ' +
      HList.Strings[0] + ' ' + ServerName_T + ' ' + GetLangT(LNG_ACCESS));
    ;
    Exit;
  end;
  if SetVar(User, HList.Strings[1], HList.Strings[2]) then
  begin
    Wallop(MSG_SERVER_NOSUCH, wallopVar, GetLangT(LNG_CHANGEVAR, User^.UserName,
      HList.Strings[1], HList.Strings[2]), True);
    User.Server.Exec(MSG_SRV_REMOTE_VAR_REPLY, User.UserName + ' ' +
      HList.Strings[0] + ' ' + GetLangT(LNG_CHANGEVAR, ServerName_T,
      HList.Strings[1], HList.Strings[2]));
  end
  else
    User.Server.Exec(MSG_SRV_REMOTE_VAR_REPLY, User.UserName + ' ' +
      HList.Strings[0] + ' ' + ServerName_T + ' ' + GetLangT(LNG_BADVAR));
end;

procedure SetConfig(User: POnlineUser; Command: string);
var
  I: Integer;
begin
  I := Pos('=', Command);
  if I > 0 then
    Command[I] := ' ';
  SplitString(Command, HList);
  if HList.Count = 0 then // List vars
  begin
    ListAllConfig;
    Exit;
  end;
  HList.Strings[0] := LowerCase(HList.Strings[0]);
  if HList.Count = 1 then // List var
  begin
    ListConfig(Command);
    Exit;
  end;
  if User^.Level < napUserElite then
  begin
    PermissionDenied('', True);
    Exit;
  end;
  if SetVar(User, HList.Strings[0], HList.Strings[1]) then
    Wallop(MSG_SERVER_NOSUCH, wallopVar, GetLangT(LNG_CHANGEVAR, User^.UserName,
      HList.Strings[0], HList.Strings[1]), True)
  else
    Error(GetLangT(LNG_BADVAR), True);
end;

procedure InitVars;
begin
  DB_Vars.Add('registered_only');
  DB_Vars.Add('allow_register');
  DB_Vars.Add('max_users'); // Max_Users
  DB_Vars.Add('stats_delay'); // Stats_Delay div 1000
  DB_Vars.Add('max_hotlist');
  DB_Vars.Add('max_ignorelist');
  DB_Vars.Add('max_clones');
  DB_Vars.Add('memory_limit');
  DB_Vars.Add('network_hub');
  DB_Vars.Add('hub_syncreg'); // sync registered list
  DB_Vars.Add('hub_syncban'); // sync ban list
  DB_Vars.Add('hub_syncblock'); // sync blocked files list
  DB_Vars.Add('max_cpu_usage'); // Cpu_Usage
  DB_Vars.Add('max_cpu_disable'); // Disable Cpu_Usage
  DB_Vars.Add('def_search_results'); // DefSearchResults
  DB_Vars.Add('max_search_results'); // MaxSearchResults
  DB_Vars.Add('max_browse_results'); // MaxBrowseResults
  DB_Vars.Add('max_remote_browse_results'); // MaxRemoteBrowse
  DB_Vars.Add('max_remote_search_results'); // MaxRemoteSearchResults
  DB_Vars.Add('disable_remote_search'); // DisableRemoteSearch
  DB_Vars.Add('max_searches_pm'); // MaxSearchespm
  DB_Vars.Add('allow_create_channels');
  DB_Vars.Add('max_channels');
  DB_Vars.Add('max_channels_total');
  DB_Vars.Add('block_cqex_chat');
  DB_Vars.Add('winmx_block');
  DB_Vars.Add('winmxj_block');
  DB_Vars.Add('winmx_detect');
  DB_Vars.Add('timeout_login'); // TimeOut_Login div 1000
  DB_Vars.Add('allow_share');
  DB_Vars.Add('share_nomodem');
  DB_Vars.Add('max_share'); // MaxShare
  DB_Vars.Add('min_share'); // MinShare
  DB_Vars.Add('min_share_size'); // MinShare_Size
  DB_Vars.Add('min_share_only10'); // MinShare_Only10
  DB_Vars.Add('min_share_kickchat'); // MinShare_Kickchat
  DB_Vars.Add('min_share_delay'); // MinShare_Delay
  DB_Vars.Add('min_share_ban'); // MinShare_Ban
  DB_Vars.Add('min_share_banip'); // MinShare_Banip
  DB_Vars.Add('min_share_bantime'); // MinShare_Bantime
  DB_Vars.Add('min_share_fullonly'); // MinShare_Fullonly
  DB_Vars.Add('min_filename'); // MinFileName
  DB_Vars.Add('min_duration'); // MinDuration
  DB_Vars.Add('max_share_total'); // MaxShare_Total
  DB_Vars.Add('max_share_audio'); // MaxShare_Audio
  DB_Vars.Add('max_share_video'); // MaxShare_Video
  DB_Vars.Add('max_share_image'); // MaxShare_Image
  DB_Vars.Add('max_share_app'); // MaxShare_App
  DB_Vars.Add('max_share_cd'); // MaxShare_Cd
  DB_Vars.Add('max_share_text'); // MaxShare_Text
  DB_Vars.Add('max_share_mp3'); // MaxShare_Mp3
  DB_Vars.Add('min_filesize_audio'); // MinFileSize_Audio
  DB_Vars.Add('max_filesize_audio'); // MaxFileSize_Audio
  DB_Vars.Add('min_filesize_video'); // MinFileSize_Video
  DB_Vars.Add('max_filesize_video'); // MaxFileSize_Video
  DB_Vars.Add('min_filesize_image'); // MinFileSize_Image
  DB_Vars.Add('max_filesize_image'); // MaxFileSize_Image
  DB_Vars.Add('min_filesize_app'); // MinFileSize_App
  DB_Vars.Add('max_filesize_app'); // MaxFileSize_App
  DB_Vars.Add('min_filesize_cd'); // MinFileSize_Cd
  DB_Vars.Add('max_filesize_cd'); // MaxFileSize_Cd
  DB_Vars.Add('min_filesize_text'); // MinFileSize_Text
  DB_Vars.Add('max_filesize_text'); // MaxFileSize_Text
  DB_Vars.Add('min_filesize_mp3'); // MinFileSize_Mp3
  DB_Vars.Add('max_filesize_mp3'); // MaxFileSize_Mp3
  DB_Vars.Add('allow_link'); // Allow_Link
  DB_Vars.Add('drop_search_results'); // Search_Noforward_Results
  DB_Vars.Add('drop_search_requests'); // Search_Noforward_Requests
  DB_Vars.Add('drop_browse_results'); // Browse_Noforward_Results
  DB_Vars.Add('drop_browse_requests'); // Browse_Noforward_Requests
  DB_Vars.Add('timeout_remote_search'); // TimeOut_Remote_Search
  DB_Vars.Add('share_error_inform'); // ShareInform
  DB_Vars.Add('redirect_cqex'); // Redirect_Cqex
  DB_Vars.Add('flood_enable'); // flood protection
  DB_Vars.Add('prevent_shouting');
  DB_Vars.Add('autolink_only1'); // do not autoLink if already linked to 1 server
  DB_Vars.Add('max_users_per_minute'); // max logins per minute
  DB_Vars.Add('max_servers_enabled');
    // simultaneous server link limiting enabled
  DB_Vars.Add('max_servers'); // limit for above
  DB_Vars.Add('searchblock_chkfiles');
  DB_Vars.Add('searchblock_chksize');
  DB_Vars.Add('searchblock_files');
  DB_Vars.Add('searchblock_size');
  DB_Vars.Add('searchblock_hard');
  DB_Vars.Add('domblock_chkfiles');
  DB_Vars.Add('domblock_chksize');
  DB_Vars.Add('domblock_files');
  DB_Vars.Add('domblock_size');
  DB_Vars.Add('domblock_hard');
  DB_Vars.Sort;
end;

initialization
  begin
    DB_Vars := TMyStringList.Create;
    HList := TMyStringList.Create;
    InitVars;
  end;

finalization
  begin
    DB_Vars.Free;
    HList.Free;
  end;

end.
