{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: EditDialog

 Window for editing string

*********************************************************}
unit EditDialog;

interface

uses
  Windows, Messages, SysUtils, Classes2, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Classes;

const
  SE_NAPIGATORPASS = 0;
  SE_ADDCHANNEL = 1;
  SE_DAGSTAPASS = 2;

type
  TSlavaNapEdit = class(TForm)
    Label1: TLabel;
    Edit: TEdit;
    Btn_Ok: TButton;
    Btn_Cancel: TButton;
    procedure Btn_CancelClick(Sender: TObject);
    procedure Btn_OkClick(Sender: TObject);
    function CheckData: Boolean;
  private
    { Private declarations }
  public
    { Public declarations }
    Query: Integer;
    procedure Ask(Q: Integer);
  end;

var
  SlavaNapEdit: TSlavaNapEdit;

implementation

uses Lang, STypes, Vars, Constants, Languages;

procedure TSlavaNapEdit.Ask(Q: Integer);
begin
  Query := Q;
  case Query of
    SE_NAPIGATORPASS:
      begin
        Label1.Caption := GetLangI(LNG_EDIT_NAPIGATOR);
        Edit.Text := '';
        Edit.PasswordChar := '*';
        Btn_Ok.Caption := GetLangI(LNG_OK);
        Btn_Cancel.Caption := GetLangI(LNG_CANCEL);
      end;
    SE_DAGSTAPASS:
      begin
        Label1.Caption := GetLangI(LNG_EDIT_DAGSTA);
        Edit.Text := '';
        Edit.PasswordChar := '*';
        Btn_Ok.Caption := GetLangI(LNG_OK);
        Btn_Cancel.Caption := GetLangI(LNG_CANCEL);
      end;
    SE_ADDCHANNEL:
      begin
        Label1.Caption := GetLangI(LNG_EDIT_ADDCHANNEL);
        Edit.Text := 'channel';
        Edit.PasswordChar := #0;
        Btn_Ok.Caption := GetLangI(LNG_OK);
        Btn_Cancel.Caption := GetLangI(LNG_CANCEL);
      end;
  end;
  try
    SetFont(Self.Font);
    Show;
    Edit.SetFocus;
  except
  end;
end;

{$R *.DFM}

procedure TSlavaNapEdit.Btn_CancelClick(Sender: TObject);
begin
  Close;
end;

procedure TSlavaNapEdit.Btn_OkClick(Sender: TObject);
begin
  if not CheckData then
  try
    Edit.SetFocus;
    Exit;
  except
    Exit;
  end;
  Close;
  if not Running then Exit;
  if Cmd_List = nil then Exit;
  case Query of
    SE_NAPIGATORPASS: Cmd_List.AddDoubleCmd(MSG_CMD_SETNAPIGATORPASS, 0,
      Edit.Text, '');
    SE_DAGSTAPASS: Cmd_List.AddDoubleCmd(MSG_CMD_SETDAGSTAPASS, 0, Edit.Text,
      '');
    SE_ADDCHANNEL: Cmd_List.AddDoubleCmd(MSG_CLIENT_ADDCHANNEL, 0, Edit.Text,
      '');
  end;
end;

function TSlavaNapEdit.CheckData: Boolean;
begin
  Result := True;
  case Query of
    SE_ADDCHANNEL: Result := ChannelName(Edit.Text) <> '';
  end;
end;

end.
