/******************************************************************************/
/* SlunkCrypt, by LoRd_MuldeR <MuldeR2@GMX.de>                                */
/* This work has been released under the CC0 1.0 Universal license!           */
/******************************************************************************/

#ifndef INC_PLATFORM_H
#define INC_PLATFORM_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef _WIN32
#	include <share.h>
#	ifndef _SH_SECURE
#	define _SH_SECURE 0x80
#	endif
#endif

#if defined(_WIN32)
#	define OS_TYPE "Windows"
#elif defined(__CYGWIN__)
#	define OS_TYPE "Cygwin"
#elif defined(__linux__)
#	define OS_TYPE "Linux"
#elif defined(__FreeBSD__)
#	define OS_TYPE "FreeBSD"
#elif defined(__NetBSD__)
#	define OS_TYPE "NetBSD"
#elif defined(__OpenBSD__)
#	define OS_TYPE "OpenBSD"
#elif defined(__sun)
#	define OS_TYPE "Solaris"
#elif defined(__unix__)
#	define OS_TYPE "Unix"
#else
#	error Unknown operating system!
#endif

#if defined(__x86_64__) || defined(_M_X64)
#	define CPU_ARCH "x64"
#elif defined(__i386__) || defined(_M_IX86)
#	define CPU_ARCH "x86"
#elif defined(__aarch64__) || defined(_M_ARM64)
#	define CPU_ARCH "arm64"
#elif defined(__arm__) || defined(_M_ARM)
#	define CPU_ARCH "arm"
#else
#	error Unknown CPU architecture!
#endif

#ifdef _WIN32
#	define MAIN wmain
#	define CHR wchar_t
#	define _T(X) L##X
#	define GETENV(X) _wgetenv((X))
#	define STRLEN(X) wcslen((X))
#	define STRICMP(X,Y) _wcsicmp((X),(Y))
#	define STRNICMP(X,Y,Z) _wcsnicmp((X),(Y),(Z))
#	define STRRCHR(X,Y) wcsrchr((X),(Y))
#	define STRTOUL(X) wcstoul((X), NULL, 0)
#	define FPUTS(X,Y) fputws((X),(Y))
#	define FPRINTF(X,Y,...) fwprintf((X),(Y),__VA_ARGS__)
#	define REMOVE(X) _wremove((X))
#	define FOPEN(X,Y) _wfsopen((X),(Y),_SH_SECURE)
#	ifdef __USE_MINGW_ANSI_STDIO
#		define PRISTR "ls"
#		define PRIstr "hs"
#		define PRIwcs "ls"
#	else
#		define PRISTR "s"
#		define PRIstr "S"
#		define PRIwcs "s"
#	endif
#else
#	define MAIN main
#	define CHR char
#	define _T(X) X
#	define GETENV(X) getenv((X))
#	define STRLEN(X) strlen((X))
#	define STRICMP(X,Y) strcasecmp((X),(Y))
#	define STRNICMP(X,Y,Z) strncasecmp((X),(Y),(Z))
#	define STRRCHR(X,Y) strrchr((X),(Y))
#	define STRTOUL(X) strtoul((X), NULL, 0)
#	define FPUTS(X,Y) fputs((X),(Y))
#	define FPRINTF(X,Y,...) fprintf((X),(Y),__VA_ARGS__)
#	define REMOVE(X) remove((X))
#	define FOPEN(X,Y) fopen((X),(Y))
#	define PRISTR "s"
#	define PRIstr "s"
#	define PRIwcs "ls"
#endif

#define T(X) _T(X)

#ifdef _MSC_VER
#	define strdup(X) _strdup((X))
#endif

#endif
