﻿/******************************************************************************/
/* SlunkCrypt, by LoRd_MuldeR <MuldeR2@GMX.de>                                */
/* This work has been released under the CC0 1.0 Universal license!           */
/******************************************************************************/

using System;
using System.Configuration;

namespace com.muldersoft.slunkcrypt.gui.utils
{
    class ApplicationConfig
    {
        private readonly Lazy<KeyValueConfigurationCollection> m_settings = new Lazy<KeyValueConfigurationCollection>(InitializeSettings);

        public bool DisableBusyIndicator
        {
            get
            {
                return GetConfigValueAsBool("DisableBusyIndicator");
            }
        }

        protected string GetConfigValue(string name)
        {
            KeyValueConfigurationCollection settings = m_settings.Value;
            if (!ReferenceEquals(settings, null))
            {
                KeyValueConfigurationElement element = settings[name];
                if (!ReferenceEquals(element, null))
                {
                    string value = element.Value;
                    return string.IsNullOrWhiteSpace(value) ? string.Empty : value;
                }
            }
            return string.Empty;
        }

        protected bool GetConfigValueAsBool(string name)
        {
            string value;
            if (!string.IsNullOrWhiteSpace(value = GetConfigValue(name)))
            {
                bool result;
                if (bool.TryParse(value.Trim(), out result))
                {
                    return result;
                }
            }
            return false;
        }

        private static KeyValueConfigurationCollection InitializeSettings()
        {
            try
            {
                Configuration configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
                return configuration.AppSettings.Settings;
            }
            catch
            {
                return null;
            }
        }
    }
}
