@echo off
setlocal enabledelayedexpansion

set ECHO="%~dp0.\etc\utils\win32\cecho.exe"
if "%MSVC_PATH%"=="" (
	set "MSVC_PATH=C:\Program Files (x86)\Microsoft Visual Studio\2019\Community\VC"
)

if not exist "%MSVC_PATH%\Auxiliary\Build\vcvarsall.bat" (
	%ECHO% red "\nMSVC not found. Please check MSVC_PATH and try again^!\n"
	pause
	goto:eof
)

for %%p in (x86,x64) do (
	call "%MSVC_PATH%\Auxiliary\Build\vcvarsall.bat" %%p
	for %%c in (Release,Release_SSE2) do (
		if not "%%p::%%c" == "x64::Release_SSE2" (
			set "TEMP_NAME=!RANDOM!-!RANDOM!"
			if "%%c"=="Release_SSE2" (set "SUFFIX=sse2") else (if "%%p"=="x86" (set "SUFFIX=i686") else (set "SUFFIX=%%p"))
			%ECHO% white "\n------------------------------------------------------------------------------"
			%ECHO% white "Clean [%%p:%%c]"
			%ECHO% white "------------------------------------------------------------------------------\n"
			MSBuild.exe /property:Configuration=%%c /property:Platform=%%p /target:Clean /verbosity:normal "%~dp0\Slunk.sln"
			if not "!ERRORLEVEL!"=="0" goto:BuildFailed
			%ECHO% white "\n------------------------------------------------------------------------------"
			%ECHO% white "Instrument [%%p:%%c]"
			%ECHO% white "------------------------------------------------------------------------------\n"
			MSBuild.exe /property:Configuration=%%c /property:Platform=%%p /property:WholeProgramOptimization=PGInstrument /property:LinkTimeCodeGeneration=PGInstrument /target:Rebuild /verbosity:normal "%~dp0\Slunk.sln"
			if not "!ERRORLEVEL!"=="0" goto:BuildFailed
			%ECHO% white "\n------------------------------------------------------------------------------"
			%ECHO% white "Profiling [%%p:%%c]"
			%ECHO% white "------------------------------------------------------------------------------\n"
			"%~dp0.\etc\utils\win32\rand.exe" | "%~dp0.\etc\utils\win32\head.exe" -c 104857600 > "%TMP%\!TEMP_NAME!.dat"
			if not "%ERRORLEVEL%"=="0" goto:BuildFailed
			"%~dp0.\bin\static\slunkcrypt-cli-!SUFFIX!.exe" --encrypt pass:"KVeW9;z4$#]d9~}z>(WC?v&f" "%TMP%\!TEMP_NAME!.dat" "%TMP%\!TEMP_NAME!.enc"
			if not "!ERRORLEVEL!"=="0" goto:BuildFailed
			"%~dp0.\bin\static\slunkcrypt-cli-!SUFFIX!.exe" --decrypt pass:"KVeW9;z4$#]d9~}z>(WC?v&f" "%TMP%\!TEMP_NAME!.enc" "%TMP%\!TEMP_NAME!.out"
			if not "!ERRORLEVEL!"=="0" goto:BuildFailed
			del /F "%TMP%\!TEMP_NAME!.dat" "%TMP%\!TEMP_NAME!.enc" "%TMP%\!TEMP_NAME!.out"
			%ECHO% white "\n------------------------------------------------------------------------------"
			%ECHO% white "Re-compile [%%p:%%c]"
			%ECHO% white "------------------------------------------------------------------------------\n"
			MSBuild.exe /property:Configuration=%%c /property:Platform=%%p /property:WholeProgramOptimization=PGOptimize /property:LinkTimeCodeGeneration=PGOptimization /target:Build /verbosity:normal "%~dp0\Slunk.sln"
			if not "!ERRORLEVEL!"=="0" goto:BuildFailed
		)
	)
)

%ECHO% green "\nBuild completed successfully.\n"
pause
goto:eof

:BuildFailed
%ECHO% red "\nBuild has failed ^!^!^!\n"
pause
