#!/bin/bash
set -e
cd -- "$(dirname -- "${BASH_SOURCE[0]}")"

readonly USE_LTO=1

PLATFORM="$(uname -a)"
unset SUFFIX
if [[ "${PLATFORM}" == MINGW* || "${PLATFORM}" == CYGWIN* ]]; then
  SUFFIX=".exe"
fi

[ -e /dev/urandom ] && RANDOM_SOURCE="/dev/urandom" || RANDOM_SOURCE="/dev/random"
TMP_NAME="$(tr -dc 'a-zA-Z0-9' < ${RANDOM_SOURCE} | fold -w 12 | head -n 1)"
PGO_PATH="$(tr -dc 'a-zA-Z0-9' < ${RANDOM_SOURCE} | fold -w 12 | head -n 1)"
trap "printf \"\033[1;31m\nBuild has failed !!!\033[0m\n\n\"" ERR
trap "rm -rf /tmp/${TMP_NAME}.dat /tmp/${TMP_NAME}.enc /tmp/${TMP_NAME}.out /tmp/${PGO_PATH}" EXIT

printf "\033[1;36m\n------------------------------------------------------------------------------\033[0m\n"
printf "\033[1;36mClean\n"
printf "\033[1;36m------------------------------------------------------------------------------\033[0m\n\n"

make clean

printf "\033[1;36m\n------------------------------------------------------------------------------\033[0m\n"
printf "\033[1;36mInstrument\n"
printf "\033[1;36m------------------------------------------------------------------------------\033[0m\n\n"

make FLTO=${USE_LTO} FPGO="generate=/tmp/${PGO_PATH}" -B "$@"

printf "\033[1;36m\n------------------------------------------------------------------------------\033[0m\n"
printf "\033[1;36mProfiling\n"
printf "\033[1;36m------------------------------------------------------------------------------\033[0m\n\n"

dd bs=1024 count=102400 < ${RANDOM_SOURCE} > /tmp/${TMP_NAME}.dat
printf "\n"
PASSWRD="$(./frontend/bin/slunkcrypt${SUFFIX} --make-pw)"

./frontend/bin/slunkcrypt${SUFFIX} --encrypt pass:"${PASSWRD}" /tmp/${TMP_NAME}.dat /tmp/${TMP_NAME}.enc
./frontend/bin/slunkcrypt${SUFFIX} --decrypt pass:"${PASSWRD}" /tmp/${TMP_NAME}.enc /tmp/${TMP_NAME}.out

printf "\033[1;36m\n------------------------------------------------------------------------------\033[0m\n"
printf "\033[1;36mRe-compile\n"
printf "\033[1;36m------------------------------------------------------------------------------\033[0m\n\n"

make FLTO=${USE_LTO} FPGO="use=/tmp/${PGO_PATH}" STRIP=1 -B "$@"

printf "\033[1;32m\nBuild completed successfully.\033[0m\n\n"
