/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import jp.ac.hokudai.meme.core_smart_gs.searcher.AbstractDTWCalculator;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DTWCalculatorType1;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DTWCalculatorType2;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DistanceAndIndex;
import jp.ac.hokudai.meme.core_smart_gs.searcher.DocumentSearcher;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundIndex;
import jp.ac.hokudai.meme.core_smart_gs.searcher.ResultIndex;

public class DocumentSearcherDTW
extends DocumentSearcher {
    private static final double WARPING_LIMIT = 1.2;
    private AbstractDTWCalculator calculator_ = null;

    public DocumentSearcherDTW(int type) {
        switch (type) {
            case 2: {
                this.calculator_ = new DTWCalculatorType1();
                break;
            }
            case 3: {
                this.calculator_ = new DTWCalculatorType2();
                break;
            }
            default: {
                this.calculator_ = new DTWCalculatorType1();
            }
        }
    }

    @Override
    protected ResultIndex searchStart(double[][] dscData, int[] index) {
        int fullTextLength = dscData.length;
        int patLength = index.length;
        double[][] pattern = new double[patLength][];
        int i = 0;
        while (i < patLength) {
            pattern[i] = dscData[index[i]];
            ++i;
        }
        int uLimitL = (int)Math.ceil((double)patLength * 1.2);
        int lLimitL = (int)Math.ceil((double)patLength / 1.2);
        double[][] dtwArray = new double[patLength][uLimitL];
        ArrayList<DistanceAndIndex> dtwResList = new ArrayList<DistanceAndIndex>(fullTextLength - patLength);
        this.calculator_.makeDistTable(dscData, pattern);
        int i2 = 0;
        while (i2 < fullTextLength - uLimitL + 1) {
            DistanceAndIndex res;
            if (!this.isContain(index, i2, patLength) && (res = this.calculator_.calcDTWDist(i2, i2 + uLimitL - 1, pattern, dtwArray)).getLength() >= lLimitL) {
                dtwResList.add(res);
            }
            ++i2;
        }
        DistanceAndIndex[] resList = dtwResList.toArray(new DistanceAndIndex[0]);
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                double diff = ((DistanceAndIndex)arg0).getDistance() - ((DistanceAndIndex)arg1).getDistance();
                int res = 0;
                if (diff < 0.0) {
                    res = -1;
                } else if (diff > 0.0) {
                    res = 1;
                }
                return res;
            }
        };
        Arrays.sort(resList, comparator);
        return this.makeResultIndexes(resList);
    }

    private boolean isContain(int[] index, int i, int pLength) {
        int s1 = index[0];
        int e1 = index[index.length - 1];
        int s2 = i;
        int e2 = i + pLength - 1;
        boolean flag = true;
        return this.chkContain(s1, e1, s2, e2);
    }

    private boolean chkContain(int start1, int end1, int start2, int end2) {
        boolean flag = true;
        if (start1 < start2 && end1 < start2) {
            flag = false;
        } else if (start2 < start1 && end2 < start1) {
            flag = false;
        }
        return flag;
    }

    private ResultIndex makeResultIndexes(DistanceAndIndex[] resList) {
        ResultIndex resultIndex = new ResultIndex();
        int i = 0;
        while (i < resList.length) {
            DistanceAndIndex candidate = resList[i];
            this.chkAndAddCandidate(candidate, resultIndex);
            if (resultIndex.size() == this.maxFound_) break;
            ++i;
        }
        return resultIndex;
    }

    private void chkAndAddCandidate(DistanceAndIndex candidate, ResultIndex resultIndex) {
        boolean addFlag = true;
        Iterator iter = resultIndex.iterator();
        while (iter.hasNext()) {
            FoundIndex found = (FoundIndex)iter.next();
            int[] indexes = found.indexList_;
            if (!this.chkContain(indexes[0], indexes[indexes.length - 1], candidate.getStartIndex(), candidate.getEndIndex())) continue;
            addFlag = false;
        }
        if (addFlag) {
            FoundIndex foundIndex = new FoundIndex(candidate.getStartIndex(), candidate.getEndIndex(), candidate.getDistance());
            resultIndex.addResult(foundIndex);
        }
    }
}

