/*
 * Decompiled with CFR 0.152.
 */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;
import reasoning_web.logical.Connection;
import reasoning_web.logical.DefaultFactory;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.Factory;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.logical.GSResource;

public class RWRepository {
    protected List<GSResource> resourceBaskets;
    protected List<Connection> connections;
    protected List<ResourcePointer> pointers;
    private Factory factory = this.getFactory();
    private List<Observer> observers;

    protected RWRepository() {
        this.connections = new ArrayList<Connection>();
        this.pointers = new ArrayList<ResourcePointer>();
        this.observers = new ArrayList<Observer>();
        this.resourceBaskets = new ArrayList<GSResource>();
    }

    public void initialize() {
        this.connections.clear();
        this.pointers.clear();
    }

    protected Factory getFactory() {
        return new DefaultFactory();
    }

    public ResourcePointer getResourcePointer(RWElement element) {
        int i = 0;
        while (i < this.pointers.size()) {
            if (this.pointers.get(i).getRwElement().equals(element)) {
                return this.pointers.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isRegistered(RWElement element) {
        int i = 0;
        while (i < this.pointers.size()) {
            if (this.pointers.get(i).getRwElement().equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void createConnection(RWElement source, RWElement target, ExplanatoryNote note) {
        ResourcePointer targetPointer;
        ResourcePointer sourcePointer;
        if (!this.isRegistered(source)) {
            sourcePointer = this.factory.createResourcePointer(source);
            this.register(sourcePointer);
        } else {
            sourcePointer = this.getResourcePointer(source);
        }
        if (!this.isRegistered(target)) {
            targetPointer = this.factory.createResourcePointer(target);
            this.register(targetPointer);
        } else {
            targetPointer = this.getResourcePointer(target);
        }
        this.addConnection(sourcePointer, targetPointer, note);
    }

    public Connection getNewestConnection() {
        return this.connections.get(this.connections.size() - 1);
    }

    protected void register(ResourcePointer pointer) {
        if (!this.pointers.contains(pointer)) {
            this.pointers.add(pointer);
        }
        this.notifyChange();
    }

    private void addConnection(ResourcePointer source, ResourcePointer target, ExplanatoryNote note) {
        this.connections.add(this.factory.createConnection(source, target, note));
    }

    protected void addConnection(Connection connection) {
        this.connections.add(connection);
    }

    public void register(RWElement element) {
        ResourcePointer pointer = this.factory.createResourcePointer(element);
        this.pointers.add(pointer);
        this.notifyChange();
    }

    public boolean hasLink(RWElement element) {
        ResourcePointer pointer = this.getResourcePointer(element);
        if (pointer == null) {
            return false;
        }
        return pointer.hasLink();
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public List<ResourcePointer> getResourcePointers() {
        return this.pointers;
    }

    public List<RWElement> getDirectElements(ResourcePointer pointer) {
        if (pointer == null) {
            return null;
        }
        return pointer.getDirectLinkElements();
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public void notifyChange() {
        int i = 0;
        while (i < this.observers.size()) {
            this.observers.get(i).update();
            ++i;
        }
    }
}

