/*
 * Decompiled with CFR 0.152.
 */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;
import reasoning_web.logical.Connection;
import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.Zombie;

public class ResourcePointer {
    protected RWElement rw_element;
    protected String name = "";
    protected List<ResourcePointer> targets;
    protected List<ResourcePointer> sources;
    protected List<Connection> connections;
    private boolean isSource = true;

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    protected ResourcePointer(RWElement element) {
        this.rw_element = element;
        this.connections = new ArrayList<Connection>();
        this.targets = new ArrayList<ResourcePointer>();
        this.sources = new ArrayList<ResourcePointer>();
    }

    public List<ResourcePointer> getForwardLinkElements() {
        return this.targets;
    }

    public List<ResourcePointer> getBackLinkElements() {
        return this.sources;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public List<RWElement> getDirectLinkElements() {
        ArrayList<RWElement> elements = new ArrayList<RWElement>();
        int i = 0;
        while (i < this.targets.size()) {
            elements.add(this.targets.get(i).getRwElement());
            ++i;
        }
        i = 0;
        while (i < this.sources.size()) {
            elements.add(this.sources.get(i).getRwElement());
            ++i;
        }
        return elements;
    }

    void addConnection(Connection connection) {
        this.connections.add(connection);
    }

    public void addTarget(ResourcePointer target) {
        this.targets.add(target);
    }

    public void addSource(ResourcePointer source) {
        this.sources.add(source);
    }

    public RWElement getRwElement() {
        return this.rw_element;
    }

    public void setRwElement(RWElement rwElement) {
        this.rw_element = rwElement;
    }

    public boolean hasLink() {
        return this.connections.size() > 0;
    }

    public String getSource() throws NotMarkupException {
        throw new NotMarkupException();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasConnection() {
        return this.connections.size() > 0;
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection);
    }

    public void zombify() {
        Zombie zombie = new Zombie(this.rw_element.getURI());
        this.rw_element = zombie;
    }

    public boolean isZombified() {
        return this.rw_element instanceof Zombie;
    }
}

