/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.connection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import smart_gs.connection.ConnectionCreator;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.RegionNotify;
import smart_gs.drawing_tool.state.RegionSelectionState;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.ResourceNotify;
import smart_gs.util.ResourceSelectionMode;
import sml_editor.swingui.EditorMouseListener;

public class CreateLinkDialog
extends JDialog
implements ActionListener,
ResourceNotify,
RegionNotify,
CaretListener {
    private final int SOURCE = 0;
    private final int TARGET = 1;
    private final int TEXT_LENGTH = 20;
    private JTextField sourceField;
    private JTextField targetField;
    private JButton sourceSelect;
    private JButton targetSelect;
    private JPanel mainPanel;
    private JPanel sourcePanel;
    private JPanel targetPanel;
    private JTextField selectedField;
    private int selectedButtonType;
    private GSResource source;
    private GSResource target;
    private JButton ok;
    private JPanel buttonPanel;

    public CreateLinkDialog(AbstractGSWindow parent) {
        super(parent.getFrame(), "Link Dialog");
        this.toFront();
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new GridLayout(2, 1));
        this.mainPanel.add(this.createSourcePanel());
        this.mainPanel.add(this.createTargetPanel());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.pack();
        this.setResizable(false);
    }

    private JPanel createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.ok = new JButton("OK");
        this.ok.setEnabled(false);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateLinkDialog.this.ok();
            }
        });
        this.buttonPanel.add(this.ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CreateLinkDialog.this.dispose();
            }
        });
        this.buttonPanel.add(cancel);
        return this.buttonPanel;
    }

    private JPanel createSourcePanel() {
        this.sourcePanel = new JPanel(new GridLayout(2, 1));
        JPanel p1 = new JPanel(new FlowLayout(0));
        this.sourceField = new JTextField(20);
        this.sourceField.addCaretListener(this);
        JButton reference = new JButton("reference");
        reference.setEnabled(false);
        p1.add(this.sourceField);
        p1.add(reference);
        JPanel p2 = new JPanel(new FlowLayout(2));
        this.sourceSelect = new JButton("select by click");
        this.sourceSelect.addActionListener(this);
        p2.add(this.sourceSelect);
        this.sourcePanel.add(p1);
        this.sourcePanel.add(p2);
        this.sourcePanel.setBorder(new TitledBorder("Source"));
        return this.sourcePanel;
    }

    private JPanel createTargetPanel() {
        this.targetPanel = new JPanel(new GridLayout(2, 1));
        JPanel p1 = new JPanel(new FlowLayout(0));
        this.targetField = new JTextField(20);
        this.targetField.addCaretListener(this);
        JButton reference = new JButton("reference");
        reference.setEnabled(false);
        p1.add(this.targetField);
        p1.add(reference);
        JPanel p2 = new JPanel(new FlowLayout(2));
        this.targetSelect = new JButton("select by click");
        this.targetSelect.addActionListener(this);
        p2.add(this.targetSelect);
        this.targetPanel.add(p1);
        this.targetPanel.add(p2);
        this.targetPanel.setBorder(new TitledBorder("Target"));
        return this.targetPanel;
    }

    private void select() {
        JPanel panel = new JPanel();
        this.selectedField = new JTextField(20);
        panel.add(this.selectedField);
        JButton restore = new JButton("OK");
        restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CreateLinkDialog.this.restore();
            }
        });
        panel.add(restore);
        this.getContentPane().removeAll();
        this.getContentPane().add(panel);
        this.pack();
        this.validate();
    }

    private void restore() {
        this.getContentPane().removeAll();
        DefaultState.restoreDefaultState();
        EditorMouseListener.restoreDefaultMouseMode();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.validate();
    }

    @Override
    public void notifyResourceSelection(GSResource resource) {
        this.selectedField.setText(resource.getURI());
        this.getSelectedTextField().setText(resource.getURI());
        if (this.selectedButtonType == 0) {
            this.source = resource;
        } else {
            this.target = resource;
        }
    }

    private JTextField getSelectedTextField() {
        if (this.selectedButtonType == 0) {
            return this.sourceField;
        }
        return this.targetField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.sourceSelect)) {
            this.selectedButtonType = 0;
            ResourceSelectionMode listener = ResourceSelectionMode.getInstance();
            DefaultState.setDefaultState(RegionSelectionState.getInstance());
            ((RegionSelectionState)RegionSelectionState.getInstance()).addNotifyElement(this);
            listener.addNotifyElement(this);
            EditorMouseListener.setMouseMode(listener);
            this.select();
        } else if (e.getSource().equals(this.targetSelect)) {
            this.selectedButtonType = 1;
            ResourceSelectionMode listener = ResourceSelectionMode.getInstance();
            DefaultState.setDefaultState(RegionSelectionState.getInstance());
            ((RegionSelectionState)RegionSelectionState.getInstance()).addNotifyElement(this);
            listener.addNotifyElement(this);
            EditorMouseListener.setMouseMode(listener);
            this.select();
        }
    }

    @Override
    public void notifyRegionSelection(Region region) {
        this.notifyResourceSelection(region);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this.sourceField.getText().trim().equals("") && !this.targetField.getText().trim().equals("")) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    private void ok() {
        this.dispose();
        ConnectionCreator.setSource(this.source);
        ConnectionCreator.setTarget(this.target);
    }
}

