/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.connection;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import smart_gs.util.HrefChecker;

public class LinkChecker {
    protected HashMap<String, Integer> linkMap = new HashMap();

    public void parse(String source) {
        try {
            ParserDelegator pd = new ParserDelegator();
            LinkCheckerCallback cb = new LinkCheckerCallback();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(source.getBytes()), "UTF-8"));
            pd.parse(reader, cb, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HashMap<String, Integer> getLinkMap() {
        return this.linkMap;
    }

    class LinkCheckerCallback
    extends HTMLEditorKit.ParserCallback {
        LinkCheckerCallback() {
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attr, int pos) {
            if (tag.equals(HTML.Tag.A)) {
                String ret = (String)attr.getAttribute(HTML.Attribute.HREF);
                try {
                    int checkid = HrefChecker.check(ret);
                    if (checkid != -1) {
                        LinkChecker.this.linkMap.put(ret, new Integer(checkid));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

