/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.util.ArrayList;
import smart_gs.drawing_tool.DrawingModeSelectionPopupMenu;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultStateEvent;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.StateEvent;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.reasoning_web.swingui.GlobalViewPanel;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;

public class DefaultState
implements State {
    protected static DefaultState singleton = new DefaultState();
    private Mode mode;
    private ArrayList<StateEvent> eventList = new ArrayList();

    static {
        singleton.addSetmodeEvent(new DefaultStateEvent());
    }

    protected DefaultState() {
        this.mode = DefaultDrawingMode.getInstance();
    }

    public static DefaultState getInstance() {
        return singleton;
    }

    public void setMode(Mode mode) {
        this.mode.cancel();
        this.mode = mode;
        int i = 0;
        while (i < this.eventList.size()) {
            StateEvent stateEvent = this.eventList.get(i);
            stateEvent.setMoveEvent(mode);
            ++i;
        }
    }

    public static void setDefaultState(DefaultState state) {
        singleton = state;
        ImageLabel.setState(state);
    }

    public static void restoreDefaultState() {
        singleton = new DefaultState();
        ImageLabel.setState(singleton);
    }

    @Override
    public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
        if (e.getButton() == 1) {
            if (WorkspaceWindow.getInstance().onlyOneOfAltCtrlShiftIsPressed()) {
                if (WorkspaceWindow.getInstance().isAlt()) {
                    this.rightButtonClickAction(e);
                } else if (WorkspaceWindow.getInstance().isCtrl()) {
                    DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
                    ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeNone]);
                }
            } else {
                this.mode.mouseClicked(e, canvas);
            }
        } else if (e.getButton() == 3) {
            this.rightButtonClickAction(e);
        } else {
            this.mode.mouseClicked(e, canvas);
        }
    }

    private void rightButtonClickAction(GSMouseEvent e) {
        DrawingModeSelectionPopupMenu menu = new DrawingModeSelectionPopupMenu();
        menu.show(e.getComponent(), e.getOriginalPoint().x, e.getOriginalPoint().y);
        GlobalViewPanel.getInstance().repaint();
    }

    @Override
    public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseDragged(e, canvas);
    }

    @Override
    public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseEntered(e, canvas);
    }

    @Override
    public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseExited(e, canvas);
    }

    @Override
    public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseMoved(e, canvas);
    }

    @Override
    public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
        if (this.mode != EraserMode.getInstance()) {
            this.mode.mousePressed(e, canvas);
        }
        canvas.getSpread().clearSelection();
        if (!WorkspaceWindow.getInstance().isAlt() && canvas.containRegions(e.getPoint())) {
            this.mode.cancel();
            UniSelectedState state = UniSelectedState.getInstance();
            ImageLabel.setState(state);
            state.mousePressed(e, canvas);
        }
    }

    @Override
    public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
        this.mode.mouseReleased(e, canvas);
    }

    @Override
    public void paint(Graphics g, SpreadCanvas canvas) {
        this.mode.paint(g, canvas);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addSetmodeEvent(StateEvent stateEvent) {
        if (stateEvent != null) {
            this.eventList.add(stateEvent);
        }
    }

    @Override
    public int getType() {
        return 0;
    }
}

