/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search;

import image_search.ImageSearchAdapter;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import jp.ac.hokudai.meme.core_smart_gs.searcher.FoundRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.PagedRect;
import jp.ac.hokudai.meme.core_smart_gs.searcher.QueryRect;
import smart_gs.image_search.ExternalSearchEngineController;
import smart_gs.image_search.ImageSearchFilter;
import smart_gs.image_search.LineImageCropper;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.logical.TextType;
import smart_gs.image_search.normal.swingui.LabelMouseListener;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;

public class GSSearchEngine
extends ImageSearchAdapter {
    private static GSSearchEngine singleton = new GSSearchEngine();
    private List<SearchResult> gsResults;
    private List<Spread> spreads;
    private boolean useExternalEngine = true;
    private ArrayList<ImageSearchFilter> imageSearchFilterList = new ArrayList();

    public GSSearchEngine() {
        this.spreads = new ArrayList<Spread>();
        this.gsResults = new ArrayList<SearchResult>();
    }

    public static GSSearchEngine getInstance() {
        return singleton;
    }

    public void prepareSearch() {
        try {
            SpreadTree.getInstance().loadAllImages();
            List<File> files = SpreadTree.getInstance().getDSCFiles();
            this.setDSCFiles(files);
        }
        catch (OutOfMemoryError err) {
            JOptionPane.showMessageDialog(null, "couldn't load all images for memory shortage");
            return;
        }
        JOptionPane.showMessageDialog(null, "Images Loaded");
    }

    @Override
    public synchronized void execute() {
        if (!GSSearchEngine.singleton.useExternalEngine) {
            super.execute();
        } else {
            this.results = new ExternalSearchEngineController().search(this.query, this.spreads);
        }
        this.createResults();
    }

    private void createResults() {
        this.gsResults = new ArrayList<SearchResult>();
        if (this.results.getSize() < 1) {
            return;
        }
        double firstScore = this.results.getFoundRect(1).getscore();
        int i = 1;
        while (i <= this.results.getSize()) {
            block17: {
                Rectangle rectangleMapped;
                Shape shapeMapped;
                AffineTransform affineTransformFromDscToImage;
                SearchResult resultFilter;
                boolean isregist;
                SearchResult searchResult;
                int lineIndex;
                double score;
                int pageIndex;
                Rectangle resRect;
                FoundRect result = this.results.getFoundRect(i);
                PagedRect[] prects = result.getPRects();
                Rectangle firstRect = null;
                try {
                    firstRect = prects[0].getRect();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.out.println("");
                    break block17;
                }
                Rectangle lastRect = prects[prects.length - 1].getRect();
                if (TextType.isHorizontal()) {
                    int width = lastRect.x - firstRect.x + lastRect.width;
                    if (width < 0) {
                        width = (int)this.query.getRectangle().getWidth();
                    }
                    resRect = new Rectangle(firstRect.x, firstRect.y, width, firstRect.height);
                    pageIndex = prects[0].getPageIndex();
                    score = this.results.getScore(i);
                    lineIndex = prects[0].getLineIndex();
                    searchResult = new SearchResult(this.spreads.get(pageIndex), resRect, score /= firstScore, i, lineIndex);
                    isregist = true;
                    int j = 0;
                    while (j < this.imageSearchFilterList.size()) {
                        resultFilter = this.imageSearchFilterList.get(j).filter(searchResult);
                        if (resultFilter != null) {
                            isregist = true;
                            searchResult = resultFilter;
                            break;
                        }
                        isregist = false;
                        ++j;
                    }
                    if (isregist) {
                        Spread spread = searchResult.getSpread();
                        if (spread.isTransformationIsNecessary()) {
                            affineTransformFromDscToImage = spread.getAffineTranformFromDscToImg();
                            shapeMapped = affineTransformFromDscToImage.createTransformedShape(searchResult.getRectangle());
                            rectangleMapped = shapeMapped.getBounds();
                            searchResult.setRectangle(rectangleMapped);
                        }
                        this.gsResults.add(searchResult);
                    }
                } else {
                    int height = lastRect.y - firstRect.y + lastRect.height;
                    if (height < 0) {
                        height = (int)this.query.getRectangle().getHeight();
                    }
                    resRect = new Rectangle(firstRect.x, firstRect.y, firstRect.width, height);
                    pageIndex = prects[0].getPageIndex();
                    score = this.results.getScore(i);
                    lineIndex = prects[0].getLineIndex();
                    searchResult = new SearchResult(this.spreads.get(pageIndex), resRect, score /= firstScore, i, lineIndex);
                    isregist = true;
                    int j = 0;
                    while (j < this.imageSearchFilterList.size()) {
                        resultFilter = this.imageSearchFilterList.get(j).filter(searchResult);
                        if (resultFilter == null) {
                            isregist = false;
                        } else {
                            isregist = true;
                            searchResult = resultFilter;
                        }
                        ++j;
                    }
                    if (isregist) {
                        Spread spread = searchResult.getSpread();
                        if (spread.isTransformationIsNecessary()) {
                            affineTransformFromDscToImage = spread.getAffineTranformFromDscToImg();
                            shapeMapped = affineTransformFromDscToImage.createTransformedShape(searchResult.getRectangle());
                            rectangleMapped = shapeMapped.getBounds();
                            searchResult.setRectangle(rectangleMapped);
                        }
                        this.gsResults.add(searchResult);
                    }
                }
            }
            ++i;
        }
    }

    public SearchResult testChange(QueryRect QRect) {
        double firstScore = 1.0;
        Rectangle firstRect = QRect.getAllRects()[0].getRect();
        Rectangle lastRect = QRect.getAllRects()[QRect.getAllRects().length].getRect();
        int height = lastRect.y - firstRect.y + lastRect.height;
        Rectangle resRect = new Rectangle(firstRect.x, firstRect.y, firstRect.width, height);
        int pageIndex = QRect.getFirstPRect().getPageIndex();
        double score = 1.0;
        int lineIndex = QRect.getFirstPRect().getLineIndex();
        SearchResult result = new SearchResult(this.spreads.get(pageIndex), resRect, score /= firstScore, 1, lineIndex);
        return result;
    }

    public List<SearchResult> getResults() {
        return this.gsResults;
    }

    public void setSearchScope(List<Spread> spreads) {
        this.spreads = spreads;
        GSQuery q = (GSQuery)this.query;
        this.spreads.remove(q.getSpread());
        this.spreads.add(0, q.getSpread());
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < spreads.size()) {
            if (spreads.get(i).hasDscFile()) {
                files.add(spreads.get(i).getDscFile());
            }
            ++i;
        }
        this.setSearchScope(files);
    }

    public List<Spread> getSpreads() {
        return this.spreads;
    }

    protected JLabel createImageLabel(SearchResult result) {
        LineImageCropper cropper = new LineImageCropper(result);
        BufferedImage bufImage = cropper.crop();
        bufImage = (BufferedImage)cropper.fillRelative(bufImage);
        ImageIcon icon = new ImageIcon(bufImage);
        JLabel label = new JLabel();
        label.setIcon(icon);
        label.addMouseListener(new LabelMouseListener(label, result.getSpread(), result.getRectangle()));
        return label;
    }

    public boolean isUseExternalEngine() {
        return this.useExternalEngine;
    }

    public void setUseExternalEngine(boolean useExternalEngine) {
        this.useExternalEngine = useExternalEngine;
    }

    public void setImageSearchFilterList(ArrayList<ImageSearchFilter> imageSearchFilterList) {
        this.imageSearchFilterList = imageSearchFilterList;
    }
}

