/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.image_search.normal.swingui.ShowQueryAction;

public class BucketPanel
extends JPanel
implements Observer {
    private QueryBucket bucket;
    private JFrame parent;

    public BucketPanel(JFrame parent, QueryBucket bucket) {
        this.parent = parent;
        this.bucket = bucket;
        this.bucket.addObserver(this);
        this.updateGUI();
    }

    public void updateGUI() {
        this.removeAll();
        this.setLayout(new GridLayout(this.bucket.size(), 1));
        int i = 0;
        while (i < this.bucket.size()) {
            GSQuery query = this.bucket.get(i);
            JLabel label = i == 0 ? new JLabel(new ImageIcon(query.getQueryImageWithTransformation())) : new JLabel(new ImageIcon(query.getQueryImage()));
            label.addMouseListener(new ShowQueryAction(query));
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.BLACK));
            panel.add(label);
            this.add(panel);
            ++i;
        }
        this.parent.validate();
        this.parent.toFront();
        this.parent.pack();
    }

    @Override
    public void update() {
        this.updateGUI();
    }

    public QueryBucket getBucket() {
        return this.bucket;
    }
}

