/*
 * Decompiled with CFR 0.152.
 */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.normal.swingui.AbstractSearchResultPanel;
import smart_gs.image_search.normal.swingui.BucketFrame;
import smart_gs.image_search.normal.swingui.QueryPanel;
import smart_gs.image_search.normal.swingui.SearchMenuBar;
import smart_gs.image_search.normal.swingui.SearchResultPanelSegmentMode;
import smart_gs.logical.Spread;

public class SearchResultViewer
extends JFrame {
    private List<SearchResult> results;
    private List<SearchResult> newResults;
    private AbstractSearchResultPanel resultPanel;
    private JScrollPane scrollPane;
    private GSQuery query;
    private Image queryImage;
    private QueryBucket bucket;
    protected List<SearchResult> selectedResults;
    private JPanel mainPanel;
    protected List<SearchResult> removedResults;
    BucketFrame bucketFrame;
    private static int pSize;
    private String searchedPage;

    public SearchResultViewer(QueryBucket bucket, List<SearchResult> results) {
        super("Search Result");
        this.bucket = bucket;
        this.results = results;
        this.removedResults = new ArrayList<SearchResult>();
        pSize = bucket.size();
        this.newResults = new ArrayList<SearchResult>();
        int i = 0;
        while (i < results.size()) {
            if (!results.get(i).wasShown()) {
                this.newResults.add(results.get(i));
            }
            ++i;
        }
        this.query = this.bucket.get(0);
        this.selectedResults = new ArrayList<SearchResult>();
        this.checkDuplicate();
        this.queryImage = this.query.getQueryImageWithTransformation();
        this.build(this.queryImage);
        int size = this.bucket.size();
        this.bucketFrame = new BucketFrame(this.bucket, "Bucket", this.results, this.removedResults, size);
        this.bucketFrame.pack();
        this.setSize(1000, 730);
        this.bucketFrame.setVisible(true);
    }

    public SearchResultViewer(QueryBucket bucket, List<SearchResult> results, String searchedPage) {
        this(bucket, results);
        this.searchedPage = searchedPage;
    }

    public int getPreviousBucketSize() {
        return pSize;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public List<SearchResult> getNewResults() {
        return this.newResults;
    }

    public List<SearchResult> getRemovedResults() {
        return this.removedResults;
    }

    public void setResultPanel(AbstractSearchResultPanel resultPanel) {
        if (this.resultPanel instanceof SearchResultPanelSegmentMode) {
            this.mainPanel.remove(this.resultPanel);
        } else {
            this.mainPanel.remove(this.scrollPane);
        }
        this.resultPanel = resultPanel;
        if (this.resultPanel instanceof SearchResultPanelSegmentMode) {
            this.mainPanel.add((Component)this.resultPanel, "Center");
        } else {
            this.scrollPane.setViewportView(resultPanel);
            this.mainPanel.add((Component)this.scrollPane, "Center");
        }
    }

    private void checkDuplicate() {
        int i = 0;
        while (i < this.bucket.size()) {
            Rectangle rect = this.bucket.get(i).getRectangle();
            Spread spread = this.bucket.get(i).getSpread();
            Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
            if (spread != null) {
                int j = 0;
                while (j < this.results.size()) {
                    Rectangle rect2 = this.results.get(j).getRectangle();
                    Spread spread2 = this.results.get(j).getSpread();
                    if (spread.equals(spread2) && rect2.contains(center)) {
                        this.results.get(j).setIsInBucket(true);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public List<SearchResult> getSelectedResults() {
        return this.selectedResults;
    }

    public QueryBucket getBucket() {
        return this.bucket;
    }

    private void build(Image queryImage) {
        this.setDefaultCloseOperation(2);
        QueryPanel queryPanel = new QueryPanel(queryImage);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.resultPanel = new SearchResultPanelSegmentMode(this, this.results, queryImage);
        this.scrollPane.setViewportView(this.resultPanel);
        this.mainPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JButton back = new JButton("back");
        back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchResultViewer.this.resultPanel.back();
                SearchResultViewer.this.scrollPane.getVerticalScrollBar().setValue(0);
                SearchResultViewer.this.validate();
            }
        });
        JButton next = new JButton("next");
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchResultViewer.this.resultPanel.next();
                SearchResultViewer.this.scrollPane.getVerticalScrollBar().setValue(0);
                SearchResultViewer.this.validate();
            }
        });
        buttonPanel.add(back);
        buttonPanel.add(next);
        this.mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.add(queryPanel);
        this.mainPanel.add((Component)topPanel, "North");
        if (this.resultPanel instanceof SearchResultPanelSegmentMode) {
            this.mainPanel.add((Component)this.resultPanel, "Center");
        } else {
            this.mainPanel.add((Component)this.scrollPane, "Center");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel northPanel = new JPanel(new FlowLayout(0));
        northPanel.add(new SearchMenuBar(this));
        this.getContentPane().add((Component)northPanel, "North");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    public void updateBucket(boolean deleting) {
        if (deleting) {
            this.removeBucket();
        } else {
            this.addBucket();
        }
    }

    private void removeBucket() {
        GSQuery lastQuery = this.bucket.get(this.bucket.size() - 1);
        Rectangle rect = lastQuery.getRectangle();
        Spread spread = lastQuery.getSpread();
        Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
        int j = 0;
        while (j < this.results.size()) {
            Rectangle rect2 = this.results.get(j).getRectangle();
            Spread spread2 = this.results.get(j).getSpread();
            if (spread.equals(spread2) && rect2.contains(center)) {
                this.results.get(j).setIsInBucket(false);
            }
            ++j;
        }
        this.resultPanel.updateBucket();
    }

    public void addBucket() {
        GSQuery lastQuery = this.bucket.get(this.bucket.size() - 1);
        Rectangle rect = lastQuery.getRectangle();
        Spread spread = lastQuery.getSpread();
        Point2D.Double center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
        int j = 0;
        while (j < this.results.size()) {
            Rectangle rect2 = this.results.get(j).getRectangle();
            Spread spread2 = this.results.get(j).getSpread();
            if (spread.equals(spread2) && rect2.contains(center)) {
                this.results.get(j).setIsInBucket(true);
            }
            ++j;
        }
        this.resultPanel.updateBucket();
    }

    public void updateRemoved() {
        this.bucketFrame.setRemovedResults(this.removedResults);
    }

    public Image getQueryImage() {
        return this.queryImage;
    }
}

